/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.os.Looper;
import com.mopub.common.logging.MoPubLog;
import java.util.IllegalFormatException;

public final class Preconditions {
    public static final String EMPTY_ARGUMENTS = "";

    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        Preconditions.checkArgumentInternal(expression, true, "Illegal argument.", EMPTY_ARGUMENTS);
    }

    public static void checkArgument(boolean expression, String errorMessage) {
        Preconditions.checkArgumentInternal(expression, true, errorMessage, EMPTY_ARGUMENTS);
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkArgumentInternal(expression, true, errorMessageTemplate, errorMessageArgs);
    }

    public static void checkState(boolean expression) {
        Preconditions.checkStateInternal(expression, true, "Illegal state.", EMPTY_ARGUMENTS);
    }

    public static void checkState(boolean expression, String errorMessage) {
        Preconditions.checkStateInternal(expression, true, errorMessage, EMPTY_ARGUMENTS);
    }

    public static void checkState(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkStateInternal(expression, true, errorMessageTemplate, errorMessageArgs);
    }

    public static void checkNotNull(Object reference) {
        Preconditions.checkNotNullInternal(reference, true, "Object can not be null.", EMPTY_ARGUMENTS);
    }

    public static void checkNotNull(Object reference, String errorMessage) {
        Preconditions.checkNotNullInternal(reference, true, errorMessage, EMPTY_ARGUMENTS);
    }

    public static void checkNotNull(Object reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkNotNullInternal(reference, true, errorMessageTemplate, errorMessageArgs);
    }

    public static void checkUiThread() {
        Preconditions.checkUiThreadInternal(true, "This method must be called from the UI thread.", EMPTY_ARGUMENTS);
    }

    public static void checkUiThread(String errorMessage) {
        Preconditions.checkUiThreadInternal(true, errorMessage, EMPTY_ARGUMENTS);
    }

    public static void checkUiThread(String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkUiThreadInternal(true, errorMessageTemplate, errorMessageArgs);
    }

    private static boolean checkArgumentInternal(boolean expression, boolean allowThrow, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (expression) {
            return true;
        }
        String errorMessage = Preconditions.format(errorMessageTemplate, errorMessageArgs);
        if (allowThrow) {
            throw new IllegalArgumentException(errorMessage);
        }
        MoPubLog.e(errorMessage);
        return false;
    }

    private static boolean checkStateInternal(boolean expression, boolean allowThrow, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (expression) {
            return true;
        }
        String errorMessage = Preconditions.format(errorMessageTemplate, errorMessageArgs);
        if (allowThrow) {
            throw new IllegalStateException(errorMessage);
        }
        MoPubLog.e(errorMessage);
        return false;
    }

    private static boolean checkNotNullInternal(Object reference, boolean allowThrow, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference != null) {
            return true;
        }
        String errorMessage = Preconditions.format(errorMessageTemplate, errorMessageArgs);
        if (allowThrow) {
            throw new NullPointerException(errorMessage);
        }
        MoPubLog.e(errorMessage);
        return false;
    }

    private static boolean checkUiThreadInternal(boolean allowThrow, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (Looper.getMainLooper().equals(Looper.myLooper())) {
            return true;
        }
        String errorMessage = Preconditions.format(errorMessageTemplate, errorMessageArgs);
        if (allowThrow) {
            throw new IllegalStateException(errorMessage);
        }
        MoPubLog.e(errorMessage);
        return false;
    }

    private static String format(String template, Object ... args) {
        template = String.valueOf(template);
        try {
            return String.format(template, args);
        }
        catch (IllegalFormatException exception) {
            MoPubLog.e("MoPub preconditions had a format exception: " + exception.getMessage());
            return template;
        }
    }

    public static final class NoThrow {
        private static volatile boolean sStrictMode = false;

        public static void setStrictMode(boolean strictMode) {
            sStrictMode = strictMode;
        }

        public static boolean checkArgument(boolean expression) {
            return Preconditions.checkArgumentInternal(expression, NoThrow.sStrictMode, "Illegal argument", new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkArgument(boolean expression, String errorMessage) {
            return Preconditions.checkArgumentInternal(expression, NoThrow.sStrictMode, errorMessage, new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
            return Preconditions.checkArgumentInternal(expression, NoThrow.sStrictMode, errorMessageTemplate, errorMessageArgs);
        }

        public static boolean checkState(boolean expression) {
            return Preconditions.checkStateInternal(expression, NoThrow.sStrictMode, "Illegal state.", new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkState(boolean expression, String errorMessage) {
            return Preconditions.checkStateInternal(expression, NoThrow.sStrictMode, errorMessage, new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkState(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
            return Preconditions.checkStateInternal(expression, NoThrow.sStrictMode, errorMessageTemplate, errorMessageArgs);
        }

        public static boolean checkNotNull(Object reference) {
            return Preconditions.checkNotNullInternal(reference, NoThrow.sStrictMode, "Object can not be null.", new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkNotNull(Object reference, String errorMessage) {
            return Preconditions.checkNotNullInternal(reference, NoThrow.sStrictMode, errorMessage, new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkNotNull(Object reference, String errorMessageTemplate, Object ... errorMessageArgs) {
            return Preconditions.checkNotNullInternal(reference, NoThrow.sStrictMode, errorMessageTemplate, errorMessageArgs);
        }

        public static boolean checkUiThread() {
            return Preconditions.checkUiThreadInternal(NoThrow.sStrictMode, "This method must be called from the UI thread.", new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkUiThread(String errorMessage) {
            return Preconditions.checkUiThreadInternal(NoThrow.sStrictMode, errorMessage, new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkUiThread(String errorMessageTemplate, Object ... errorMessageArgs) {
            return Preconditions.checkUiThreadInternal(false, errorMessageTemplate, errorMessageArgs);
        }
    }
}

