/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.webkit.WebView;
import com.mopub.common.ExternalViewabilitySession;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Reflection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MoatViewabilitySession
implements ExternalViewabilitySession {
    private static final String MOAT_FACTORY_PATH = "com.moat.analytics.mobile.mpub.MoatFactory";
    private static final String MOAT_OPTIONS_PATH = "com.moat.analytics.mobile.mpub.MoatOptions";
    private static final String MOAT_ANALYTICS_PATH = "com.moat.analytics.mobile.mpub.MoatAnalytics";
    private static final String MOAT_AD_EVENT_PATH = "com.moat.analytics.mobile.mpub.MoatAdEvent";
    private static final String MOAT_AD_EVENT_TYPE_PATH = "com.moat.analytics.mobile.mpub.MoatAdEventType";
    private static final String MOAT_REACTIVE_VIDEO_TRACKER_PLUGIN_PATH = "com.moat.analytics.mobile.mpub.ReactiveVideoTrackerPlugin";
    private static final String MOAT_PLUGIN_PATH = "com.moat.analytics.mobile.mpub.MoatPlugin";
    private static final String PARTNER_CODE_KEY = "partnerCode";
    private static final String DEFAULT_PARTNER_CODE = "mopubinapphtmvideo468906546585";
    private static final String MOAT_KEY = "moat";
    private static final String MOAT_VAST_IDS_KEY = "zMoatVASTIDs";
    private static Boolean sIsViewabilityEnabledViaReflection;
    private static boolean sIsVendorDisabled;
    private static boolean sWasInitialized;
    private static final Map<String, String> QUERY_PARAM_MAPPING;
    @Nullable
    private Object mMoatWebAdTracker;
    @Nullable
    private Object mMoatVideoTracker;
    @NonNull
    private Map<String, String> mAdIds = new HashMap<String, String>();
    private boolean mWasVideoPrepared;

    MoatViewabilitySession() {
    }

    static boolean isEnabled() {
        return !sIsVendorDisabled && MoatViewabilitySession.isViewabilityEnabledViaReflection();
    }

    static void disable() {
        sIsVendorDisabled = true;
    }

    private static boolean isViewabilityEnabledViaReflection() {
        if (sIsViewabilityEnabledViaReflection == null) {
            sIsViewabilityEnabledViaReflection = Reflection.classFound(MOAT_FACTORY_PATH);
            MoPubLog.d("Moat is " + (sIsViewabilityEnabledViaReflection != false ? "" : "un") + "available via reflection.");
        }
        return sIsViewabilityEnabledViaReflection;
    }

    @Override
    @NonNull
    public String getName() {
        return "Moat";
    }

    @Override
    @Nullable
    public Boolean initialize(@NonNull Context context) {
        Application application;
        Preconditions.checkNotNull(context);
        if (!MoatViewabilitySession.isEnabled()) {
            return null;
        }
        if (sWasInitialized) {
            return true;
        }
        if (context instanceof Activity) {
            application = ((Activity)context).getApplication();
        } else {
            try {
                application = (Application)context.getApplicationContext();
            }
            catch (ClassCastException e) {
                MoPubLog.d("Unable to initialize Moat, error obtaining application context.");
                return false;
            }
        }
        try {
            Object moatOptions = Reflection.instantiateClassWithEmptyConstructor(MOAT_OPTIONS_PATH, Object.class);
            moatOptions.getClass().getField("disableAdIdCollection").setBoolean(moatOptions, true);
            moatOptions.getClass().getField("disableLocationServices").setBoolean(moatOptions, true);
            Object moatAnalytics = new Reflection.MethodBuilder(null, "getInstance").setStatic(MOAT_ANALYTICS_PATH).execute();
            new Reflection.MethodBuilder(moatAnalytics, "start").addParam(MOAT_OPTIONS_PATH, moatOptions).addParam(Application.class, application).execute();
            sWasInitialized = true;
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to initialize Moat: " + e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Boolean invalidate() {
        if (!MoatViewabilitySession.isEnabled()) {
            return null;
        }
        this.mMoatWebAdTracker = null;
        this.mMoatVideoTracker = null;
        this.mAdIds.clear();
        return true;
    }

    @Override
    @Nullable
    public Boolean createDisplaySession(@NonNull Context context, @NonNull WebView webView, boolean isDeferred) {
        Preconditions.checkNotNull(context);
        if (!MoatViewabilitySession.isEnabled()) {
            return null;
        }
        try {
            Object moatFactory = new Reflection.MethodBuilder(null, "create").setStatic(MOAT_FACTORY_PATH).execute();
            this.mMoatWebAdTracker = new Reflection.MethodBuilder(moatFactory, "createWebAdTracker").addParam(WebView.class, webView).execute();
            if (!isDeferred) {
                new Reflection.MethodBuilder(this.mMoatWebAdTracker, "startTracking").execute();
            }
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to execute Moat start display session: " + e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Boolean startDeferredDisplaySession(@NonNull Activity activity) {
        if (!MoatViewabilitySession.isEnabled()) {
            return null;
        }
        if (this.mMoatWebAdTracker == null) {
            MoPubLog.d("MoatWebAdTracker unexpectedly null.");
            return false;
        }
        try {
            new Reflection.MethodBuilder(this.mMoatWebAdTracker, "startTracking").execute();
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to record deferred display session for Moat: " + e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Boolean endDisplaySession() {
        if (!MoatViewabilitySession.isEnabled()) {
            return null;
        }
        if (this.mMoatWebAdTracker == null) {
            MoPubLog.d("Moat WebAdTracker unexpectedly null.");
            return false;
        }
        try {
            new Reflection.MethodBuilder(this.mMoatWebAdTracker, "stopTracking").execute();
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to execute Moat end session: " + e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Boolean createVideoSession(@NonNull Activity activity, @NonNull View view, @NonNull Set<String> buyerResources, @NonNull Map<String, String> videoViewabilityTrackers) {
        Preconditions.checkNotNull(activity);
        Preconditions.checkNotNull(view);
        Preconditions.checkNotNull(buyerResources);
        Preconditions.checkNotNull(videoViewabilityTrackers);
        if (!MoatViewabilitySession.isEnabled()) {
            return null;
        }
        this.updateAdIdsFromUrlStringAndBuyerResources(videoViewabilityTrackers.get(MOAT_KEY), buyerResources);
        String partnerCode = this.mAdIds.get(PARTNER_CODE_KEY);
        if (TextUtils.isEmpty((CharSequence)partnerCode)) {
            MoPubLog.d("partnerCode was empty when starting Moat video session");
            return false;
        }
        try {
            Object moatPlugin = Reflection.instantiateClassWithConstructor(MOAT_REACTIVE_VIDEO_TRACKER_PLUGIN_PATH, Object.class, new Class[]{String.class}, new Object[]{partnerCode});
            Object moatFactory = new Reflection.MethodBuilder(null, "create").setStatic(MOAT_FACTORY_PATH).execute();
            this.mMoatVideoTracker = new Reflection.MethodBuilder(moatFactory, "createCustomTracker").addParam(MOAT_PLUGIN_PATH, moatPlugin).execute();
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to execute Moat start video session: " + e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Boolean registerVideoObstruction(@NonNull View view) {
        Preconditions.checkNotNull(view);
        if (!MoatViewabilitySession.isEnabled()) {
            return null;
        }
        return true;
    }

    @Override
    @Nullable
    public Boolean onVideoPrepared(@NonNull View playerView, int duration) {
        Preconditions.checkNotNull(playerView);
        if (!MoatViewabilitySession.isEnabled()) {
            return null;
        }
        if (this.mMoatVideoTracker == null) {
            MoPubLog.d("Moat VideoAdTracker unexpectedly null.");
            return false;
        }
        if (this.mWasVideoPrepared) {
            return false;
        }
        try {
            new Reflection.MethodBuilder(this.mMoatVideoTracker, "trackVideoAd").addParam(Map.class, this.mAdIds).addParam(Integer.class, duration).addParam(View.class, playerView).execute();
            this.mWasVideoPrepared = true;
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to execute Moat onVideoPrepared: " + e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Boolean recordVideoEvent(@NonNull ExternalViewabilitySession.VideoEvent event, int playheadMillis) {
        Preconditions.checkNotNull((Object)event);
        if (!MoatViewabilitySession.isEnabled()) {
            return null;
        }
        if (this.mMoatVideoTracker == null) {
            MoPubLog.d("Moat VideoAdTracker unexpectedly null.");
            return false;
        }
        try {
            switch (event) {
                case AD_STARTED: 
                case AD_STOPPED: 
                case AD_PAUSED: 
                case AD_PLAYING: 
                case AD_SKIPPED: 
                case AD_VIDEO_FIRST_QUARTILE: 
                case AD_VIDEO_MIDPOINT: 
                case AD_VIDEO_THIRD_QUARTILE: 
                case AD_COMPLETE: {
                    this.handleVideoEventReflection(event, playheadMillis);
                    return true;
                }
                case AD_LOADED: 
                case AD_IMPRESSED: 
                case AD_CLICK_THRU: 
                case RECORD_AD_ERROR: {
                    return null;
                }
            }
            MoPubLog.d("Unexpected video event: " + event.getMoatEnumName());
            return false;
        }
        catch (Exception e) {
            MoPubLog.d("Video event " + event.getMoatEnumName() + " failed. " + e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Boolean endVideoSession() {
        if (!MoatViewabilitySession.isEnabled()) {
            return null;
        }
        if (this.mMoatVideoTracker == null) {
            MoPubLog.d("Moat VideoAdTracker unexpectedly null.");
            return false;
        }
        try {
            new Reflection.MethodBuilder(this.mMoatVideoTracker, "stopTracking").execute();
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to execute Moat end video session: " + e.getMessage());
            return false;
        }
    }

    private void updateAdIdsFromUrlStringAndBuyerResources(@Nullable String urlString, @Nullable Set<String> buyerResources) {
        String fragment;
        this.mAdIds.clear();
        this.mAdIds.put(PARTNER_CODE_KEY, DEFAULT_PARTNER_CODE);
        this.mAdIds.put(MOAT_VAST_IDS_KEY, TextUtils.join((CharSequence)";", buyerResources));
        if (TextUtils.isEmpty((CharSequence)urlString)) {
            return;
        }
        Uri uri = Uri.parse((String)urlString);
        List pathSegments = uri.getPathSegments();
        if (pathSegments.size() > 0 && !TextUtils.isEmpty((CharSequence)((CharSequence)pathSegments.get(0)))) {
            this.mAdIds.put(PARTNER_CODE_KEY, (String)pathSegments.get(0));
        }
        if (!TextUtils.isEmpty((CharSequence)(fragment = uri.getFragment()))) {
            for (String fragmentPairs : fragment.split("&")) {
                String[] fragmentPair = fragmentPairs.split("=");
                if (fragmentPair.length < 2) continue;
                String fragmentKey = fragmentPair[0];
                String fragmentValue = fragmentPair[1];
                if (TextUtils.isEmpty((CharSequence)fragmentKey) || TextUtils.isEmpty((CharSequence)fragmentValue) || !QUERY_PARAM_MAPPING.containsKey(fragmentKey)) continue;
                this.mAdIds.put(QUERY_PARAM_MAPPING.get(fragmentKey), fragmentValue);
            }
        }
    }

    private boolean handleVideoEventReflection(@NonNull ExternalViewabilitySession.VideoEvent videoEvent, int playheadMillis) throws Exception {
        if (videoEvent.getMoatEnumName() == null) {
            return false;
        }
        Class<?> clazz = Class.forName(MOAT_AD_EVENT_TYPE_PATH);
        Enum adEventTypeEnum = Enum.valueOf(clazz.asSubclass(Enum.class), videoEvent.getMoatEnumName());
        Object moatAdEvent = Reflection.instantiateClassWithConstructor(MOAT_AD_EVENT_PATH, Object.class, new Class[]{clazz, Integer.class}, new Object[]{adEventTypeEnum, playheadMillis});
        new Reflection.MethodBuilder(this.mMoatVideoTracker, "dispatchEvent").addParam(MOAT_AD_EVENT_PATH, moatAdEvent).execute();
        return true;
    }

    static {
        sWasInitialized = false;
        QUERY_PARAM_MAPPING = new HashMap<String, String>();
        QUERY_PARAM_MAPPING.put("moatClientLevel1", "level1");
        QUERY_PARAM_MAPPING.put("moatClientLevel2", "level2");
        QUERY_PARAM_MAPPING.put("moatClientLevel3", "level3");
        QUERY_PARAM_MAPPING.put("moatClientLevel4", "level4");
        QUERY_PARAM_MAPPING.put("moatClientSlicer1", "slicer1");
        QUERY_PARAM_MAPPING.put("moatClientSlicer2", "slicer2");
    }
}

