/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.LifecycleListener;
import com.mopub.common.MoPub;
import com.mopub.common.privacy.PersonalInfoManager;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;

public class MoPubLifecycleManager
implements LifecycleListener {
    private static MoPubLifecycleManager sInstance;
    @NonNull
    private final Set<LifecycleListener> mLifecycleListeners = new HashSet<LifecycleListener>();
    @NonNull
    private final WeakReference<Activity> mMainActivity;

    private MoPubLifecycleManager(Activity mainActivity) {
        this.mMainActivity = new WeakReference<Activity>(mainActivity);
    }

    @NonNull
    public static synchronized MoPubLifecycleManager getInstance(Activity mainActivity) {
        if (sInstance == null) {
            sInstance = new MoPubLifecycleManager(mainActivity);
        }
        return sInstance;
    }

    public void addLifecycleListener(@Nullable LifecycleListener listener) {
        Activity activity;
        if (listener == null) {
            return;
        }
        if (this.mLifecycleListeners.add(listener) && (activity = (Activity)this.mMainActivity.get()) != null) {
            listener.onCreate(activity);
            listener.onStart(activity);
        }
    }

    @Override
    public void onCreate(@NonNull Activity activity) {
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onCreate(activity);
        }
    }

    @Override
    public void onStart(@NonNull Activity activity) {
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onStart(activity);
        }
    }

    @Override
    public void onPause(@NonNull Activity activity) {
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onPause(activity);
        }
    }

    @Override
    public void onResume(@NonNull Activity activity) {
        PersonalInfoManager personalInfoManager = MoPub.getPersonalInformationManager();
        if (personalInfoManager != null) {
            personalInfoManager.requestSync(false);
        }
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onResume(activity);
        }
    }

    @Override
    public void onRestart(@NonNull Activity activity) {
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onRestart(activity);
        }
    }

    @Override
    public void onStop(@NonNull Activity activity) {
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onStop(activity);
        }
    }

    @Override
    public void onDestroy(@NonNull Activity activity) {
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onDestroy(activity);
        }
    }

    @Override
    public void onBackPressed(@NonNull Activity activity) {
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onBackPressed(activity);
        }
    }
}

