/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.AdvancedBiddingTokens;
import com.mopub.common.ClientMetadata;
import com.mopub.common.CompositeSdkInitializationListener;
import com.mopub.common.ExternalViewabilitySessionManager;
import com.mopub.common.MoPubLifecycleManager;
import com.mopub.common.Preconditions;
import com.mopub.common.SdkConfiguration;
import com.mopub.common.SdkInitializationListener;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.privacy.PersonalInfoManager;
import com.mopub.common.util.Reflection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MoPub {
    public static final String SDK_VERSION = "5.4.0";
    private static final String MOPUB_REWARDED_VIDEOS = "com.mopub.mobileads.MoPubRewardedVideos";
    private static final String MOPUB_REWARDED_VIDEO_MANAGER = "com.mopub.mobileads.MoPubRewardedVideoManager";
    private static final int DEFAULT_LOCATION_PRECISION = 6;
    private static final long DEFAULT_LOCATION_REFRESH_TIME_MILLIS = 60000L;
    @NonNull
    private static volatile LocationAwareness sLocationAwareness = LocationAwareness.NORMAL;
    private static volatile int sLocationPrecision = 6;
    private static volatile long sMinimumLocationRefreshTimeMillis = 60000L;
    @NonNull
    private static volatile BrowserAgent sBrowserAgent = BrowserAgent.IN_APP;
    private static volatile boolean sIsBrowserAgentOverriddenByClient = false;
    private static boolean sSearchedForUpdateActivityMethod = false;
    @Nullable
    private static Method sUpdateActivityMethod;
    private static boolean sAdvancedBiddingEnabled;
    private static boolean sSdkInitialized;
    private static boolean sSdkInitializing;
    private static AdvancedBiddingTokens sAdvancedBiddingTokens;
    private static PersonalInfoManager sPersonalInfoManager;

    @NonNull
    public static LocationAwareness getLocationAwareness() {
        Preconditions.checkNotNull((Object)sLocationAwareness);
        return sLocationAwareness;
    }

    public static void setLocationAwareness(@NonNull LocationAwareness locationAwareness) {
        Preconditions.checkNotNull((Object)locationAwareness);
        sLocationAwareness = locationAwareness;
    }

    public static int getLocationPrecision() {
        return sLocationPrecision;
    }

    public static void setLocationPrecision(int precision) {
        sLocationPrecision = Math.min(Math.max(0, precision), 6);
    }

    public static void setMinimumLocationRefreshTimeMillis(long minimumLocationRefreshTimeMillis) {
        sMinimumLocationRefreshTimeMillis = minimumLocationRefreshTimeMillis;
    }

    public static long getMinimumLocationRefreshTimeMillis() {
        return sMinimumLocationRefreshTimeMillis;
    }

    public static void setBrowserAgent(@NonNull BrowserAgent browserAgent) {
        Preconditions.checkNotNull((Object)browserAgent);
        sBrowserAgent = browserAgent;
        sIsBrowserAgentOverriddenByClient = true;
    }

    public static void setBrowserAgentFromAdServer(@NonNull BrowserAgent adServerBrowserAgent) {
        Preconditions.checkNotNull((Object)adServerBrowserAgent);
        if (sIsBrowserAgentOverriddenByClient) {
            MoPubLog.w("Browser agent already overridden by client with value " + (Object)((Object)sBrowserAgent));
        } else {
            sBrowserAgent = adServerBrowserAgent;
        }
    }

    @NonNull
    public static BrowserAgent getBrowserAgent() {
        Preconditions.checkNotNull((Object)sBrowserAgent);
        return sBrowserAgent;
    }

    public static void setAdvancedBiddingEnabled(boolean advancedBiddingEnabled) {
        sAdvancedBiddingEnabled = advancedBiddingEnabled;
    }

    public static boolean isAdvancedBiddingEnabled() {
        return sAdvancedBiddingEnabled;
    }

    public static void initializeSdk(@NonNull Context context, @NonNull SdkConfiguration sdkConfiguration, @Nullable SdkInitializationListener sdkInitializationListener) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(sdkConfiguration);
        MoPubLog.d("Initializing MoPub with ad unit: " + sdkConfiguration.getAdUnitId());
        if (context instanceof Activity && Reflection.classFound(MOPUB_REWARDED_VIDEO_MANAGER)) {
            Activity activity = (Activity)context;
            MoPub.initializeRewardedVideo(activity, sdkConfiguration);
        }
        if (sSdkInitialized) {
            MoPubLog.d("MoPub SDK is already initialized");
            MoPub.initializationFinished(sdkInitializationListener);
            return;
        }
        if (sSdkInitializing) {
            MoPubLog.d("MoPub SDK is currently initializing.");
            return;
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            MoPubLog.e("MoPub can only be initialized on the main thread.");
            return;
        }
        sSdkInitializing = true;
        InternalSdkInitializationListener internalSdkInitializationListener = new InternalSdkInitializationListener(sdkInitializationListener);
        CompositeSdkInitializationListener compositeSdkInitializationListener = new CompositeSdkInitializationListener(internalSdkInitializationListener, 2);
        sPersonalInfoManager = new PersonalInfoManager(context, sdkConfiguration.getAdUnitId(), compositeSdkInitializationListener);
        ClientMetadata.getInstance(context);
        sAdvancedBiddingTokens = new AdvancedBiddingTokens(compositeSdkInitializationListener);
        sAdvancedBiddingTokens.addAdvancedBidders(sdkConfiguration.getAdvancedBidders());
    }

    public static boolean isSdkInitialized() {
        return sSdkInitialized;
    }

    public static boolean canCollectPersonalInformation() {
        return sPersonalInfoManager != null && sPersonalInfoManager.canCollectPersonalInformation();
    }

    @Nullable
    static String getAdvancedBiddingTokensJson(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        if (!MoPub.isAdvancedBiddingEnabled() || sAdvancedBiddingTokens == null) {
            return null;
        }
        return sAdvancedBiddingTokens.getTokensAsJsonString(context);
    }

    @Nullable
    public static PersonalInfoManager getPersonalInformationManager() {
        return sPersonalInfoManager;
    }

    @VisibleForTesting
    static boolean isBrowserAgentOverriddenByClient() {
        return sIsBrowserAgentOverriddenByClient;
    }

    @Deprecated
    @VisibleForTesting
    public static void resetBrowserAgent() {
        sBrowserAgent = BrowserAgent.IN_APP;
        sIsBrowserAgentOverriddenByClient = false;
    }

    public static void onCreate(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onCreate(activity);
        MoPub.updateActivity(activity);
    }

    public static void onStart(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onStart(activity);
        MoPub.updateActivity(activity);
    }

    public static void onPause(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onPause(activity);
    }

    public static void onResume(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onResume(activity);
        MoPub.updateActivity(activity);
    }

    public static void onRestart(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onRestart(activity);
        MoPub.updateActivity(activity);
    }

    public static void onStop(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onStop(activity);
    }

    public static void onDestroy(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onDestroy(activity);
    }

    public static void onBackPressed(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onBackPressed(activity);
    }

    public static void disableViewability(@NonNull ExternalViewabilitySessionManager.ViewabilityVendor vendor) {
        Preconditions.checkNotNull((Object)vendor);
        vendor.disable();
    }

    private static void initializeRewardedVideo(@NonNull Activity activity, @NonNull SdkConfiguration sdkConfiguration) {
        Preconditions.checkNotNull(activity);
        Preconditions.checkNotNull(sdkConfiguration);
        try {
            new Reflection.MethodBuilder(null, "initializeRewardedVideo").setStatic(Class.forName(MOPUB_REWARDED_VIDEOS)).setAccessible().addParam(Activity.class, activity).addParam(SdkConfiguration.class, sdkConfiguration).execute();
        }
        catch (ClassNotFoundException e) {
            MoPubLog.w("initializeRewardedVideo was called without the rewarded video module");
        }
        catch (NoSuchMethodException e) {
            MoPubLog.w("initializeRewardedVideo was called without the rewarded video module");
        }
        catch (Exception e) {
            MoPubLog.e("Error while initializing rewarded video", e);
        }
    }

    private static void initializationFinished(final @Nullable SdkInitializationListener sdkInitializationListener) {
        sSdkInitializing = false;
        sSdkInitialized = true;
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (sdkInitializationListener != null) {
                    sdkInitializationListener.onInitializationFinished();
                }
            }
        });
    }

    @VisibleForTesting
    static void updateActivity(@NonNull Activity activity) {
        if (!sSearchedForUpdateActivityMethod) {
            sSearchedForUpdateActivityMethod = true;
            try {
                Class<?> moPubRewardedVideoManagerClass = Class.forName(MOPUB_REWARDED_VIDEO_MANAGER);
                sUpdateActivityMethod = Reflection.getDeclaredMethodWithTraversal(moPubRewardedVideoManagerClass, "updateActivity", Activity.class);
            }
            catch (ClassNotFoundException moPubRewardedVideoManagerClass) {
            }
            catch (NoSuchMethodException moPubRewardedVideoManagerClass) {
                // empty catch block
            }
        }
        if (sUpdateActivityMethod != null) {
            try {
                sUpdateActivityMethod.invoke(null, activity);
            }
            catch (IllegalAccessException e) {
                MoPubLog.e("Error while attempting to access the update activity method - this should not have happened", e);
            }
            catch (InvocationTargetException e) {
                MoPubLog.e("Error while attempting to access the update activity method - this should not have happened", e);
            }
        }
    }

    @Deprecated
    @VisibleForTesting
    static void clearAdvancedBidders() {
        sAdvancedBiddingTokens = null;
        sPersonalInfoManager = null;
        sSdkInitialized = false;
    }

    @Deprecated
    @VisibleForTesting
    static void setPersonalInfoManager(@Nullable PersonalInfoManager personalInfoManager) {
        sPersonalInfoManager = personalInfoManager;
    }

    static {
        sAdvancedBiddingEnabled = true;
        sSdkInitialized = false;
        sSdkInitializing = false;
    }

    private static class InternalSdkInitializationListener
    implements SdkInitializationListener {
        @Nullable
        private SdkInitializationListener mSdkInitializationListener;

        InternalSdkInitializationListener(@Nullable SdkInitializationListener sdkInitializationListener) {
            this.mSdkInitializationListener = sdkInitializationListener;
        }

        @Override
        public void onInitializationFinished() {
            MoPub.initializationFinished(this.mSdkInitializationListener);
            this.mSdkInitializationListener = null;
        }
    }

    public static enum BrowserAgent {
        IN_APP,
        NATIVE;


        @NonNull
        public static BrowserAgent fromHeader(@Nullable Integer browserAgent) {
            if (browserAgent == null) {
                return IN_APP;
            }
            return browserAgent == 1 ? NATIVE : IN_APP;
        }
    }

    public static enum LocationAwareness {
        NORMAL,
        TRUNCATED,
        DISABLED;

    }
}

