/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import java.math.BigDecimal;

public class LocationService {
    private static volatile LocationService sInstance;
    @VisibleForTesting
    @Nullable
    Location mLastKnownLocation;
    @VisibleForTesting
    long mLocationLastUpdatedMillis;

    private LocationService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @NonNull
    static LocationService getInstance() {
        LocationService locationService = sInstance;
        if (locationService != null) return locationService;
        Class<LocationService> clazz = LocationService.class;
        synchronized (LocationService.class) {
            locationService = sInstance;
            if (locationService != null) return locationService;
            sInstance = locationService = new LocationService();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return locationService;
        }
    }

    @Nullable
    public static Location getLastKnownLocation(@NonNull Context context, int locationPrecision, @NonNull MoPub.LocationAwareness locationAwareness) {
        if (!MoPub.canCollectPersonalInformation()) {
            return null;
        }
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull((Object)locationAwareness);
        if (locationAwareness == MoPub.LocationAwareness.DISABLED) {
            return null;
        }
        LocationService locationService = LocationService.getInstance();
        if (LocationService.isLocationFreshEnough()) {
            return locationService.mLastKnownLocation;
        }
        Location gpsLocation = LocationService.getLocationFromProvider(context, ValidLocationProvider.GPS);
        Location networkLocation = LocationService.getLocationFromProvider(context, ValidLocationProvider.NETWORK);
        Location result = LocationService.getMostRecentValidLocation(gpsLocation, networkLocation);
        if (locationAwareness == MoPub.LocationAwareness.TRUNCATED) {
            LocationService.truncateLocationLatLon(result, locationPrecision);
        }
        locationService.mLastKnownLocation = result;
        locationService.mLocationLastUpdatedMillis = SystemClock.elapsedRealtime();
        return result;
    }

    @VisibleForTesting
    @Nullable
    static Location getLocationFromProvider(@NonNull Context context, @NonNull ValidLocationProvider provider) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull((Object)provider);
        if (!MoPub.canCollectPersonalInformation()) {
            return null;
        }
        if (!provider.hasRequiredPermissions(context)) {
            return null;
        }
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        try {
            return locationManager.getLastKnownLocation(provider.toString());
        }
        catch (SecurityException e) {
            MoPubLog.d("Failed to retrieve location from " + provider.toString() + " provider: access appears to be disabled.");
        }
        catch (IllegalArgumentException e) {
            MoPubLog.d("Failed to retrieve location: device has no " + provider.toString() + " location provider.");
        }
        catch (NullPointerException e) {
            MoPubLog.d("Failed to retrieve location: device has no " + provider.toString() + " location provider.");
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static Location getMostRecentValidLocation(@Nullable Location a, @Nullable Location b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.getTime() > b.getTime() ? a : b;
    }

    @VisibleForTesting
    static void truncateLocationLatLon(@Nullable Location location, int precision) {
        if (location == null || precision < 0) {
            return;
        }
        double lat = location.getLatitude();
        double truncatedLat = BigDecimal.valueOf(lat).setScale(precision, 5).doubleValue();
        location.setLatitude(truncatedLat);
        double lon = location.getLongitude();
        double truncatedLon = BigDecimal.valueOf(lon).setScale(precision, 5).doubleValue();
        location.setLongitude(truncatedLon);
    }

    private static boolean isLocationFreshEnough() {
        LocationService locationService = LocationService.getInstance();
        if (locationService.mLastKnownLocation == null) {
            return false;
        }
        return SystemClock.elapsedRealtime() - locationService.mLocationLastUpdatedMillis <= MoPub.getMinimumLocationRefreshTimeMillis();
    }

    @Deprecated
    @VisibleForTesting
    public static void clearLastKnownLocation() {
        LocationService.getInstance().mLastKnownLocation = null;
    }

    public static enum ValidLocationProvider {
        NETWORK("network"),
        GPS("gps");

        @NonNull
        final String name;

        private ValidLocationProvider(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private boolean hasRequiredPermissions(@NonNull Context context) {
            switch (this) {
                case NETWORK: {
                    return DeviceUtils.isPermissionGranted(context, "android.permission.ACCESS_FINE_LOCATION") || DeviceUtils.isPermissionGranted(context, "android.permission.ACCESS_COARSE_LOCATION");
                }
                case GPS: {
                    return DeviceUtils.isPermissionGranted(context, "android.permission.ACCESS_FINE_LOCATION");
                }
            }
            return false;
        }
    }

    public static enum LocationAwareness {
        NORMAL,
        TRUNCATED,
        DISABLED;


        @Deprecated
        public MoPub.LocationAwareness getNewLocationAwareness() {
            if (this == TRUNCATED) {
                return MoPub.LocationAwareness.TRUNCATED;
            }
            if (this == DISABLED) {
                return MoPub.LocationAwareness.DISABLED;
            }
            return MoPub.LocationAwareness.NORMAL;
        }

        @Deprecated
        public static LocationAwareness fromMoPubLocationAwareness(MoPub.LocationAwareness awareness) {
            if (awareness == MoPub.LocationAwareness.DISABLED) {
                return DISABLED;
            }
            if (awareness == MoPub.LocationAwareness.TRUNCATED) {
                return TRUNCATED;
            }
            return NORMAL;
        }
    }
}

