/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.Nullable;
import com.mopub.common.SharedPreferencesHelper;
import com.mopub.common.factories.MethodBuilderFactory;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.AsyncTasks;
import com.mopub.common.util.Reflection;
import java.lang.ref.WeakReference;

public class GpsHelper {
    public static final int GOOGLE_PLAY_SUCCESS_CODE = 0;
    public static final int SERVICE_VERSION_UPDATE_REQUIRED = 2;
    public static final String ADVERTISING_ID_KEY = "advertisingId";
    public static final String IS_LIMIT_AD_TRACKING_ENABLED_KEY = "isLimitAdTrackingEnabled";
    private static String sPlayServicesUtilClassName = "com.google.android.gms.common.GooglePlayServicesUtil";
    private static String sAdvertisingIdClientClassName = "com.google.android.gms.ads.identifier.AdvertisingIdClient";

    public static boolean isPlayServicesAvailable(Context context) {
        try {
            Reflection.MethodBuilder methodBuilder = MethodBuilderFactory.create(null, "isGooglePlayServicesAvailable").setStatic(Class.forName(sPlayServicesUtilClassName)).addParam(Context.class, context);
            Object result = methodBuilder.execute();
            Integer intResult = (Integer)result;
            return intResult != null && (intResult == 0 || intResult == 2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isLimitAdTrackingEnabled(Context context) {
        boolean defaultValue = false;
        if (GpsHelper.isPlayServicesAvailable(context)) {
            return SharedPreferencesHelper.getSharedPreferences(context).getBoolean(IS_LIMIT_AD_TRACKING_ENABLED_KEY, false);
        }
        return false;
    }

    public static void fetchAdvertisingInfoAsync(Context context, GpsHelperListener gpsHelperListener) {
        boolean playServicesIsAvailable = GpsHelper.isPlayServicesAvailable(context);
        if (playServicesIsAvailable) {
            GpsHelper.internalFetchAdvertisingInfoAsync(context, gpsHelperListener);
        } else {
            if (gpsHelperListener != null) {
                gpsHelperListener.onFetchAdInfoCompleted();
            }
            if (playServicesIsAvailable) {
                GpsHelper.internalFetchAdvertisingInfoAsync(context, null);
            }
        }
    }

    @Nullable
    public static AdvertisingInfo fetchAdvertisingInfoSync(Context context) {
        if (context == null) {
            return null;
        }
        Object adInfo = null;
        try {
            Reflection.MethodBuilder methodBuilder = MethodBuilderFactory.create(null, "getAdvertisingIdInfo").setStatic(Class.forName(sAdvertisingIdClientClassName)).addParam(Context.class, context);
            adInfo = methodBuilder.execute();
        }
        catch (Exception e) {
            MoPubLog.d("Unable to obtain Google AdvertisingIdClient.Info via reflection.");
            return null;
        }
        String advertisingId = GpsHelper.reflectedGetAdvertisingId(adInfo, null);
        boolean isLimitAdTrackingEnabled = GpsHelper.reflectedIsLimitAdTrackingEnabled(adInfo, false);
        return new AdvertisingInfo(advertisingId, isLimitAdTrackingEnabled);
    }

    private static void internalFetchAdvertisingInfoAsync(Context context, GpsHelperListener gpsHelperListener) {
        block4: {
            if (!Reflection.classFound(sAdvertisingIdClientClassName)) {
                if (gpsHelperListener != null) {
                    gpsHelperListener.onFetchAdInfoCompleted();
                }
                return;
            }
            try {
                AsyncTasks.safeExecuteOnExecutor(new FetchAdvertisingInfoTask(context, gpsHelperListener), new Void[0]);
            }
            catch (Exception exception) {
                MoPubLog.d("Error executing FetchAdvertisingInfoTask", exception);
                if (gpsHelperListener == null) break block4;
                gpsHelperListener.onFetchAdInfoCompleted();
            }
        }
    }

    static String reflectedGetAdvertisingId(Object adInfo, String defaultValue) {
        try {
            return (String)MethodBuilderFactory.create(adInfo, "getId").execute();
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    static boolean reflectedIsLimitAdTrackingEnabled(Object adInfo, boolean defaultValue) {
        try {
            Boolean result = (Boolean)MethodBuilderFactory.create(adInfo, IS_LIMIT_AD_TRACKING_ENABLED_KEY).execute();
            return result != null ? result : defaultValue;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Deprecated
    public static void setClassNamesForTesting() {
        String className;
        sPlayServicesUtilClassName = className = "java.lang.Class";
        sAdvertisingIdClientClassName = className;
    }

    private static class FetchAdvertisingInfoTask
    extends AsyncTask<Void, Void, Void> {
        private WeakReference<Context> mContextWeakReference;
        private WeakReference<GpsHelperListener> mGpsHelperListenerWeakReference;
        private AdvertisingInfo info;

        public FetchAdvertisingInfoTask(Context context, GpsHelperListener gpsHelperListener) {
            this.mContextWeakReference = new WeakReference<Context>(context);
            this.mGpsHelperListenerWeakReference = new WeakReference<GpsHelperListener>(gpsHelperListener);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Void doInBackground(Void ... voids) {
            try {
                Context context = (Context)this.mContextWeakReference.get();
                if (context == null) {
                    return null;
                }
                Reflection.MethodBuilder methodBuilder = MethodBuilderFactory.create(null, "getAdvertisingIdInfo").setStatic(Class.forName(sAdvertisingIdClientClassName)).addParam(Context.class, context);
                Object adInfo = methodBuilder.execute();
                if (adInfo == null) return null;
            }
            catch (Exception exception) {
                MoPubLog.d("Unable to obtain Google AdvertisingIdClient.Info via reflection.");
            }
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            GpsHelperListener gpsHelperListener = (GpsHelperListener)this.mGpsHelperListenerWeakReference.get();
            if (gpsHelperListener != null) {
                gpsHelperListener.onFetchAdInfoCompleted();
            }
        }
    }

    public static interface GpsHelperListener {
        public void onFetchAdInfoCompleted();
    }

    public static class AdvertisingInfo {
        public final String advertisingId;
        public final boolean limitAdTracking;

        public AdvertisingInfo(String adId, boolean limitAdTrackingEnabled) {
            this.advertisingId = adId;
            this.limitAdTracking = limitAdTrackingEnabled;
        }
    }
}

