/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.webkit.WebView;
import com.mopub.common.AvidViewabilitySession;
import com.mopub.common.ExternalViewabilitySession;
import com.mopub.common.MoatViewabilitySession;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.VastVideoConfig;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class ExternalViewabilitySessionManager {
    @NonNull
    private final Set<ExternalViewabilitySession> mViewabilitySessions;

    public ExternalViewabilitySessionManager(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        this.mViewabilitySessions = new HashSet<ExternalViewabilitySession>();
        this.mViewabilitySessions.add(new AvidViewabilitySession());
        this.mViewabilitySessions.add(new MoatViewabilitySession());
        this.initialize(context);
    }

    private void initialize(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        for (ExternalViewabilitySession session : this.mViewabilitySessions) {
            Boolean successful = session.initialize(context);
            this.logEvent(session, "initialize", successful, false);
        }
    }

    public void invalidate() {
        for (ExternalViewabilitySession session : this.mViewabilitySessions) {
            Boolean successful = session.invalidate();
            this.logEvent(session, "invalidate", successful, false);
        }
    }

    public void createDisplaySession(@NonNull Context context, @NonNull WebView webView, boolean isDeferred) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(webView);
        for (ExternalViewabilitySession session : this.mViewabilitySessions) {
            Boolean successful = session.createDisplaySession(context, webView, isDeferred);
            this.logEvent(session, "start display session", successful, true);
        }
    }

    public void createDisplaySession(@NonNull Context context, @NonNull WebView webview) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(webview);
        this.createDisplaySession(context, webview, false);
    }

    public void startDeferredDisplaySession(@NonNull Activity activity) {
        for (ExternalViewabilitySession session : this.mViewabilitySessions) {
            Boolean successful = session.startDeferredDisplaySession(activity);
            this.logEvent(session, "record deferred session", successful, true);
        }
    }

    public void endDisplaySession() {
        for (ExternalViewabilitySession session : this.mViewabilitySessions) {
            Boolean successful = session.endDisplaySession();
            this.logEvent(session, "end display session", successful, true);
        }
    }

    public void createVideoSession(@NonNull Activity activity, @NonNull View view, @NonNull VastVideoConfig vastVideoConfig) {
        Preconditions.checkNotNull(activity);
        Preconditions.checkNotNull(view);
        Preconditions.checkNotNull(vastVideoConfig);
        for (ExternalViewabilitySession session : this.mViewabilitySessions) {
            HashSet<String> buyerResources = new HashSet<String>();
            if (session instanceof AvidViewabilitySession) {
                buyerResources.addAll(vastVideoConfig.getAvidJavascriptResources());
            } else if (session instanceof MoatViewabilitySession) {
                buyerResources.addAll(vastVideoConfig.getMoatImpressionPixels());
            }
            Boolean successful = session.createVideoSession(activity, view, buyerResources, vastVideoConfig.getExternalViewabilityTrackers());
            this.logEvent(session, "start video session", successful, true);
        }
    }

    public void registerVideoObstruction(@NonNull View view) {
        Preconditions.checkNotNull(view);
        for (ExternalViewabilitySession session : this.mViewabilitySessions) {
            Boolean successful = session.registerVideoObstruction(view);
            this.logEvent(session, "register friendly obstruction", successful, true);
        }
    }

    public void onVideoPrepared(@NonNull View playerView, int duration) {
        Preconditions.checkNotNull(playerView);
        for (ExternalViewabilitySession session : this.mViewabilitySessions) {
            Boolean successful = session.onVideoPrepared(playerView, duration);
            this.logEvent(session, "on video prepared", successful, true);
        }
    }

    public void recordVideoEvent(@NonNull ExternalViewabilitySession.VideoEvent event, int playheadMillis) {
        Preconditions.checkNotNull((Object)event);
        for (ExternalViewabilitySession session : this.mViewabilitySessions) {
            Boolean successful = session.recordVideoEvent(event, playheadMillis);
            this.logEvent(session, "record video event (" + event.name() + ")", successful, true);
        }
    }

    public void endVideoSession() {
        for (ExternalViewabilitySession session : this.mViewabilitySessions) {
            Boolean successful = session.endVideoSession();
            this.logEvent(session, "end video session", successful, true);
        }
    }

    private void logEvent(@NonNull ExternalViewabilitySession session, @NonNull String event, @Nullable Boolean successful, boolean isVerbose) {
        Preconditions.checkNotNull(session);
        Preconditions.checkNotNull(event);
        if (successful == null) {
            return;
        }
        String failureString = successful != false ? "" : "failed to ";
        String message = String.format(Locale.US, "%s viewability event: %s%s.", session.getName(), failureString, event);
        if (isVerbose) {
            MoPubLog.v(message);
        } else {
            MoPubLog.d(message);
        }
    }

    public static enum ViewabilityVendor {
        AVID,
        MOAT,
        ALL;


        public void disable() {
            switch (this) {
                case AVID: {
                    AvidViewabilitySession.disable();
                    break;
                }
                case MOAT: {
                    MoatViewabilitySession.disable();
                    break;
                }
                case ALL: {
                    AvidViewabilitySession.disable();
                    MoatViewabilitySession.disable();
                    break;
                }
                default: {
                    MoPubLog.d("Attempted to disable an invalid viewability vendor: " + (Object)((Object)this));
                    return;
                }
            }
            MoPubLog.d("Disabled viewability for " + (Object)((Object)this));
        }

        @NonNull
        public static String getEnabledVendorKey() {
            boolean avidEnabled = AvidViewabilitySession.isEnabled();
            boolean moatEnabled = MoatViewabilitySession.isEnabled();
            String vendorKey = "0";
            if (avidEnabled && moatEnabled) {
                vendorKey = "3";
            } else if (avidEnabled) {
                vendorKey = "1";
            } else if (moatEnabled) {
                vendorKey = "2";
            }
            return vendorKey;
        }

        @Nullable
        public static ViewabilityVendor fromKey(@NonNull String key) {
            Preconditions.checkNotNull(key);
            switch (key) {
                case "1": {
                    return AVID;
                }
                case "2": {
                    return MOAT;
                }
                case "3": {
                    return ALL;
                }
            }
            return null;
        }
    }
}

