/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.os.SystemClock;
import android.support.annotation.NonNull;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;

public class DoubleTimeTracker {
    @NonNull
    private volatile State state;
    private long startedTimestamp;
    private long interval;
    @NonNull
    private final Clock mClock;

    public DoubleTimeTracker() {
        this(new SystemClockClock());
    }

    @VisibleForTesting
    public DoubleTimeTracker(@NonNull Clock clock) {
        this.mClock = clock;
        this.state = State.PAUSED;
    }

    public synchronized void start() {
        if (this.state == State.STARTED) {
            MoPubLog.v("DoubleTimeTracker already started.");
            return;
        }
        this.state = State.STARTED;
        this.startedTimestamp = this.mClock.elapsedRealTime();
    }

    public synchronized void pause() {
        if (this.state == State.PAUSED) {
            MoPubLog.v("DoubleTimeTracker already paused.");
            return;
        }
        this.interval += this.computeIntervalDiff();
        this.startedTimestamp = 0L;
        this.state = State.PAUSED;
    }

    public synchronized double getInterval() {
        return this.interval + this.computeIntervalDiff();
    }

    private synchronized long computeIntervalDiff() {
        if (this.state == State.PAUSED) {
            return 0L;
        }
        return this.mClock.elapsedRealTime() - this.startedTimestamp;
    }

    private static class SystemClockClock
    implements Clock {
        private SystemClockClock() {
        }

        @Override
        public long elapsedRealTime() {
            return SystemClock.elapsedRealtime();
        }
    }

    private static enum State {
        STARTED,
        PAUSED;

    }

    public static interface Clock {
        public long elapsedRealTime();
    }
}

