/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.telephony.TelephonyManager;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.privacy.MoPubIdentifier;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.Dips;
import java.util.Locale;

public class ClientMetadata {
    private static final String DEVICE_ORIENTATION_PORTRAIT = "p";
    private static final String DEVICE_ORIENTATION_LANDSCAPE = "l";
    private static final String DEVICE_ORIENTATION_SQUARE = "s";
    private static final String DEVICE_ORIENTATION_UNKNOWN = "u";
    private String mNetworkOperatorForUrl;
    private String mNetworkOperator;
    private String mSimOperator;
    private String mIsoCountryCode;
    private String mSimIsoCountryCode;
    private String mNetworkOperatorName;
    private String mSimOperatorName;
    @NonNull
    private final MoPubIdentifier moPubIdentifier;
    private static volatile ClientMetadata sInstance;
    private final String mDeviceManufacturer;
    private final String mDeviceModel;
    private final String mDeviceProduct;
    private final String mDeviceOsVersion;
    private final String mSdkVersion;
    private final String mAppVersion;
    private final String mAppPackageName;
    private String mAppName;
    private final Context mContext;
    private final ConnectivityManager mConnectivityManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static ClientMetadata getInstance(@NonNull Context context) {
        ClientMetadata result = sInstance;
        if (result != null) return result;
        Class<ClientMetadata> clazz = ClientMetadata.class;
        synchronized (ClientMetadata.class) {
            result = sInstance;
            if (result != null) return result;
            sInstance = result = new ClientMetadata(context);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static ClientMetadata getInstance() {
        ClientMetadata result = sInstance;
        if (result != null) return result;
        Class<ClientMetadata> clazz = ClientMetadata.class;
        synchronized (ClientMetadata.class) {
            return sInstance;
        }
    }

    public ClientMetadata(@NonNull Context context) {
        TelephonyManager telephonyManager;
        Preconditions.checkNotNull(context);
        this.mContext = context.getApplicationContext();
        this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        this.mDeviceManufacturer = Build.MANUFACTURER;
        this.mDeviceModel = Build.MODEL;
        this.mDeviceProduct = Build.PRODUCT;
        this.mDeviceOsVersion = Build.VERSION.RELEASE;
        this.mSdkVersion = "5.4.0";
        this.mAppVersion = ClientMetadata.getAppVersionFromContext(this.mContext);
        PackageManager packageManager = this.mContext.getPackageManager();
        ApplicationInfo applicationInfo = null;
        this.mAppPackageName = this.mContext.getPackageName();
        try {
            applicationInfo = packageManager.getApplicationInfo(this.mAppPackageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (applicationInfo != null) {
            this.mAppName = (String)packageManager.getApplicationLabel(applicationInfo);
        }
        if ((telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone")) != null) {
            this.mNetworkOperatorForUrl = telephonyManager.getNetworkOperator();
            this.mNetworkOperator = telephonyManager.getNetworkOperator();
            if (telephonyManager.getPhoneType() == 2 && telephonyManager.getSimState() == 5) {
                this.mNetworkOperatorForUrl = telephonyManager.getSimOperator();
                this.mSimOperator = telephonyManager.getSimOperator();
            }
            if (MoPub.canCollectPersonalInformation()) {
                this.mIsoCountryCode = telephonyManager.getNetworkCountryIso();
                this.mSimIsoCountryCode = telephonyManager.getSimCountryIso();
            } else {
                this.mIsoCountryCode = "";
                this.mSimIsoCountryCode = "";
            }
            try {
                this.mNetworkOperatorName = telephonyManager.getNetworkOperatorName();
                if (telephonyManager.getSimState() == 5) {
                    this.mSimOperatorName = telephonyManager.getSimOperatorName();
                }
            }
            catch (SecurityException e) {
                this.mNetworkOperatorName = null;
                this.mSimOperatorName = null;
            }
        }
        this.moPubIdentifier = new MoPubIdentifier(this.mContext);
    }

    public void repopulateCountryData() {
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (MoPub.canCollectPersonalInformation() && telephonyManager != null) {
            this.mIsoCountryCode = telephonyManager.getNetworkCountryIso();
            this.mSimIsoCountryCode = telephonyManager.getSimCountryIso();
        }
    }

    private static String getAppVersionFromContext(Context context) {
        try {
            String packageName = context.getPackageName();
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
            return packageInfo.versionName;
        }
        catch (Exception exception) {
            MoPubLog.d("Failed to retrieve PackageInfo#versionName.");
            return null;
        }
    }

    public String getOrientationString() {
        int orientationInt = this.mContext.getResources().getConfiguration().orientation;
        String orientation = DEVICE_ORIENTATION_UNKNOWN;
        if (orientationInt == 1) {
            orientation = DEVICE_ORIENTATION_PORTRAIT;
        } else if (orientationInt == 2) {
            orientation = DEVICE_ORIENTATION_LANDSCAPE;
        } else if (orientationInt == 3) {
            orientation = DEVICE_ORIENTATION_SQUARE;
        }
        return orientation;
    }

    @SuppressLint(value={"MissingPermission"})
    public MoPubNetworkType getActiveNetworkType() {
        NetworkInfo networkInfo;
        if (!DeviceUtils.isPermissionGranted(this.mContext, "android.permission.ACCESS_NETWORK_STATE")) {
            return MoPubNetworkType.UNKNOWN;
        }
        NetworkInfo activeNetworkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        if (activeNetworkInfo == null || !activeNetworkInfo.isConnected()) {
            return MoPubNetworkType.UNKNOWN;
        }
        if (Build.VERSION.SDK_INT < 21) {
            if (activeNetworkInfo.getType() == 9) {
                return MoPubNetworkType.ETHERNET;
            }
        } else {
            Network[] networks;
            for (Network network : networks = this.mConnectivityManager.getAllNetworks()) {
                NetworkCapabilities capabilities = this.mConnectivityManager.getNetworkCapabilities(network);
                if (capabilities == null || !capabilities.hasTransport(3)) continue;
                return MoPubNetworkType.ETHERNET;
            }
        }
        if ((networkInfo = this.mConnectivityManager.getNetworkInfo(1)) != null && networkInfo.isConnected()) {
            return MoPubNetworkType.WIFI;
        }
        networkInfo = this.mConnectivityManager.getNetworkInfo(0);
        if (networkInfo != null && networkInfo.isConnected()) {
            int netType = networkInfo.getSubtype();
            switch (netType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return MoPubNetworkType.GG;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: {
                    return MoPubNetworkType.GGG;
                }
                case 13: 
                case 15: {
                    return MoPubNetworkType.GGGG;
                }
            }
            return MoPubNetworkType.MOBILE;
        }
        return MoPubNetworkType.UNKNOWN;
    }

    public float getDensity() {
        return this.mContext.getResources().getDisplayMetrics().density;
    }

    public String getNetworkOperatorForUrl() {
        return this.mNetworkOperatorForUrl;
    }

    public String getNetworkOperator() {
        return this.mNetworkOperator;
    }

    public Locale getDeviceLocale() {
        return this.mContext.getResources().getConfiguration().locale;
    }

    public String getSimOperator() {
        return this.mSimOperator;
    }

    public String getIsoCountryCode() {
        return MoPub.canCollectPersonalInformation() ? this.mIsoCountryCode : "";
    }

    public String getSimIsoCountryCode() {
        return MoPub.canCollectPersonalInformation() ? this.mSimIsoCountryCode : "";
    }

    public String getNetworkOperatorName() {
        return this.mNetworkOperatorName;
    }

    public String getSimOperatorName() {
        return this.mSimOperatorName;
    }

    @NonNull
    public MoPubIdentifier getMoPubIdentifier() {
        return this.moPubIdentifier;
    }

    public String getDeviceManufacturer() {
        return this.mDeviceManufacturer;
    }

    public String getDeviceModel() {
        return this.mDeviceModel;
    }

    public String getDeviceProduct() {
        return this.mDeviceProduct;
    }

    public String getDeviceOsVersion() {
        return this.mDeviceOsVersion;
    }

    public int getDeviceScreenWidthDip() {
        return Dips.screenWidthAsIntDips(this.mContext);
    }

    public int getDeviceScreenHeightDip() {
        return Dips.screenHeightAsIntDips(this.mContext);
    }

    public Point getDeviceDimensions() {
        if (Preconditions.NoThrow.checkNotNull(this.mContext)) {
            return DeviceUtils.getDeviceDimensions(this.mContext);
        }
        return new Point(0, 0);
    }

    public String getSdkVersion() {
        return this.mSdkVersion;
    }

    public String getAppVersion() {
        return this.mAppVersion;
    }

    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    public String getAppName() {
        return this.mAppName;
    }

    @NonNull
    public static String getCurrentLanguage(@NonNull Context context) {
        String languageCode = Locale.getDefault().getLanguage().trim();
        Locale userLocale = context.getResources().getConfiguration().locale;
        if (userLocale != null && !userLocale.getLanguage().trim().isEmpty()) {
            languageCode = userLocale.getLanguage().trim();
        }
        return languageCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @VisibleForTesting
    public static void setInstance(ClientMetadata clientMetadata) {
        Class<ClientMetadata> clazz = ClientMetadata.class;
        synchronized (ClientMetadata.class) {
            sInstance = clientMetadata;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Deprecated
    @VisibleForTesting
    public static void clearForTesting() {
        sInstance = null;
    }

    public static enum MoPubNetworkType {
        UNKNOWN(0),
        ETHERNET(1),
        WIFI(2),
        MOBILE(3),
        GG(4),
        GGG(5),
        GGGG(6);

        private final int mId;

        private MoPubNetworkType(int id) {
            this.mId = id;
        }

        public String toString() {
            return Integer.toString(this.mId);
        }

        public int getId() {
            return this.mId;
        }
    }
}

