/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.graphics.Point;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.mopub.network.Networking;

public abstract class BaseUrlGenerator {
    protected static final String AD_UNIT_ID_KEY = "id";
    protected static final String SDK_VERSION_KEY = "nv";
    protected static final String UDID_KEY = "udid";
    protected static final String DNT_KEY = "dnt";
    protected static final String BUNDLE_ID_KEY = "bundle";
    protected static final String CURRENT_CONSENT_STATUS_KEY = "current_consent_status";
    protected static final String CONSENTED_VENDOR_LIST_VERSION_KEY = "consented_vendor_list_version";
    protected static final String CONSENTED_PRIVACY_POLICY_VERSION_KEY = "consented_privacy_policy_version";
    protected static final String GDPR_APPLIES = "gdpr_applies";
    protected static final String FORCE_GDPR_APPLIES = "force_gdpr_applies";
    private static final String WIDTH_KEY = "w";
    private static final String HEIGHT_KEY = "h";
    private StringBuilder mStringBuilder;
    private boolean mFirstParam;

    public abstract String generateUrlString(String var1);

    protected void initUrlString(String serverHostname, String handlerType) {
        this.mStringBuilder = new StringBuilder(Networking.getScheme()).append("://").append(serverHostname).append(handlerType);
        this.mFirstParam = true;
    }

    protected String getFinalUrlString() {
        return this.mStringBuilder.toString();
    }

    protected void addParam(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        this.mStringBuilder.append(this.getParamDelimiter());
        this.mStringBuilder.append(key);
        this.mStringBuilder.append("=");
        this.mStringBuilder.append(Uri.encode((String)value));
    }

    protected void addParam(String key, Boolean value) {
        if (value == null) {
            return;
        }
        this.mStringBuilder.append(this.getParamDelimiter());
        this.mStringBuilder.append(key);
        this.mStringBuilder.append("=");
        this.mStringBuilder.append(value != false ? "1" : "0");
    }

    private String getParamDelimiter() {
        if (this.mFirstParam) {
            this.mFirstParam = false;
            return "?";
        }
        return "&";
    }

    protected void setApiVersion(String apiVersion) {
        this.addParam("v", apiVersion);
    }

    protected void setAppVersion(String appVersion) {
        this.addParam("av", appVersion);
    }

    protected void setExternalStoragePermission(boolean isExternalStoragePermissionGranted) {
        this.addParam("android_perms_ext_storage", isExternalStoragePermissionGranted ? "1" : "0");
    }

    protected void setDeviceInfo(String ... info) {
        StringBuilder result = new StringBuilder();
        if (info == null || info.length < 1) {
            return;
        }
        for (int i = 0; i < info.length - 1; ++i) {
            result.append(info[i]).append(",");
        }
        result.append(info[info.length - 1]);
        this.addParam("dn", result.toString());
    }

    protected void appendAdvertisingInfoTemplates() {
        this.addParam(UDID_KEY, "mp_tmpl_advertising_id");
        this.addParam(DNT_KEY, "mp_tmpl_do_not_track");
    }

    protected void setDeviceDimensions(@NonNull Point dimensions) {
        this.addParam(WIDTH_KEY, "" + dimensions.x);
        this.addParam(HEIGHT_KEY, "" + dimensions.y);
    }
}

