/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.webkit.WebView;
import com.mopub.common.ExternalViewabilitySession;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Reflection;
import java.util.Map;
import java.util.Set;

class AvidViewabilitySession
implements ExternalViewabilitySession {
    private static final String AVID_MANAGER_PATH = "com.integralads.avid.library.mopub.AvidManager";
    private static final String EXTERNAL_AVID_AD_SESSION_CONTEXT_PATH = "com.integralads.avid.library.mopub.session.ExternalAvidAdSessionContext";
    private static final String AVID_AD_SESSION_MANAGER_PATH = "com.integralads.avid.library.mopub.session.AvidAdSessionManager";
    private static final String AVID_KEY = "avid";
    private static Object sAvidAdSessionContextDeferred;
    private static Object sAvidAdSessionContextNonDeferred;
    private static Boolean sIsViewabilityEnabledViaReflection;
    private static boolean sIsVendorDisabled;
    @Nullable
    private Object mAvidDisplayAdSession;
    @Nullable
    private Object mAvidVideoAdSession;

    AvidViewabilitySession() {
    }

    static boolean isEnabled() {
        return !sIsVendorDisabled && AvidViewabilitySession.isViewabilityEnabledViaReflection();
    }

    static void disable() {
        sIsVendorDisabled = true;
    }

    private static boolean isViewabilityEnabledViaReflection() {
        if (sIsViewabilityEnabledViaReflection == null) {
            sIsViewabilityEnabledViaReflection = Reflection.classFound(AVID_AD_SESSION_MANAGER_PATH);
            MoPubLog.d("Avid is " + (sIsViewabilityEnabledViaReflection != false ? "" : "un") + "available via reflection.");
        }
        return sIsViewabilityEnabledViaReflection;
    }

    @Nullable
    private static Object getAvidAdSessionContextDeferred() {
        if (sAvidAdSessionContextDeferred == null) {
            try {
                sAvidAdSessionContextDeferred = Reflection.instantiateClassWithConstructor(EXTERNAL_AVID_AD_SESSION_CONTEXT_PATH, Object.class, new Class[]{String.class, Boolean.TYPE}, new Object[]{"5.4.0", true});
            }
            catch (Exception e) {
                MoPubLog.d("Unable to generate Avid deferred ad session context: " + e.getMessage());
            }
        }
        return sAvidAdSessionContextDeferred;
    }

    @Nullable
    private static Object getAvidAdSessionContextNonDeferred() {
        if (sAvidAdSessionContextNonDeferred == null) {
            try {
                sAvidAdSessionContextNonDeferred = Reflection.instantiateClassWithConstructor(EXTERNAL_AVID_AD_SESSION_CONTEXT_PATH, Object.class, new Class[]{String.class}, new Object[]{"5.4.0"});
            }
            catch (Exception e) {
                MoPubLog.d("Unable to generate Avid ad session context: " + e.getMessage());
            }
        }
        return sAvidAdSessionContextNonDeferred;
    }

    @Override
    @NonNull
    public String getName() {
        return "AVID";
    }

    @Override
    @Nullable
    public Boolean initialize(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        if (!AvidViewabilitySession.isEnabled()) {
            return null;
        }
        return true;
    }

    @Override
    @Nullable
    public Boolean invalidate() {
        if (!AvidViewabilitySession.isEnabled()) {
            return null;
        }
        this.mAvidDisplayAdSession = null;
        this.mAvidVideoAdSession = null;
        return true;
    }

    @Override
    @Nullable
    public Boolean createDisplaySession(@NonNull Context context, @NonNull WebView webView, boolean isDeferred) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(webView);
        if (!AvidViewabilitySession.isEnabled()) {
            return null;
        }
        Object avidAdSessionContext = isDeferred ? AvidViewabilitySession.getAvidAdSessionContextDeferred() : AvidViewabilitySession.getAvidAdSessionContextNonDeferred();
        Activity activity = context instanceof Activity ? (Activity)context : null;
        try {
            this.mAvidDisplayAdSession = new Reflection.MethodBuilder(null, "startAvidDisplayAdSession").setStatic(AVID_AD_SESSION_MANAGER_PATH).addParam(Context.class, context).addParam(EXTERNAL_AVID_AD_SESSION_CONTEXT_PATH, avidAdSessionContext).execute();
            new Reflection.MethodBuilder(this.mAvidDisplayAdSession, "registerAdView").addParam(View.class, webView).addParam(Activity.class, activity).execute();
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to execute Avid start display session: " + e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Boolean startDeferredDisplaySession(@NonNull Activity activity) {
        if (!AvidViewabilitySession.isEnabled()) {
            return null;
        }
        if (this.mAvidDisplayAdSession == null) {
            MoPubLog.d("Avid DisplayAdSession unexpectedly null.");
            return false;
        }
        try {
            Object avidManager = new Reflection.MethodBuilder(null, "getInstance").setStatic(AVID_MANAGER_PATH).execute();
            new Reflection.MethodBuilder(avidManager, "registerActivity").addParam(Activity.class, activity).execute();
            Object deferredAdSessionListener = new Reflection.MethodBuilder(this.mAvidDisplayAdSession, "getAvidDeferredAdSessionListener").execute();
            if (deferredAdSessionListener == null) {
                MoPubLog.d("Avid AdSessionListener unexpectedly null.");
                return false;
            }
            new Reflection.MethodBuilder(deferredAdSessionListener, "recordReadyEvent").execute();
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to execute Avid record deferred session: " + e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Boolean endDisplaySession() {
        if (!AvidViewabilitySession.isEnabled()) {
            return null;
        }
        if (this.mAvidDisplayAdSession == null) {
            MoPubLog.d("Avid DisplayAdSession unexpectedly null.");
            return false;
        }
        try {
            new Reflection.MethodBuilder(this.mAvidDisplayAdSession, "endSession").execute();
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to execute Avid end session: " + e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Boolean createVideoSession(@NonNull Activity activity, @NonNull View view, @NonNull Set<String> buyerResources, @NonNull Map<String, String> videoViewabilityTrackers) {
        Preconditions.checkNotNull(activity);
        Preconditions.checkNotNull(view);
        Preconditions.checkNotNull(buyerResources);
        Preconditions.checkNotNull(videoViewabilityTrackers);
        if (!AvidViewabilitySession.isEnabled()) {
            return null;
        }
        try {
            this.mAvidVideoAdSession = new Reflection.MethodBuilder(null, "startAvidManagedVideoAdSession").setStatic(AVID_AD_SESSION_MANAGER_PATH).addParam(Context.class, activity).addParam(EXTERNAL_AVID_AD_SESSION_CONTEXT_PATH, AvidViewabilitySession.getAvidAdSessionContextNonDeferred()).execute();
            new Reflection.MethodBuilder(this.mAvidVideoAdSession, "registerAdView").addParam(View.class, view).addParam(Activity.class, activity).execute();
            if (!TextUtils.isEmpty((CharSequence)videoViewabilityTrackers.get(AVID_KEY))) {
                new Reflection.MethodBuilder(this.mAvidVideoAdSession, "injectJavaScriptResource").addParam(String.class, videoViewabilityTrackers.get(AVID_KEY)).execute();
            }
            for (String buyerResource : buyerResources) {
                if (TextUtils.isEmpty((CharSequence)buyerResource)) continue;
                new Reflection.MethodBuilder(this.mAvidVideoAdSession, "injectJavaScriptResource").addParam(String.class, buyerResource).execute();
            }
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to execute Avid start video session: " + e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Boolean registerVideoObstruction(@NonNull View view) {
        Preconditions.checkNotNull(view);
        if (!AvidViewabilitySession.isEnabled()) {
            return null;
        }
        if (this.mAvidVideoAdSession == null) {
            MoPubLog.d("Avid VideoAdSession unexpectedly null.");
            return false;
        }
        try {
            new Reflection.MethodBuilder(this.mAvidVideoAdSession, "registerFriendlyObstruction").addParam(View.class, view).execute();
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to register Avid video obstructions: " + e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Boolean onVideoPrepared(@NonNull View playerView, int duration) {
        Preconditions.checkNotNull(playerView);
        if (!AvidViewabilitySession.isEnabled()) {
            return null;
        }
        return true;
    }

    @Override
    @Nullable
    public Boolean recordVideoEvent(@NonNull ExternalViewabilitySession.VideoEvent event, int playheadMillis) {
        Preconditions.checkNotNull((Object)event);
        if (!AvidViewabilitySession.isEnabled()) {
            return null;
        }
        if (this.mAvidVideoAdSession == null) {
            MoPubLog.d("Avid VideoAdSession unexpectedly null.");
            return false;
        }
        try {
            switch (event) {
                case AD_LOADED: 
                case AD_STARTED: 
                case AD_STOPPED: 
                case AD_PAUSED: 
                case AD_PLAYING: 
                case AD_SKIPPED: 
                case AD_IMPRESSED: 
                case AD_CLICK_THRU: 
                case AD_VIDEO_FIRST_QUARTILE: 
                case AD_VIDEO_MIDPOINT: 
                case AD_VIDEO_THIRD_QUARTILE: 
                case AD_COMPLETE: {
                    this.handleVideoEventReflection(event);
                    return true;
                }
                case RECORD_AD_ERROR: {
                    this.handleVideoEventReflection(event, "error");
                    return true;
                }
            }
            MoPubLog.d("Unexpected video event type: " + (Object)((Object)event));
            return false;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to execute Avid video event for " + event.getAvidMethodName() + ": " + e.getMessage());
            return false;
        }
    }

    @Override
    @Nullable
    public Boolean endVideoSession() {
        if (!AvidViewabilitySession.isEnabled()) {
            return null;
        }
        if (this.mAvidVideoAdSession == null) {
            MoPubLog.d("Avid VideoAdSession unexpectedly null.");
            return false;
        }
        try {
            new Reflection.MethodBuilder(this.mAvidVideoAdSession, "endSession").execute();
            return true;
        }
        catch (Exception e) {
            MoPubLog.d("Unable to execute Avid end video session: " + e.getMessage());
            return false;
        }
    }

    private void handleVideoEventReflection(@NonNull ExternalViewabilitySession.VideoEvent videoEvent) throws Exception {
        this.handleVideoEventReflection(videoEvent, null);
    }

    private void handleVideoEventReflection(@NonNull ExternalViewabilitySession.VideoEvent videoEvent, @Nullable String message) throws Exception {
        Object playbackListener = new Reflection.MethodBuilder(this.mAvidVideoAdSession, "getAvidVideoPlaybackListener").execute();
        Reflection.MethodBuilder methodBuilder = new Reflection.MethodBuilder(playbackListener, videoEvent.getAvidMethodName());
        if (!TextUtils.isEmpty((CharSequence)message)) {
            methodBuilder.addParam(String.class, message);
        }
        methodBuilder.execute();
    }
}

