/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.AdvancedBiddersInitializedListener;
import com.mopub.common.MoPubAdvancedBidder;
import com.mopub.common.Preconditions;
import com.mopub.common.SdkInitializationListener;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.AsyncTasks;
import com.mopub.common.util.Reflection;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class AdvancedBiddingTokens
implements AdvancedBiddersInitializedListener {
    private static final String TOKEN_KEY = "token";
    @NonNull
    private List<MoPubAdvancedBidder> mAdvancedBidders = new ArrayList<MoPubAdvancedBidder>();
    @Nullable
    private final SdkInitializationListener mSdkInitializationListener;

    public AdvancedBiddingTokens(@Nullable SdkInitializationListener sdkInitializationListener) {
        this.mSdkInitializationListener = sdkInitializationListener;
    }

    public void addAdvancedBidders(@NonNull List<Class<? extends MoPubAdvancedBidder>> advancedBidderClasses) {
        Preconditions.checkNotNull(advancedBidderClasses);
        AsyncTasks.safeExecuteOnExecutor(new AdvancedBiddersInitializationAsyncTask(advancedBidderClasses, this), new Void[0]);
    }

    @Nullable
    String getTokensAsJsonString(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        JSONObject tokens = this.getTokensAsJsonObject(context);
        if (tokens == null) {
            return null;
        }
        return tokens.toString();
    }

    @Nullable
    private JSONObject getTokensAsJsonObject(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        if (this.mAdvancedBidders.isEmpty()) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        for (MoPubAdvancedBidder bidder : this.mAdvancedBidders) {
            try {
                JSONObject bidderJsonObject = new JSONObject();
                bidderJsonObject.put(TOKEN_KEY, (Object)bidder.getToken(context));
                jsonObject.put(bidder.getCreativeNetworkName(), (Object)bidderJsonObject);
            }
            catch (JSONException e) {
                MoPubLog.d("JSON parsing failed for creative network name: " + bidder.getCreativeNetworkName());
            }
        }
        return jsonObject;
    }

    @Override
    public void onAdvancedBiddersInitialized(@NonNull List<MoPubAdvancedBidder> advancedBidders) {
        Preconditions.checkNotNull(advancedBidders);
        this.mAdvancedBidders = advancedBidders;
        if (this.mSdkInitializationListener != null) {
            this.mSdkInitializationListener.onInitializationFinished();
        }
    }

    private static class AdvancedBiddersInitializationAsyncTask
    extends AsyncTask<Void, Void, List<MoPubAdvancedBidder>> {
        @NonNull
        private final List<Class<? extends MoPubAdvancedBidder>> advancedBidderClasses;
        @NonNull
        private final AdvancedBiddersInitializedListener mAdvancedBiddersInitializedListener;

        AdvancedBiddersInitializationAsyncTask(@NonNull List<Class<? extends MoPubAdvancedBidder>> advancedBidderClasses, @NonNull AdvancedBiddersInitializedListener advancedBiddersInitializedListener) {
            Preconditions.checkNotNull(advancedBidderClasses);
            Preconditions.checkNotNull(advancedBiddersInitializedListener);
            this.advancedBidderClasses = advancedBidderClasses;
            this.mAdvancedBiddersInitializedListener = advancedBiddersInitializedListener;
        }

        protected List<MoPubAdvancedBidder> doInBackground(Void ... voids) {
            ArrayList<MoPubAdvancedBidder> advancedBidders = new ArrayList<MoPubAdvancedBidder>();
            for (Class<? extends MoPubAdvancedBidder> advancedBidderClass : this.advancedBidderClasses) {
                try {
                    MoPubAdvancedBidder advancedBidder = Reflection.instantiateClassWithEmptyConstructor(advancedBidderClass.getName(), MoPubAdvancedBidder.class);
                    advancedBidders.add(advancedBidder);
                }
                catch (Exception e) {
                    MoPubLog.e("Unable to find class " + advancedBidderClass.getName());
                }
            }
            return advancedBidders;
        }

        protected void onPostExecute(List<MoPubAdvancedBidder> advancedBidders) {
            this.mAdvancedBiddersInitializedListener.onAdvancedBiddersInitialized(advancedBidders);
        }
    }
}

