/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.support.annotation.NonNull;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.event.BaseEvent;
import com.mopub.common.event.EventSerializer;
import com.mopub.network.RequestManager;
import com.mopub.volley.Cache;
import com.mopub.volley.DefaultRetryPolicy;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.Request;
import com.mopub.volley.Response;
import com.mopub.volley.RetryPolicy;
import com.mopub.volley.toolbox.HttpHeaderParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;

public class ScribeRequest
extends Request<Void> {
    @NonNull
    private final List<BaseEvent> mEvents;
    @NonNull
    private final EventSerializer mEventSerializer;
    @NonNull
    private final Listener mListener;

    public ScribeRequest(@NonNull String url, @NonNull List<BaseEvent> events, @NonNull EventSerializer eventSerializer, @NonNull Listener listener) {
        super(1, url, (Response.ErrorListener)listener);
        this.mEvents = events;
        this.mEventSerializer = eventSerializer;
        this.mListener = listener;
        this.setShouldCache(false);
        this.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy());
    }

    protected Map<String, String> getParams() {
        JSONArray jsonArray = this.mEventSerializer.serializeAsJson(this.mEvents);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("log", jsonArray.toString());
        return params;
    }

    protected Response<Void> parseNetworkResponse(NetworkResponse networkResponse) {
        return Response.success(null, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)networkResponse));
    }

    protected void deliverResponse(Void aVoid) {
        this.mListener.onResponse();
    }

    @Deprecated
    @NonNull
    @VisibleForTesting
    public List<BaseEvent> getEvents() {
        return this.mEvents;
    }

    public static interface ScribeRequestFactory
    extends RequestManager.RequestFactory {
        public ScribeRequest createRequest(Listener var1);
    }

    public static interface Listener
    extends Response.ErrorListener {
        public void onResponse();
    }
}

