/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.content.Context;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.AdFormat;
import com.mopub.common.LocationService;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.event.BaseEvent;
import com.mopub.common.event.Event;
import com.mopub.common.event.EventDetails;
import com.mopub.common.event.MoPubEvents;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Json;
import com.mopub.common.util.ResponseHeader;
import com.mopub.mobileads.AdTypeTranslator;
import com.mopub.network.AdResponse;
import com.mopub.network.HeaderUtils;
import com.mopub.network.MoPubNetworkError;
import com.mopub.volley.Cache;
import com.mopub.volley.DefaultRetryPolicy;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.Request;
import com.mopub.volley.Response;
import com.mopub.volley.RetryPolicy;
import com.mopub.volley.VolleyError;
import com.mopub.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONException;
import org.json.JSONObject;

public class AdRequest
extends Request<AdResponse> {
    @NonNull
    private final Listener mListener;
    @NonNull
    private final AdFormat mAdFormat;
    @Nullable
    private final String mAdUnitId;
    @NonNull
    private final Context mContext;

    public AdRequest(@NonNull String url, @NonNull AdFormat adFormat, @Nullable String adUnitId, @NonNull Context context, @NonNull Listener listener) {
        super(0, url, (Response.ErrorListener)listener);
        Preconditions.checkNotNull((Object)adFormat);
        Preconditions.checkNotNull(listener);
        this.mAdUnitId = adUnitId;
        this.mListener = listener;
        this.mAdFormat = adFormat;
        this.mContext = context.getApplicationContext();
        DefaultRetryPolicy retryPolicy = new DefaultRetryPolicy(2500, 1, 1.0f);
        this.setRetryPolicy((RetryPolicy)retryPolicy);
        this.setShouldCache(false);
    }

    @NonNull
    public Listener getListener() {
        return this.mListener;
    }

    public Map<String, String> getHeaders() {
        TreeMap<String, String> headers = new TreeMap<String, String>();
        String languageCode = Locale.getDefault().getLanguage();
        Locale userLocale = this.mContext.getResources().getConfiguration().locale;
        if (userLocale != null && !userLocale.getLanguage().trim().isEmpty()) {
            languageCode = userLocale.getLanguage().trim();
        }
        if (!languageCode.isEmpty()) {
            headers.put(ResponseHeader.ACCEPT_LANGUAGE.getKey(), languageCode);
        }
        return headers;
    }

    protected Response<AdResponse> parseNetworkResponse(NetworkResponse networkResponse) {
        Map<String, String> serverExtras;
        Map headers = networkResponse.headers;
        if (HeaderUtils.extractBooleanHeader(headers, ResponseHeader.WARMUP, false)) {
            return Response.error((VolleyError)new MoPubNetworkError("Ad Unit is warming up.", MoPubNetworkError.Reason.WARMING_UP));
        }
        Location location = LocationService.getLastKnownLocation(this.mContext, MoPub.getLocationPrecision(), MoPub.getLocationAwareness());
        AdResponse.Builder builder = new AdResponse.Builder();
        builder.setAdUnitId(this.mAdUnitId);
        String adTypeString = HeaderUtils.extractHeader(headers, ResponseHeader.AD_TYPE);
        String fullAdTypeString = HeaderUtils.extractHeader(headers, ResponseHeader.FULL_AD_TYPE);
        builder.setAdType(adTypeString);
        builder.setFullAdType(fullAdTypeString);
        Integer refreshTimeSeconds = HeaderUtils.extractIntegerHeader(headers, ResponseHeader.REFRESH_TIME);
        Integer refreshTimeMilliseconds = refreshTimeSeconds == null ? null : Integer.valueOf(refreshTimeSeconds * 1000);
        builder.setRefreshTimeMilliseconds(refreshTimeMilliseconds);
        if ("clear".equals(adTypeString)) {
            AdResponse adResponse = builder.build();
            this.logScribeEvent(adResponse, networkResponse, location);
            return Response.error((VolleyError)new MoPubNetworkError("No ads found for ad unit.", MoPubNetworkError.Reason.NO_FILL, refreshTimeMilliseconds));
        }
        String dspCreativeId = HeaderUtils.extractHeader(headers, ResponseHeader.DSP_CREATIVE_ID);
        builder.setDspCreativeId(dspCreativeId);
        String networkType = HeaderUtils.extractHeader(headers, ResponseHeader.NETWORK_TYPE);
        builder.setNetworkType(networkType);
        String redirectUrl = HeaderUtils.extractHeader(headers, ResponseHeader.REDIRECT_URL);
        builder.setRedirectUrl(redirectUrl);
        String clickTrackingUrl = HeaderUtils.extractHeader(headers, ResponseHeader.CLICK_TRACKING_URL);
        builder.setClickTrackingUrl(clickTrackingUrl);
        builder.setImpressionTrackingUrl(HeaderUtils.extractHeader(headers, ResponseHeader.IMPRESSION_URL));
        String failUrl = HeaderUtils.extractHeader(headers, ResponseHeader.FAIL_URL);
        builder.setFailoverUrl(failUrl);
        String requestId = this.getRequestId(failUrl);
        builder.setRequestId(requestId);
        boolean isScrollable = HeaderUtils.extractBooleanHeader(headers, ResponseHeader.SCROLLABLE, false);
        builder.setScrollable(isScrollable);
        Integer width = HeaderUtils.extractIntegerHeader(headers, ResponseHeader.WIDTH);
        Integer height = HeaderUtils.extractIntegerHeader(headers, ResponseHeader.HEIGHT);
        builder.setDimensions(width, height);
        Integer adTimeoutDelaySeconds = HeaderUtils.extractIntegerHeader(headers, ResponseHeader.AD_TIMEOUT);
        builder.setAdTimeoutDelayMilliseconds(adTimeoutDelaySeconds == null ? null : Integer.valueOf(adTimeoutDelaySeconds * 1000));
        String responseBody = this.parseStringBody(networkResponse);
        builder.setResponseBody(responseBody);
        if ("json".equals(adTypeString) || "json_video".equals(adTypeString)) {
            try {
                builder.setJsonBody(new JSONObject(responseBody));
            }
            catch (JSONException e) {
                return Response.error((VolleyError)new MoPubNetworkError("Failed to decode body JSON for native ad format", e, MoPubNetworkError.Reason.BAD_BODY));
            }
        }
        String customEventClassName = AdTypeTranslator.getCustomEventName(this.mAdFormat, adTypeString, fullAdTypeString, headers);
        builder.setCustomEventClassName(customEventClassName);
        String customEventData = HeaderUtils.extractHeader(headers, ResponseHeader.CUSTOM_EVENT_DATA);
        if (TextUtils.isEmpty((CharSequence)customEventData)) {
            customEventData = HeaderUtils.extractHeader(headers, ResponseHeader.NATIVE_PARAMS);
        }
        try {
            serverExtras = Json.jsonStringToMap(customEventData);
        }
        catch (JSONException e) {
            return Response.error((VolleyError)new MoPubNetworkError("Failed to decode server extras for custom event data.", e, MoPubNetworkError.Reason.BAD_HEADER_DATA));
        }
        if (redirectUrl != null) {
            serverExtras.put("Redirect-Url", redirectUrl);
        }
        if (clickTrackingUrl != null) {
            serverExtras.put("Clickthrough-Url", clickTrackingUrl);
        }
        if (this.eventDataIsInResponseBody(adTypeString, fullAdTypeString)) {
            serverExtras.put("Html-Response-Body", responseBody);
            serverExtras.put("Scrollable", Boolean.toString(isScrollable));
            serverExtras.put("com_mopub_orientation", HeaderUtils.extractHeader(headers, ResponseHeader.ORIENTATION));
        }
        if ("json_video".equals(adTypeString)) {
            if (Build.VERSION.SDK_INT < 16) {
                return Response.error((VolleyError)new MoPubNetworkError("Native Video ads are only supported for Android API Level 16 (JellyBean) and above.", MoPubNetworkError.Reason.UNSPECIFIED));
            }
            serverExtras.put("Play-Visible-Percent", HeaderUtils.extractPercentHeaderString(headers, ResponseHeader.PLAY_VISIBLE_PERCENT));
            serverExtras.put("Pause-Visible-Percent", HeaderUtils.extractPercentHeaderString(headers, ResponseHeader.PAUSE_VISIBLE_PERCENT));
            serverExtras.put("Impression-Min-Visible-Percent", HeaderUtils.extractPercentHeaderString(headers, ResponseHeader.IMPRESSION_MIN_VISIBLE_PERCENT));
            serverExtras.put("Impression-Visible-Ms", HeaderUtils.extractHeader(headers, ResponseHeader.IMPRESSION_VISIBLE_MS));
            serverExtras.put("Max-Buffer-Ms", HeaderUtils.extractHeader(headers, ResponseHeader.MAX_BUFFER_MS));
            builder.setEventDetails(new EventDetails.Builder().adUnitId(this.mAdUnitId).adType(adTypeString).adNetworkType(networkType).adWidthPx(width).adHeightPx(height).dspCreativeId(dspCreativeId).geoLatitude(location == null ? null : Double.valueOf(location.getLatitude())).geoLongitude(location == null ? null : Double.valueOf(location.getLongitude())).geoAccuracy(location == null ? null : Float.valueOf(location.getAccuracy())).performanceDurationMs(networkResponse.networkTimeMs).requestId(requestId).requestStatusCode(networkResponse.statusCode).requestUri(this.getUrl()).build());
        }
        builder.setServerExtras(serverExtras);
        if ("rewarded_video".equals(adTypeString) || "custom".equals(adTypeString)) {
            String rewardedVideoCurrencyName = HeaderUtils.extractHeader(headers, ResponseHeader.REWARDED_VIDEO_CURRENCY_NAME);
            String rewardedVideoCurrencyAmount = HeaderUtils.extractHeader(headers, ResponseHeader.REWARDED_VIDEO_CURRENCY_AMOUNT);
            String rewardedVideoCompletionUrl = HeaderUtils.extractHeader(headers, ResponseHeader.REWARDED_VIDEO_COMPLETION_URL);
            builder.setRewardedVideoCurrencyName(rewardedVideoCurrencyName);
            builder.setRewardedVideoCurrencyAmount(rewardedVideoCurrencyAmount);
            builder.setRewardedVideoCompletionUrl(rewardedVideoCompletionUrl);
        }
        AdResponse adResponse = builder.build();
        this.logScribeEvent(adResponse, networkResponse, location);
        return Response.success((Object)builder.build(), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)networkResponse));
    }

    private boolean eventDataIsInResponseBody(@Nullable String adType, @Nullable String fullAdType) {
        return "mraid".equals(adType) || "html".equals(adType) || "interstitial".equals(adType) && "vast".equals(fullAdType) || "rewarded_video".equals(adType) && "vast".equals(fullAdType);
    }

    protected String parseStringBody(NetworkResponse response) {
        String parsed;
        try {
            parsed = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
        }
        catch (UnsupportedEncodingException e) {
            parsed = new String(response.data);
        }
        return parsed;
    }

    protected void deliverResponse(AdResponse adResponse) {
        this.mListener.onSuccess(adResponse);
    }

    @Nullable
    @VisibleForTesting
    String getRequestId(@Nullable String failUrl) {
        if (failUrl == null) {
            return null;
        }
        String requestId = null;
        Uri uri = Uri.parse((String)failUrl);
        try {
            requestId = uri.getQueryParameter("request_id");
        }
        catch (UnsupportedOperationException e) {
            MoPubLog.d("Unable to obtain request id from fail url.");
        }
        return requestId;
    }

    @VisibleForTesting
    void logScribeEvent(@NonNull AdResponse adResponse, @NonNull NetworkResponse networkResponse, @Nullable Location location) {
        Preconditions.checkNotNull(adResponse);
        Preconditions.checkNotNull(networkResponse);
        MoPubEvents.log(new Event.Builder(BaseEvent.Name.AD_REQUEST, BaseEvent.Category.REQUESTS, BaseEvent.SamplingRate.AD_REQUEST.getSamplingRate()).withAdUnitId(this.mAdUnitId).withDspCreativeId(adResponse.getDspCreativeId()).withAdType(adResponse.getAdType()).withAdNetworkType(adResponse.getNetworkType()).withAdWidthPx(adResponse.getWidth() != null ? Double.valueOf(adResponse.getWidth().doubleValue()) : null).withAdHeightPx(adResponse.getHeight() != null ? Double.valueOf(adResponse.getHeight().doubleValue()) : null).withGeoLat(location != null ? Double.valueOf(location.getLatitude()) : null).withGeoLon(location != null ? Double.valueOf(location.getLongitude()) : null).withGeoAccuracy(location != null ? Double.valueOf(location.getAccuracy()) : null).withPerformanceDurationMs(Double.valueOf(networkResponse.networkTimeMs)).withRequestId(adResponse.getRequestId()).withRequestStatusCode(networkResponse.statusCode).withRequestUri(this.getUrl()).build());
    }

    public static interface Listener
    extends Response.ErrorListener {
        public void onSuccess(AdResponse var1);
    }
}

