/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads.util;

import android.annotation.TargetApi;
import android.os.Build;
import android.support.annotation.NonNull;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Reflection;

public class WebViews {
    @TargetApi(value=11)
    public static void onResume(@NonNull WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            webView.onResume();
            return;
        }
        try {
            new Reflection.MethodBuilder(webView, "onResume").setAccessible().execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TargetApi(value=11)
    public static void onPause(@NonNull WebView webView, boolean isFinishing) {
        if (isFinishing) {
            webView.stopLoading();
            webView.loadUrl("");
        }
        if (Build.VERSION.SDK_INT >= 11) {
            webView.onPause();
            return;
        }
        try {
            new Reflection.MethodBuilder(webView, "onPause").setAccessible().execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setDisableJSChromeClient(@NonNull WebView webView) {
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onJsAlert(@NonNull WebView view, @NonNull String url, @NonNull String message, @NonNull JsResult result) {
                MoPubLog.d(message);
                result.confirm();
                return true;
            }

            public boolean onJsConfirm(@NonNull WebView view, @NonNull String url, @NonNull String message, @NonNull JsResult result) {
                MoPubLog.d(message);
                result.confirm();
                return true;
            }

            public boolean onJsPrompt(@NonNull WebView view, @NonNull String url, @NonNull String message, @NonNull String defaultValue, @NonNull JsPromptResult result) {
                MoPubLog.d(message);
                result.confirm();
                return true;
            }

            public boolean onJsBeforeUnload(@NonNull WebView view, @NonNull String url, @NonNull String message, @NonNull JsResult result) {
                MoPubLog.d(message);
                result.confirm();
                return true;
            }
        });
    }
}

