/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Utils;
import com.mopub.mobileads.resource.CloseButtonDrawable;
import com.mopub.mobileads.resource.DrawableConstants;
import com.mopub.network.Networking;
import com.mopub.volley.VolleyError;
import com.mopub.volley.toolbox.ImageLoader;

public class VastVideoCloseButtonWidget
extends RelativeLayout {
    @NonNull
    private TextView mTextView;
    @NonNull
    private ImageView mImageView;
    @NonNull
    private final ImageLoader mImageLoader;
    @NonNull
    private CloseButtonDrawable mCloseButtonDrawable;
    private final int mEdgePadding;
    private final int mTextRightMargin;
    private final int mImagePadding;
    private final int mWidgetHeight;

    public VastVideoCloseButtonWidget(@NonNull Context context) {
        super(context);
        this.setId((int)Utils.generateUniqueId());
        this.mEdgePadding = Dips.dipsToIntPixels(16.0f, context);
        this.mImagePadding = Dips.dipsToIntPixels(5.0f, context);
        this.mWidgetHeight = Dips.dipsToIntPixels(46.0f, context);
        this.mTextRightMargin = Dips.dipsToIntPixels(7.0f, context);
        this.mCloseButtonDrawable = new CloseButtonDrawable();
        this.mImageLoader = Networking.getImageLoader(context);
        this.createImageView();
        this.createTextView();
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, this.mWidgetHeight);
        layoutParams.addRule(11);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void createImageView() {
        this.mImageView = new ImageView(this.getContext());
        this.mImageView.setId((int)Utils.generateUniqueId());
        RelativeLayout.LayoutParams iconLayoutParams = new RelativeLayout.LayoutParams(this.mWidgetHeight, this.mWidgetHeight);
        iconLayoutParams.addRule(11);
        this.mImageView.setImageDrawable((Drawable)this.mCloseButtonDrawable);
        this.mImageView.setPadding(this.mImagePadding, this.mImagePadding + this.mEdgePadding, this.mImagePadding + this.mEdgePadding, this.mImagePadding);
        this.addView((View)this.mImageView, (ViewGroup.LayoutParams)iconLayoutParams);
    }

    private void createTextView() {
        this.mTextView = new TextView(this.getContext());
        this.mTextView.setSingleLine();
        this.mTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mTextView.setTextColor(-1);
        this.mTextView.setTextSize(20.0f);
        this.mTextView.setTypeface(DrawableConstants.CloseButton.TEXT_TYPEFACE);
        this.mTextView.setText((CharSequence)"");
        RelativeLayout.LayoutParams textLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        textLayoutParams.addRule(15);
        textLayoutParams.addRule(0, this.mImageView.getId());
        this.mTextView.setPadding(0, this.mEdgePadding, 0, 0);
        textLayoutParams.setMargins(0, 0, this.mTextRightMargin, 0);
        this.addView((View)this.mTextView, (ViewGroup.LayoutParams)textLayoutParams);
    }

    void updateCloseButtonText(@Nullable String text) {
        if (this.mTextView != null) {
            this.mTextView.setText((CharSequence)text);
        }
    }

    void updateCloseButtonIcon(final @NonNull String imageUrl) {
        this.mImageLoader.get(imageUrl, new ImageLoader.ImageListener(){

            public void onResponse(ImageLoader.ImageContainer imageContainer, boolean isImmediate) {
                Bitmap bitmap = imageContainer.getBitmap();
                if (bitmap != null) {
                    VastVideoCloseButtonWidget.this.mImageView.setImageBitmap(bitmap);
                } else {
                    MoPubLog.d(String.format("%s returned null bitmap", imageUrl));
                }
            }

            public void onErrorResponse(VolleyError volleyError) {
                MoPubLog.d("Failed to load image.", (Throwable)volleyError);
            }
        });
    }

    void setOnTouchListenerToContent(@Nullable View.OnTouchListener onTouchListener) {
        this.mImageView.setOnTouchListener(onTouchListener);
        this.mTextView.setOnTouchListener(onTouchListener);
    }

    @Deprecated
    @VisibleForTesting
    ImageView getImageView() {
        return this.mImageView;
    }

    @Deprecated
    @VisibleForTesting
    void setImageView(ImageView imageView) {
        this.mImageView = imageView;
    }

    @Deprecated
    @VisibleForTesting
    TextView getTextView() {
        return this.mTextView;
    }
}

