/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Strings;
import com.mopub.mobileads.VastAbsoluteProgressTracker;
import com.mopub.mobileads.VastFractionalProgressTracker;
import com.mopub.mobileads.VastIconXmlManager;
import com.mopub.mobileads.VastMediaXmlManager;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.util.XmlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;

class VastLinearXmlManager {
    private static final String TRACKING_EVENTS = "TrackingEvents";
    private static final String VIDEO_CLICKS = "VideoClicks";
    private static final String VIDEO_TRACKER = "Tracking";
    private static final String CLICK_THROUGH = "ClickThrough";
    private static final String CLICK_TRACKER = "ClickTracking";
    private static final String MEDIA_FILES = "MediaFiles";
    private static final String MEDIA_FILE = "MediaFile";
    public static final String ICONS = "Icons";
    public static final String ICON = "Icon";
    private static final String EVENT = "event";
    private static final String OFFSET = "offset";
    private static final String SKIP_OFFSET = "skipoffset";
    private static final String CREATIVE_VIEW = "creativeView";
    private static final String START = "start";
    private static final String FIRST_QUARTILE = "firstQuartile";
    private static final String MIDPOINT = "midpoint";
    private static final String THIRD_QUARTILE = "thirdQuartile";
    private static final String COMPLETE = "complete";
    private static final String PAUSE = "pause";
    private static final String RESUME = "resume";
    private static final String CLOSE = "close";
    private static final String CLOSE_LINEAR = "closeLinear";
    private static final String PROGRESS = "progress";
    private static final String SKIP = "skip";
    private static final int CREATIVE_VIEW_TRACKER_THRESHOLD = 0;
    private static final int START_TRACKER_THRESHOLD = 0;
    private static final float FIRST_QUARTER_MARKER = 0.25f;
    private static final float MID_POINT_MARKER = 0.5f;
    private static final float THIRD_QUARTER_MARKER = 0.75f;
    @NonNull
    private final Node mLinearNode;

    VastLinearXmlManager(@NonNull Node linearNode) {
        Preconditions.checkNotNull(linearNode);
        this.mLinearNode = linearNode;
    }

    @NonNull
    List<VastFractionalProgressTracker> getFractionalProgressTrackers() {
        ArrayList<VastFractionalProgressTracker> percentTrackers = new ArrayList<VastFractionalProgressTracker>();
        this.addQuartileTrackerWithFraction(percentTrackers, this.getVideoTrackersByAttribute(FIRST_QUARTILE), 0.25f);
        this.addQuartileTrackerWithFraction(percentTrackers, this.getVideoTrackersByAttribute(MIDPOINT), 0.5f);
        this.addQuartileTrackerWithFraction(percentTrackers, this.getVideoTrackersByAttribute(THIRD_QUARTILE), 0.75f);
        Node trackingEvents = XmlUtils.getFirstMatchingChildNode(this.mLinearNode, TRACKING_EVENTS);
        if (trackingEvents != null) {
            List<Node> progressNodes = XmlUtils.getMatchingChildNodes(trackingEvents, VIDEO_TRACKER, EVENT, Collections.singletonList(PROGRESS));
            for (Node progressNode : progressNodes) {
                String offsetString = XmlUtils.getAttributeValue(progressNode, OFFSET);
                if (offsetString == null || !Strings.isPercentageTracker(offsetString = offsetString.trim())) continue;
                String trackingUrl = XmlUtils.getNodeValue(progressNode);
                try {
                    float trackingFraction = Float.parseFloat(offsetString.replace("%", "")) / 100.0f;
                    percentTrackers.add(new VastFractionalProgressTracker(trackingUrl, trackingFraction));
                }
                catch (NumberFormatException e) {
                    MoPubLog.d(String.format("Failed to parse VAST progress tracker %s", offsetString));
                }
            }
        }
        Collections.sort(percentTrackers);
        return percentTrackers;
    }

    @NonNull
    List<VastAbsoluteProgressTracker> getAbsoluteProgressTrackers() {
        ArrayList<VastAbsoluteProgressTracker> trackers = new ArrayList<VastAbsoluteProgressTracker>();
        List<String> startTrackers = this.getVideoTrackersByAttribute(START);
        for (String url : startTrackers) {
            trackers.add(new VastAbsoluteProgressTracker(url, 0));
        }
        Node trackingEvents = XmlUtils.getFirstMatchingChildNode(this.mLinearNode, TRACKING_EVENTS);
        if (trackingEvents != null) {
            List<Node> progressNodes = XmlUtils.getMatchingChildNodes(trackingEvents, VIDEO_TRACKER, EVENT, Collections.singletonList(PROGRESS));
            for (Node progressNode : progressNodes) {
                String offsetString = XmlUtils.getAttributeValue(progressNode, OFFSET);
                if (offsetString == null || !Strings.isAbsoluteTracker(offsetString = offsetString.trim())) continue;
                String trackingUrl = XmlUtils.getNodeValue(progressNode);
                try {
                    Integer trackingMilliseconds = Strings.parseAbsoluteOffset(offsetString);
                    if (trackingMilliseconds == null) continue;
                    trackers.add(new VastAbsoluteProgressTracker(trackingUrl, trackingMilliseconds));
                }
                catch (NumberFormatException e) {
                    MoPubLog.d(String.format("Failed to parse VAST progress tracker %s", offsetString));
                }
            }
            List<Node> creativeViewNodes = XmlUtils.getMatchingChildNodes(trackingEvents, VIDEO_TRACKER, EVENT, Collections.singletonList(CREATIVE_VIEW));
            for (Node creativeViewNode : creativeViewNodes) {
                String creativeNodeValue = XmlUtils.getNodeValue(creativeViewNode);
                if (creativeNodeValue == null) continue;
                trackers.add(new VastAbsoluteProgressTracker(creativeNodeValue, 0));
            }
        }
        Collections.sort(trackers);
        return trackers;
    }

    @NonNull
    List<VastTracker> getVideoCompleteTrackers() {
        return this.getVideoTrackersByAttributeAsVastTrackers(COMPLETE);
    }

    @NonNull
    List<VastTracker> getPauseTrackers() {
        List<String> trackers = this.getVideoTrackersByAttribute(PAUSE);
        ArrayList<VastTracker> vastRepeatableTrackers = new ArrayList<VastTracker>();
        for (String tracker : trackers) {
            vastRepeatableTrackers.add(new VastTracker(tracker, true));
        }
        return vastRepeatableTrackers;
    }

    @NonNull
    List<VastTracker> getResumeTrackers() {
        List<String> trackers = this.getVideoTrackersByAttribute(RESUME);
        ArrayList<VastTracker> vastRepeatableTrackers = new ArrayList<VastTracker>();
        for (String tracker : trackers) {
            vastRepeatableTrackers.add(new VastTracker(tracker, true));
        }
        return vastRepeatableTrackers;
    }

    @NonNull
    List<VastTracker> getVideoCloseTrackers() {
        List<VastTracker> closeTrackers = this.getVideoTrackersByAttributeAsVastTrackers(CLOSE);
        closeTrackers.addAll(this.getVideoTrackersByAttributeAsVastTrackers(CLOSE_LINEAR));
        return closeTrackers;
    }

    @NonNull
    List<VastTracker> getVideoSkipTrackers() {
        return this.getVideoTrackersByAttributeAsVastTrackers(SKIP);
    }

    @Nullable
    String getClickThroughUrl() {
        Node videoClicks = XmlUtils.getFirstMatchingChildNode(this.mLinearNode, VIDEO_CLICKS);
        if (videoClicks == null) {
            return null;
        }
        return XmlUtils.getNodeValue(XmlUtils.getFirstMatchingChildNode(videoClicks, CLICK_THROUGH));
    }

    @NonNull
    List<VastTracker> getClickTrackers() {
        ArrayList<VastTracker> clickTrackers = new ArrayList<VastTracker>();
        Node videoClicks = XmlUtils.getFirstMatchingChildNode(this.mLinearNode, VIDEO_CLICKS);
        if (videoClicks == null) {
            return clickTrackers;
        }
        List<Node> clickTrackerNodes = XmlUtils.getMatchingChildNodes(videoClicks, CLICK_TRACKER);
        for (Node clickTrackerNode : clickTrackerNodes) {
            String tracker = XmlUtils.getNodeValue(clickTrackerNode);
            if (tracker == null) continue;
            clickTrackers.add(new VastTracker(tracker));
        }
        return clickTrackers;
    }

    @Nullable
    String getSkipOffset() {
        String skipOffsetString = XmlUtils.getAttributeValue(this.mLinearNode, SKIP_OFFSET);
        if (skipOffsetString == null) {
            return null;
        }
        if (skipOffsetString.trim().isEmpty()) {
            return null;
        }
        return skipOffsetString.trim();
    }

    @NonNull
    List<VastMediaXmlManager> getMediaXmlManagers() {
        ArrayList<VastMediaXmlManager> mediaXmlManagers = new ArrayList<VastMediaXmlManager>();
        Node mediaFiles = XmlUtils.getFirstMatchingChildNode(this.mLinearNode, MEDIA_FILES);
        if (mediaFiles == null) {
            return mediaXmlManagers;
        }
        List<Node> mediaNodes = XmlUtils.getMatchingChildNodes(mediaFiles, MEDIA_FILE);
        for (Node mediaNode : mediaNodes) {
            mediaXmlManagers.add(new VastMediaXmlManager(mediaNode));
        }
        return mediaXmlManagers;
    }

    @NonNull
    List<VastIconXmlManager> getIconXmlManagers() {
        ArrayList<VastIconXmlManager> iconXmlManagers = new ArrayList<VastIconXmlManager>();
        Node icons = XmlUtils.getFirstMatchingChildNode(this.mLinearNode, ICONS);
        if (icons == null) {
            return iconXmlManagers;
        }
        List<Node> iconNodes = XmlUtils.getMatchingChildNodes(icons, ICON);
        for (Node iconNode : iconNodes) {
            iconXmlManagers.add(new VastIconXmlManager(iconNode));
        }
        return iconXmlManagers;
    }

    @NonNull
    private List<VastTracker> getVideoTrackersByAttributeAsVastTrackers(@NonNull String attributeValue) {
        List<String> trackers = this.getVideoTrackersByAttribute(attributeValue);
        ArrayList<VastTracker> vastTrackers = new ArrayList<VastTracker>(trackers.size());
        for (String tracker : trackers) {
            vastTrackers.add(new VastTracker(tracker));
        }
        return vastTrackers;
    }

    @NonNull
    private List<String> getVideoTrackersByAttribute(@NonNull String attributeValue) {
        Preconditions.checkNotNull(attributeValue);
        ArrayList<String> videoTrackers = new ArrayList<String>();
        Node trackingEvents = XmlUtils.getFirstMatchingChildNode(this.mLinearNode, TRACKING_EVENTS);
        if (trackingEvents == null) {
            return videoTrackers;
        }
        List<Node> videoTrackerNodes = XmlUtils.getMatchingChildNodes(trackingEvents, VIDEO_TRACKER, EVENT, Collections.singletonList(attributeValue));
        for (Node videoTrackerNode : videoTrackerNodes) {
            String tracker = XmlUtils.getNodeValue(videoTrackerNode);
            if (tracker == null) continue;
            videoTrackers.add(tracker);
        }
        return videoTrackers;
    }

    private void addQuartileTrackerWithFraction(@NonNull List<VastFractionalProgressTracker> trackers, @NonNull List<String> urls, float fraction) {
        Preconditions.checkNotNull(trackers, "trackers cannot be null");
        Preconditions.checkNotNull(urls, "urls cannot be null");
        for (String url : urls) {
            trackers.add(new VastFractionalProgressTracker(url, fraction));
        }
    }
}

