/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.VastResourceXmlManager;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.util.XmlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;

class VastCompanionAdXmlManager {
    private static final String VIDEO_TRACKER = "Tracking";
    private static final String TRACKING_EVENTS = "TrackingEvents";
    private static final String COMPANION_CLICK_THROUGH = "CompanionClickThrough";
    private static final String COMPANION_CLICK_TRACKING = "CompanionClickTracking";
    private static final String EVENT = "event";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String AD_SLOT_ID = "adSlotID";
    private static final String CREATIVE_VIEW = "creativeView";
    @NonNull
    private final Node mCompanionNode;
    @NonNull
    private final VastResourceXmlManager mResourceXmlManager;

    VastCompanionAdXmlManager(@NonNull Node companionNode) {
        Preconditions.checkNotNull(companionNode, "companionNode cannot be null");
        this.mCompanionNode = companionNode;
        this.mResourceXmlManager = new VastResourceXmlManager(companionNode);
    }

    @Nullable
    Integer getWidth() {
        return XmlUtils.getAttributeValueAsInt(this.mCompanionNode, WIDTH);
    }

    @Nullable
    Integer getHeight() {
        return XmlUtils.getAttributeValueAsInt(this.mCompanionNode, HEIGHT);
    }

    @Nullable
    String getAdSlotId() {
        return XmlUtils.getAttributeValue(this.mCompanionNode, AD_SLOT_ID);
    }

    @NonNull
    VastResourceXmlManager getResourceXmlManager() {
        return this.mResourceXmlManager;
    }

    @Nullable
    String getClickThroughUrl() {
        Node node = XmlUtils.getFirstMatchingChildNode(this.mCompanionNode, COMPANION_CLICK_THROUGH);
        return XmlUtils.getNodeValue(node);
    }

    @NonNull
    List<VastTracker> getClickTrackers() {
        ArrayList<VastTracker> companionAdClickTrackers = new ArrayList<VastTracker>();
        List<Node> trackerNodes = XmlUtils.getMatchingChildNodes(this.mCompanionNode, COMPANION_CLICK_TRACKING);
        if (trackerNodes == null) {
            return companionAdClickTrackers;
        }
        for (Node trackerNode : trackerNodes) {
            String uri = XmlUtils.getNodeValue(trackerNode);
            if (TextUtils.isEmpty((CharSequence)uri)) continue;
            companionAdClickTrackers.add(new VastTracker(uri));
        }
        return companionAdClickTrackers;
    }

    @NonNull
    List<VastTracker> getCompanionCreativeViewTrackers() {
        ArrayList<VastTracker> companionCreativeViewTrackers = new ArrayList<VastTracker>();
        Node node = XmlUtils.getFirstMatchingChildNode(this.mCompanionNode, TRACKING_EVENTS);
        if (node == null) {
            return companionCreativeViewTrackers;
        }
        List<Node> trackerNodes = XmlUtils.getMatchingChildNodes(node, VIDEO_TRACKER, EVENT, Collections.singletonList(CREATIVE_VIEW));
        for (Node trackerNode : trackerNodes) {
            String trackerUrl = XmlUtils.getNodeValue(trackerNode);
            companionCreativeViewTrackers.add(new VastTracker(trackerUrl));
        }
        return companionCreativeViewTrackers;
    }

    boolean hasResources() {
        return !TextUtils.isEmpty((CharSequence)this.mResourceXmlManager.getStaticResource()) || !TextUtils.isEmpty((CharSequence)this.mResourceXmlManager.getHTMLResource()) || !TextUtils.isEmpty((CharSequence)this.mResourceXmlManager.getIFrameResource());
    }
}

