/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.mopub.common.BaseUrlGenerator;
import com.mopub.common.ClientMetadata;
import com.mopub.common.SharedPreferencesHelper;
import com.mopub.common.logging.MoPubLog;
import com.mopub.network.TrackingRequest;
import com.mopub.volley.VolleyError;

public class MoPubConversionTracker {
    private Context mContext;
    private String mIsTrackedKey;
    private SharedPreferences mSharedPreferences;
    private String mPackageName;

    public void reportAppOpen(Context context) {
        if (context == null) {
            return;
        }
        this.mContext = context;
        this.mPackageName = this.mContext.getPackageName();
        this.mIsTrackedKey = this.mPackageName + " tracked";
        this.mSharedPreferences = SharedPreferencesHelper.getSharedPreferences(this.mContext);
        if (!this.isAlreadyTracked()) {
            TrackingRequest.makeTrackingHttpRequest(new ConversionUrlGenerator().generateUrlString("ads.mopub.com"), this.mContext, new TrackingRequest.Listener(){

                @Override
                public void onResponse(@NonNull String url) {
                    MoPubConversionTracker.this.mSharedPreferences.edit().putBoolean(MoPubConversionTracker.this.mIsTrackedKey, true).commit();
                }

                public void onErrorResponse(VolleyError volleyError) {
                }
            });
        } else {
            MoPubLog.d("Conversion already tracked");
        }
    }

    private boolean isAlreadyTracked() {
        return this.mSharedPreferences.getBoolean(this.mIsTrackedKey, false);
    }

    private class ConversionUrlGenerator
    extends BaseUrlGenerator {
        private ConversionUrlGenerator() {
        }

        @Override
        public String generateUrlString(String serverHostname) {
            this.initUrlString(serverHostname, "/m/open");
            this.setApiVersion("6");
            this.setPackageId(MoPubConversionTracker.this.mPackageName);
            ClientMetadata clientMetadata = ClientMetadata.getInstance(MoPubConversionTracker.this.mContext);
            this.setAppVersion(clientMetadata.getAppVersion());
            this.appendAdvertisingInfoTemplates();
            return this.getFinalUrlString();
        }

        private void setPackageId(String packageName) {
            this.addParam("id", packageName);
        }
    }
}

