/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import java.util.Map;
import java.util.TreeMap;

public class AdRequestStatusMapping {
    @NonNull
    private final Map<String, AdRequestStatus> mAdUnitToAdRequestStatus = new TreeMap<String, AdRequestStatus>();

    void markFail(@NonNull String adUnitId) {
        this.mAdUnitToAdRequestStatus.remove(adUnitId);
    }

    void markLoading(@NonNull String adUnitId) {
        this.mAdUnitToAdRequestStatus.put(adUnitId, new AdRequestStatus(LoadingStatus.LOADING));
    }

    void markLoaded(@NonNull String adUnitId, @Nullable String failUrlString, @Nullable String impressionTrackerUrlString, @Nullable String clickTrackerUrlString) {
        this.mAdUnitToAdRequestStatus.put(adUnitId, new AdRequestStatus(LoadingStatus.LOADED, failUrlString, impressionTrackerUrlString, clickTrackerUrlString));
    }

    void markPlayed(@NonNull String adUnitId) {
        if (this.mAdUnitToAdRequestStatus.containsKey(adUnitId)) {
            AdRequestStatus adRequestStatus = this.mAdUnitToAdRequestStatus.get(adUnitId);
            adRequestStatus.setStatus(LoadingStatus.PLAYED);
        } else {
            this.mAdUnitToAdRequestStatus.put(adUnitId, new AdRequestStatus(LoadingStatus.PLAYED));
        }
    }

    boolean canPlay(@NonNull String adUnitId) {
        AdRequestStatus adRequestStatus = this.mAdUnitToAdRequestStatus.get(adUnitId);
        return adRequestStatus != null && LoadingStatus.LOADED.equals((Object)adRequestStatus.getStatus());
    }

    boolean isLoading(@NonNull String adUnitId) {
        if (!this.mAdUnitToAdRequestStatus.containsKey(adUnitId)) {
            return false;
        }
        return this.mAdUnitToAdRequestStatus.get(adUnitId).getStatus() == LoadingStatus.LOADING;
    }

    @Nullable
    String getFailoverUrl(@NonNull String adUnitId) {
        if (!this.mAdUnitToAdRequestStatus.containsKey(adUnitId)) {
            return null;
        }
        return this.mAdUnitToAdRequestStatus.get(adUnitId).getFailurl();
    }

    @Nullable
    String getImpressionTrackerUrlString(@NonNull String adUnitId) {
        if (!this.mAdUnitToAdRequestStatus.containsKey(adUnitId)) {
            return null;
        }
        return this.mAdUnitToAdRequestStatus.get(adUnitId).getImpressionUrl();
    }

    @Nullable
    String getClickTrackerUrlString(@NonNull String adUnitId) {
        if (!this.mAdUnitToAdRequestStatus.containsKey(adUnitId)) {
            return null;
        }
        return this.mAdUnitToAdRequestStatus.get(adUnitId).getClickUrl();
    }

    void clearImpressionUrl(@NonNull String adUnitId) {
        if (this.mAdUnitToAdRequestStatus.containsKey(adUnitId)) {
            this.mAdUnitToAdRequestStatus.get(adUnitId).setImpressionUrl(null);
        }
    }

    void clearClickUrl(@NonNull String adUnitId) {
        if (this.mAdUnitToAdRequestStatus.containsKey(adUnitId)) {
            this.mAdUnitToAdRequestStatus.get(adUnitId).setClickUrl(null);
        }
    }

    @Deprecated
    @VisibleForTesting
    void clearMapping() {
        this.mAdUnitToAdRequestStatus.clear();
    }

    private static class AdRequestStatus {
        @NonNull
        private LoadingStatus mLoadingStatus;
        @Nullable
        private String mFailUrl;
        @Nullable
        private String mImpressionUrl;
        @Nullable
        private String mClickUrl;

        public AdRequestStatus(@NonNull LoadingStatus loadingStatus) {
            this(loadingStatus, null, null, null);
        }

        public AdRequestStatus(@NonNull LoadingStatus loadingStatus, @Nullable String failUrl, @Nullable String impressionUrl, @Nullable String clickUrl) {
            Preconditions.checkNotNull((Object)loadingStatus);
            this.mLoadingStatus = loadingStatus;
            this.mFailUrl = failUrl;
            this.mImpressionUrl = impressionUrl;
            this.mClickUrl = clickUrl;
        }

        @NonNull
        private LoadingStatus getStatus() {
            return this.mLoadingStatus;
        }

        private void setStatus(@NonNull LoadingStatus loadingStatus) {
            this.mLoadingStatus = loadingStatus;
        }

        @Nullable
        private String getFailurl() {
            return this.mFailUrl;
        }

        @Nullable
        private String getImpressionUrl() {
            return this.mImpressionUrl;
        }

        private void setImpressionUrl(@Nullable String impressionUrl) {
            this.mImpressionUrl = impressionUrl;
        }

        @Nullable
        private String getClickUrl() {
            return this.mClickUrl;
        }

        private void setClickUrl(@Nullable String clickUrl) {
            this.mClickUrl = clickUrl;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof AdRequestStatus)) {
                return false;
            }
            AdRequestStatus that = (AdRequestStatus)o;
            return this.mLoadingStatus.equals((Object)that.mLoadingStatus) && TextUtils.equals((CharSequence)this.mFailUrl, (CharSequence)that.mFailUrl) && TextUtils.equals((CharSequence)this.mImpressionUrl, (CharSequence)that.mImpressionUrl) && TextUtils.equals((CharSequence)this.mClickUrl, (CharSequence)that.mClickUrl);
        }

        public int hashCode() {
            int result = 29;
            result = 31 * result + this.mLoadingStatus.ordinal();
            result = 31 * result + (this.mFailUrl != null ? this.mFailUrl.hashCode() : 0);
            result = 31 * result + (this.mImpressionUrl != null ? this.mImpressionUrl.hashCode() : 0);
            result = 31 * result + (this.mClickUrl != null ? this.mClickUrl.hashCode() : 0);
            return result;
        }
    }

    private static enum LoadingStatus {
        LOADING,
        LOADED,
        PLAYED;

    }
}

