/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;
import com.mopub.common.logging.MoPubLog;

public class Views {
    public static void removeFromParent(@Nullable View view) {
        if (view == null || view.getParent() == null) {
            return;
        }
        if (view.getParent() instanceof ViewGroup) {
            ((ViewGroup)view.getParent()).removeView(view);
        }
    }

    @Nullable
    public static View getTopmostView(@Nullable Context context, @Nullable View view) {
        View rootViewFromActivity = Views.getRootViewFromActivity(context);
        View rootViewFromView = Views.getRootViewFromView(view);
        return rootViewFromActivity != null ? rootViewFromActivity : rootViewFromView;
    }

    @Nullable
    private static View getRootViewFromActivity(@Nullable Context context) {
        if (!(context instanceof Activity)) {
            return null;
        }
        return ((Activity)context).getWindow().getDecorView().findViewById(0x1020002);
    }

    @Nullable
    private static View getRootViewFromView(@Nullable View view) {
        View rootView;
        if (view == null) {
            return null;
        }
        if (!ViewCompat.isAttachedToWindow((View)view)) {
            MoPubLog.d("Attempting to call View#getRootView() on an unattached View.");
        }
        if ((rootView = view.getRootView()) == null) {
            return null;
        }
        View rootContentView = rootView.findViewById(0x1020002);
        return rootContentView != null ? rootContentView : rootView;
    }
}

