/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mopub.common.MoPubBrowser;
import com.mopub.common.Preconditions;
import com.mopub.common.UrlAction;
import com.mopub.common.logging.MoPubLog;
import com.mopub.exceptions.IntentNotResolvableException;
import com.mopub.exceptions.UrlParseException;
import java.util.List;

public class Intents {
    private Intents() {
    }

    public static void startActivity(@NonNull Context context, @NonNull Intent intent) throws IntentNotResolvableException {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(intent);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            throw new IntentNotResolvableException(e);
        }
    }

    public static Intent getStartActivityIntent(@NonNull Context context, @NonNull Class clazz, @Nullable Bundle extras) {
        Intent intent = new Intent(context, clazz);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        if (extras != null) {
            intent.putExtras(extras);
        }
        return intent;
    }

    public static boolean deviceCanHandleIntent(@NonNull Context context, @NonNull Intent intent) {
        try {
            PackageManager packageManager = context.getPackageManager();
            List activities = packageManager.queryIntentActivities(intent, 0);
            return !activities.isEmpty();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static Intent intentForNativeBrowserScheme(@NonNull Uri uri) throws UrlParseException {
        String urlToOpenInNativeBrowser;
        Preconditions.checkNotNull(uri);
        if (!UrlAction.OPEN_NATIVE_BROWSER.shouldTryHandlingUrl(uri)) {
            throw new UrlParseException("URL does not have mopubnativebrowser:// scheme.");
        }
        if (!"navigate".equals(uri.getHost())) {
            throw new UrlParseException("URL missing 'navigate' host parameter.");
        }
        try {
            urlToOpenInNativeBrowser = uri.getQueryParameter("url");
        }
        catch (UnsupportedOperationException e) {
            MoPubLog.w("Could not handle url: " + uri);
            throw new UrlParseException("Passed-in URL did not create a hierarchical URI.");
        }
        if (urlToOpenInNativeBrowser == null) {
            throw new UrlParseException("URL missing 'url' query parameter.");
        }
        Uri intentUri = Uri.parse((String)urlToOpenInNativeBrowser);
        return new Intent("android.intent.action.VIEW", intentUri);
    }

    public static Intent intentForShareTweet(@NonNull Uri uri) throws UrlParseException {
        String tweetId;
        String screenName;
        if (!UrlAction.HANDLE_SHARE_TWEET.shouldTryHandlingUrl(uri)) {
            throw new UrlParseException("URL does not have mopubshare://tweet? format.");
        }
        try {
            screenName = uri.getQueryParameter("screen_name");
            tweetId = uri.getQueryParameter("tweet_id");
        }
        catch (UnsupportedOperationException e) {
            MoPubLog.w("Could not handle url: " + uri);
            throw new UrlParseException("Passed-in URL did not create a hierarchical URI.");
        }
        if (TextUtils.isEmpty((CharSequence)screenName)) {
            throw new UrlParseException("URL missing non-empty 'screen_name' query parameter.");
        }
        if (TextUtils.isEmpty((CharSequence)tweetId)) {
            throw new UrlParseException("URL missing non-empty 'tweet_id' query parameter.");
        }
        String tweetUrl = String.format("https://twitter.com/%s/status/%s", screenName, tweetId);
        String shareMessage = String.format("Check out @%s's Tweet: %s", screenName, tweetUrl);
        Intent shareTweetIntent = new Intent("android.intent.action.SEND");
        shareTweetIntent.setType("text/plain");
        shareTweetIntent.putExtra("android.intent.extra.SUBJECT", shareMessage);
        shareTweetIntent.putExtra("android.intent.extra.TEXT", shareMessage);
        return shareTweetIntent;
    }

    public static void showMoPubBrowserForUrl(@NonNull Context context, @NonNull Uri uri, @Nullable String dspCreativeId) throws IntentNotResolvableException {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        MoPubLog.d("Final URI to show in browser: " + uri);
        Bundle extras = new Bundle();
        extras.putString("URL", uri.toString());
        if (!TextUtils.isEmpty((CharSequence)dspCreativeId)) {
            extras.putString("mopub-dsp-creative-id", dspCreativeId);
        }
        Intent intent = Intents.getStartActivityIntent(context, MoPubBrowser.class, extras);
        String errorMessage = "Could not show MoPubBrowser for url: " + uri + "\n\tPerhaps you " + "forgot to declare com.mopub.common.MoPubBrowser in your Android manifest file.";
        Intents.launchIntentForUserClick(context, intent, errorMessage);
    }

    public static void launchIntentForUserClick(@NonNull Context context, @NonNull Intent intent, @Nullable String errorMessage) throws IntentNotResolvableException {
        Preconditions.NoThrow.checkNotNull(context);
        Preconditions.NoThrow.checkNotNull(intent);
        try {
            Intents.startActivity(context, intent);
        }
        catch (IntentNotResolvableException e) {
            throw new IntentNotResolvableException(errorMessage + "\n" + e.getMessage());
        }
    }

    public static void launchApplicationUrl(@NonNull Context context, @NonNull Uri uri) throws IntentNotResolvableException {
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        if (!Intents.deviceCanHandleIntent(context, intent)) {
            throw new IntentNotResolvableException("Could not handle application specific action: " + uri + "\n\tYou may be running in the emulator or another " + "device which does not have the required application.");
        }
        Intents.launchApplicationIntent(context, intent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void launchApplicationIntent(@NonNull Context context, @NonNull Intent intent) throws IntentNotResolvableException {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(intent);
        if (Intents.deviceCanHandleIntent(context, intent)) {
            String errorMessage = "Unable to open intent: " + intent;
            if (!(context instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            Intents.launchIntentForUserClick(context, intent, errorMessage);
            return;
        } else {
            String fallbackUrl = intent.getStringExtra("browser_fallback_url");
            if (TextUtils.isEmpty((CharSequence)fallbackUrl)) {
                if ("market".equalsIgnoreCase(intent.getScheme())) throw new IntentNotResolvableException("Device could not handle neither intent nor market url.\nIntent: " + intent.toString());
                Intents.launchApplicationUrl(context, Intents.getPlayStoreUri(intent));
                return;
            } else {
                Uri fallbackUri = Uri.parse((String)fallbackUrl);
                String fallbackScheme = fallbackUri.getScheme();
                if ("http".equalsIgnoreCase(fallbackScheme) || "https".equalsIgnoreCase(fallbackScheme)) {
                    Intents.showMoPubBrowserForUrl(context, fallbackUri, null);
                    return;
                } else {
                    Intents.launchApplicationUrl(context, fallbackUri);
                }
            }
        }
    }

    @NonNull
    public static Uri getPlayStoreUri(@NonNull Intent intent) {
        Preconditions.checkNotNull(intent);
        return Uri.parse((String)("market://details?id=" + intent.getPackage()));
    }

    public static void launchActionViewIntent(@NonNull Context context, @NonNull Uri uri, @Nullable String errorMessage) throws IntentNotResolvableException {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        Intents.launchIntentForUserClick(context, intent, errorMessage);
    }

    @Deprecated
    public static boolean canHandleApplicationUrl(Context context, Uri uri) {
        return false;
    }

    @Deprecated
    public static boolean canHandleApplicationUrl(Context context, Uri uri, boolean logError) {
        return false;
    }
}

