/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import android.annotation.TargetApi;
import android.os.AsyncTask;
import android.os.Build;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class AsyncTasks {
    private static Executor sExecutor;

    @TargetApi(value=11)
    private static void init() {
        sExecutor = Build.VERSION.SDK_INT >= 11 ? AsyncTask.THREAD_POOL_EXECUTOR : Executors.newSingleThreadExecutor();
    }

    @VisibleForTesting
    public static void setExecutor(Executor executor) {
        sExecutor = executor;
    }

    @TargetApi(value=11)
    public static <P> void safeExecuteOnExecutor(AsyncTask<P, ?, ?> asyncTask, P ... params) {
        Preconditions.checkNotNull(asyncTask, "Unable to execute null AsyncTask.");
        Preconditions.checkUiThread("AsyncTask must be executed on the main thread");
        if (Build.VERSION.SDK_INT >= 11) {
            asyncTask.executeOnExecutor(sExecutor, (Object[])params);
        } else {
            asyncTask.execute((Object[])params);
        }
    }

    static {
        AsyncTasks.init();
    }
}

