/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.event;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.event.BaseEvent;
import com.mopub.common.event.EventRecorder;
import com.mopub.common.logging.MoPubLog;

public class EventDispatcher {
    private final Iterable<EventRecorder> mEventRecorders;
    private final Looper mLooper;
    private final Handler mMessageHandler;
    private final Handler.Callback mHandlerCallback;

    @VisibleForTesting
    EventDispatcher(Iterable<EventRecorder> recorders, Looper looper) {
        this.mEventRecorders = recorders;
        this.mLooper = looper;
        this.mHandlerCallback = new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                if (msg.obj instanceof BaseEvent) {
                    for (EventRecorder recorder : EventDispatcher.this.mEventRecorders) {
                        recorder.record((BaseEvent)msg.obj);
                    }
                } else {
                    MoPubLog.d("EventDispatcher received non-BaseEvent message type.");
                }
                return true;
            }
        };
        this.mMessageHandler = new Handler(this.mLooper, this.mHandlerCallback);
    }

    public void dispatch(BaseEvent event) {
        Message.obtain((Handler)this.mMessageHandler, (int)0, (Object)event).sendToTarget();
    }

    @VisibleForTesting
    Iterable<EventRecorder> getEventRecorders() {
        return this.mEventRecorders;
    }

    @VisibleForTesting
    Handler.Callback getHandlerCallback() {
        return this.mHandlerCallback;
    }
}

