/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mopub.common.MediationSettings;
import com.mopub.common.MoPubLifecycleManager;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Reflection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MoPub {
    public static final String SDK_VERSION = "4.11.0";
    private static final String MOPUB_REWARDED_VIDEOS = "com.mopub.mobileads.MoPubRewardedVideos";
    private static final String MOPUB_REWARDED_VIDEO_MANAGER = "com.mopub.mobileads.MoPubRewardedVideoManager";
    private static final String MOPUB_REWARDED_VIDEO_LISTENER = "com.mopub.mobileads.MoPubRewardedVideoListener";
    private static final String MOPUB_REWARDED_VIDEO_MANAGER_REQUEST_PARAMETERS = "com.mopub.mobileads.MoPubRewardedVideoManager$RequestParameters";
    private static final int DEFAULT_LOCATION_PRECISION = 6;
    private static volatile LocationAwareness sLocationLocationAwareness = LocationAwareness.NORMAL;
    private static volatile int sLocationPrecision = 6;
    private static boolean sSearchedForUpdateActivityMethod = false;
    @Nullable
    private static Method sUpdateActivityMethod;

    public static LocationAwareness getLocationAwareness() {
        return sLocationLocationAwareness;
    }

    public static void setLocationAwareness(LocationAwareness locationAwareness) {
        sLocationLocationAwareness = locationAwareness;
    }

    public static int getLocationPrecision() {
        return sLocationPrecision;
    }

    public static void setLocationPrecision(int precision) {
        sLocationPrecision = Math.min(Math.max(0, precision), 6);
    }

    public static void onCreate(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onCreate(activity);
        MoPub.updateActivity(activity);
    }

    public static void onStart(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onStart(activity);
        MoPub.updateActivity(activity);
    }

    public static void onPause(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onPause(activity);
    }

    public static void onResume(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onResume(activity);
        MoPub.updateActivity(activity);
    }

    public static void onRestart(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onRestart(activity);
        MoPub.updateActivity(activity);
    }

    public static void onStop(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onStop(activity);
    }

    public static void onDestroy(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onDestroy(activity);
    }

    public static void onBackPressed(@NonNull Activity activity) {
        MoPubLifecycleManager.getInstance(activity).onBackPressed(activity);
    }

    @Deprecated
    public static void initializeRewardedVideo(@NonNull Activity activity, MediationSettings ... mediationSettings) {
        try {
            new Reflection.MethodBuilder(null, "initializeRewardedVideo").setStatic(Class.forName(MOPUB_REWARDED_VIDEOS)).addParam(Activity.class, activity).addParam(MediationSettings[].class, mediationSettings).execute();
        }
        catch (ClassNotFoundException e) {
            MoPubLog.w("initializeRewardedVideo was called without the rewarded video module");
        }
        catch (NoSuchMethodException e) {
            MoPubLog.w("initializeRewardedVideo was called without the rewarded video module");
        }
        catch (Exception e) {
            MoPubLog.e("Error while initializing rewarded video", e);
        }
    }

    @VisibleForTesting
    static void updateActivity(@NonNull Activity activity) {
        if (!sSearchedForUpdateActivityMethod) {
            sSearchedForUpdateActivityMethod = true;
            try {
                Class<?> moPubRewardedVideoManagerClass = Class.forName(MOPUB_REWARDED_VIDEO_MANAGER);
                sUpdateActivityMethod = Reflection.getDeclaredMethodWithTraversal(moPubRewardedVideoManagerClass, "updateActivity", Activity.class);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (sUpdateActivityMethod != null) {
            try {
                sUpdateActivityMethod.invoke(null, activity);
            }
            catch (IllegalAccessException e) {
                MoPubLog.e("Error while attempting to access the update activity method - this should not have happened", e);
            }
            catch (InvocationTargetException e) {
                MoPubLog.e("Error while attempting to access the update activity method - this should not have happened", e);
            }
        }
    }

    @Deprecated
    public static void setRewardedVideoListener(@Nullable Object listener) {
        try {
            Class<?> moPubRewardedVideoListenerClass = Class.forName(MOPUB_REWARDED_VIDEO_LISTENER);
            new Reflection.MethodBuilder(null, "setRewardedVideoListener").setStatic(Class.forName(MOPUB_REWARDED_VIDEOS)).addParam(moPubRewardedVideoListenerClass, listener).execute();
        }
        catch (ClassNotFoundException e) {
            MoPubLog.w("setRewardedVideoListener was called without the rewarded video module");
        }
        catch (NoSuchMethodException e) {
            MoPubLog.w("setRewardedVideoListener was called without the rewarded video module");
        }
        catch (Exception e) {
            MoPubLog.e("Error while setting rewarded video listener", e);
        }
    }

    @Deprecated
    public static void loadRewardedVideo(@NonNull String adUnitId, MediationSettings ... mediationSettings) {
        MoPub.loadRewardedVideo(adUnitId, null, mediationSettings);
    }

    @Deprecated
    public static void loadRewardedVideo(@NonNull String adUnitId, @Nullable Object requestParameters, MediationSettings ... mediationSettings) {
        try {
            Class<?> requestParametersClass = Class.forName(MOPUB_REWARDED_VIDEO_MANAGER_REQUEST_PARAMETERS);
            new Reflection.MethodBuilder(null, "loadRewardedVideo").setStatic(Class.forName(MOPUB_REWARDED_VIDEOS)).addParam(String.class, adUnitId).addParam(requestParametersClass, requestParameters).addParam(MediationSettings[].class, mediationSettings).execute();
        }
        catch (ClassNotFoundException e) {
            MoPubLog.w("loadRewardedVideo was called without the rewarded video module");
        }
        catch (NoSuchMethodException e) {
            MoPubLog.w("loadRewardedVideo was called without the rewarded video module");
        }
        catch (Exception e) {
            MoPubLog.e("Error while loading rewarded video", e);
        }
    }

    @Deprecated
    public static boolean hasRewardedVideo(@NonNull String adUnitId) {
        try {
            return (Boolean)new Reflection.MethodBuilder(null, "hasRewardedVideo").setStatic(Class.forName(MOPUB_REWARDED_VIDEOS)).addParam(String.class, adUnitId).execute();
        }
        catch (ClassNotFoundException e) {
            MoPubLog.w("hasRewardedVideo was called without the rewarded video module");
        }
        catch (NoSuchMethodException e) {
            MoPubLog.w("hasRewardedVideo was called without the rewarded video module");
        }
        catch (Exception e) {
            MoPubLog.e("Error while checking rewarded video", e);
        }
        return false;
    }

    @Deprecated
    public static void showRewardedVideo(@NonNull String adUnitId) {
        try {
            new Reflection.MethodBuilder(null, "showRewardedVideo").setStatic(Class.forName(MOPUB_REWARDED_VIDEOS)).addParam(String.class, adUnitId).execute();
        }
        catch (ClassNotFoundException e) {
            MoPubLog.w("showRewardedVideo was called without the rewarded video module");
        }
        catch (NoSuchMethodException e) {
            MoPubLog.w("showRewardedVideo was called without the rewarded video module");
        }
        catch (Exception e) {
            MoPubLog.e("Error while showing rewarded video", e);
        }
    }

    public static enum LocationAwareness {
        NORMAL,
        TRUNCATED,
        DISABLED;

    }
}

