/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common;

import com.mopub.common.util.ResponseHeader;
import com.mopub.common.util.Streams;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public class DownloadResponse {
    private byte[] mBytes = new byte[0];
    private final int mStatusCode;
    private final long mContentLength;
    private final Header[] mHeaders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadResponse(HttpResponse httpResponse) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedInputStream inputStream = null;
        try {
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                inputStream = new BufferedInputStream(httpEntity.getContent());
                Streams.copyContent(inputStream, outputStream);
                this.mBytes = outputStream.toByteArray();
            }
        }
        finally {
            Streams.closeStream(inputStream);
            Streams.closeStream(outputStream);
        }
        this.mStatusCode = httpResponse.getStatusLine().getStatusCode();
        this.mContentLength = this.mBytes.length;
        this.mHeaders = httpResponse.getAllHeaders();
    }

    public byte[] getByteArray() {
        return this.mBytes;
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public long getContentLength() {
        return this.mContentLength;
    }

    public String getFirstHeader(ResponseHeader responseHeader) {
        for (Header header : this.mHeaders) {
            if (!header.getName().equalsIgnoreCase(responseHeader.getKey())) continue;
            return header.getValue();
        }
        return null;
    }
}

