/*
 * Decompiled with CFR 0.152.
 */
package com.moonearly.utils.service;

import android.text.TextUtils;
import android.util.Log;
import com.moonearly.model.UdpMsg;
import com.moonearly.utils.service.JSONCallBack;
import com.moonearly.utils.service.TcpSendCallBack;
import com.moonearly.utils.service.UdpSendCallBack;
import com.moonearly.utils.service.UdpServiceCallBack;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

public class TcpUdpFactory {
    private static ServerSocket mSocket;
    private static DatagramSocket mDSocket;
    public static final int TCP_SERVER_PORT_DEFAULT = 8800;
    public static final int UDP_SERVER_PORT_DEFAULT = 9900;
    private static int localUdpPort;
    private static int localTcpPort;
    private static final String UDP_ACK_IP = "Please give me your IP address";
    private static final String UDP_REQUEST_IP = "My IP address is ...";
    private static final String UDP_REQUEST_MSG = "My MSG is ...";
    public static String S_ENCODING;
    public static final int CONNECT_TIMEOUT = 4000;
    public static final String TAG;
    public static TcpDaemonRunnable sTcpDaemonTask;
    public static UdpDaemonRunnable sUdpDaemonTask;
    private static JSONCallBack jsonCallBack;
    private static Map<Integer, String> ipMap;
    private static String mOldServerIp;

    public static void startTcpServer(int index, JSONCallBack MJsonCallBack) {
        jsonCallBack = MJsonCallBack;
        localTcpPort = 8800 + index;
        try {
            mSocket = new ServerSocket(localTcpPort);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage().toString());
            return;
        }
        sTcpDaemonTask = new TcpDaemonRunnable();
        Thread recThread = new Thread(sTcpDaemonTask);
        recThread.setName("TCP_server");
        recThread.setPriority(8);
        recThread.start();
    }

    public static void stopTcpServer() {
        if (sTcpDaemonTask != null) {
            sTcpDaemonTask.stop();
            sTcpDaemonTask = null;
            jsonCallBack = null;
            try {
                mSocket.close();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)e.getMessage().toString());
            }
        }
    }

    public static void startUdpServer(int index, String revenueCenterName, UdpServiceCallBack udpServiceCallBack) {
        localUdpPort = 9900 + index;
        try {
            if (mDSocket == null) {
                mDSocket = new DatagramSocket(null);
                mDSocket.setReuseAddress(true);
                mDSocket.setBroadcast(true);
                mDSocket.bind(new InetSocketAddress(localUdpPort));
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("new DatagramSocket FAIL" + e.getMessage().toString()));
            return;
        }
        sUdpDaemonTask = new UdpDaemonRunnable(udpServiceCallBack);
        Thread udprecThread = new Thread(sUdpDaemonTask);
        udprecThread.setName(revenueCenterName);
        udprecThread.setPriority(8);
        udprecThread.start();
    }

    public static void stopUdpServer() {
        if (sUdpDaemonTask != null) {
            sUdpDaemonTask.stop();
            sUdpDaemonTask = null;
            mDSocket.close();
        }
    }

    private static void udpSend(final String ip, final int port, final byte[] data, final UdpSendCallBack udpSendCallBack) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        InetAddress serverAddress = InetAddress.getByName(ip);
                        DatagramPacket packet = new DatagramPacket(data, data.length, serverAddress, port);
                        mDSocket.send(packet);
                        if (udpSendCallBack != null) {
                            udpSendCallBack.call(true);
                        }
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (String)("udpSend \u5f02\u5e38" + e.getMessage().toString()));
                        if (udpSendCallBack == null) break block3;
                        udpSendCallBack.call(false);
                    }
                }
            }
        }).start();
    }

    public static void tcpSend(final int index, final byte[] data, final TcpSendCallBack tcpSendCallBack) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    String ip = (String)ipMap.get(index);
                    if (TextUtils.isEmpty((CharSequence)ip)) {
                        Log.d((String)TAG, (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u4e3b\u673a,\u8bf7\u5148\u83b7\u53d6\u4e3b\u673aip");
                        return;
                    }
                    try {
                        Socket socket = new Socket();
                        socket.connect(new InetSocketAddress(ip, 8800 + index), 4000);
                        OutputStream out = socket.getOutputStream();
                        out.write(data);
                        out.flush();
                        socket.close();
                        if (tcpSendCallBack != null) {
                            tcpSendCallBack.call(true);
                        }
                    }
                    catch (IOException e) {
                        Log.w((String)TAG, (String)("tcpSend fail" + e.getMessage().toString()));
                        if (tcpSendCallBack == null) break block4;
                        tcpSendCallBack.call(false);
                    }
                }
            }
        }).start();
    }

    public static void tcpSend(final int index, final String strMsg, final TcpSendCallBack tcpSendCallBack) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        String ip = (String)ipMap.get(index);
                        if (TextUtils.isEmpty((CharSequence)ip)) {
                            Log.d((String)TAG, (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u4e3b\u673a,\u8bf7\u5148\u83b7\u53d6\u4e3b\u673aip");
                            return;
                        }
                        Socket socket = new Socket();
                        socket.connect(new InetSocketAddress(ip, 8800 + index), 4000);
                        OutputStream out = socket.getOutputStream();
                        out.write(strMsg.getBytes(S_ENCODING));
                        out.flush();
                        socket.close();
                        if (tcpSendCallBack != null) {
                            tcpSendCallBack.call(true);
                        }
                    }
                    catch (IOException e) {
                        if (tcpSendCallBack == null) break block4;
                        tcpSendCallBack.call(false);
                    }
                }
            }
        }).start();
    }

    public static void getServiceIp(int index, UdpSendCallBack udpSendCallBack) {
        TcpUdpFactory.udpSend("255.255.255.255", 9900 + index, UDP_ACK_IP.getBytes(), udpSendCallBack);
    }

    public static void sendUdpMsg(int index, String msg, UdpSendCallBack udpSendCallBack) {
        TcpUdpFactory.udpSend("255.255.255.255", 9900 + index, msg.getBytes(), udpSendCallBack);
    }

    public static void sendUdpMsg(String ip, int index, String msg, UdpSendCallBack udpSendCallBack) {
        TcpUdpFactory.udpSend(ip, 9900 + index, msg.getBytes(), udpSendCallBack);
    }

    static {
        localUdpPort = 9900;
        localTcpPort = 8800;
        S_ENCODING = "UTF-8";
        TAG = TcpUdpFactory.class.getSimpleName();
        sTcpDaemonTask = null;
        sUdpDaemonTask = null;
        ipMap = new HashMap<Integer, String>();
        mOldServerIp = "";
    }

    private static class UdpDaemonRunnable
    implements Runnable {
        private boolean done = false;
        private UdpServiceCallBack udpServiceCallBack;

        public UdpDaemonRunnable(UdpServiceCallBack udpServiceCallBack) {
            this.udpServiceCallBack = udpServiceCallBack;
        }

        public void stop() {
            this.done = true;
        }

        @Override
        public void run() {
            byte[] data = new byte[8192];
            int reConnect = 1;
            DatagramPacket packet = new DatagramPacket(data, data.length);
            while (!this.done) {
                try {
                    UdpMsg udpMsg;
                    mDSocket.receive(packet);
                    if (packet.getLength() < 1) continue;
                    String fromip = packet.getAddress().getHostAddress();
                    String msg = new String(packet.getData(), 0, packet.getLength());
                    int index = packet.getPort() - 9900;
                    if (msg.contains(TcpUdpFactory.UDP_ACK_IP)) {
                        ipMap.put(index, fromip);
                        Log.d((String)TAG, (String)String.format("\u4e3b\u673a\u7f16\u53f7:%d,ip:%s,\u8bf7\u6c42\u6211\u7684Ip,\u6b63\u5728\u56de\u590d...", index, fromip));
                        TcpUdpFactory.udpSend(packet.getAddress().getHostAddress(), packet.getPort(), TcpUdpFactory.UDP_REQUEST_IP.getBytes(), null);
                        continue;
                    }
                    if (msg.startsWith(TcpUdpFactory.UDP_REQUEST_MSG)) {
                        ipMap.put(index, fromip);
                        Log.d((String)TAG, (String)String.format("\u4e3b\u673a\u7f16\u53f7:%d,\u544a\u8bc9\u6211msg:%s", index, msg));
                        if (this.udpServiceCallBack == null) continue;
                        udpMsg = new UdpMsg(packet.getAddress().getHostAddress(), msg.replace(TcpUdpFactory.UDP_REQUEST_MSG, ""));
                        this.udpServiceCallBack.callBack(udpMsg);
                        continue;
                    }
                    if (!msg.contains(TcpUdpFactory.UDP_REQUEST_IP)) continue;
                    ipMap.put(index, fromip);
                    Log.d((String)TAG, (String)String.format("\u4e3b\u673a\u7f16\u53f7:%d,\u544a\u8bc9\u6211\u4ed6\u7684ip\u4e3a:%s,\u6b63\u5728\u56de\u590d...", index, fromip));
                    if (this.udpServiceCallBack == null) continue;
                    udpMsg = new UdpMsg(packet.getAddress().getHostAddress(), msg);
                    this.udpServiceCallBack.callBack(udpMsg);
                }
                catch (IOException e1) {
                    if (this.done) continue;
                    Log.w((String)TAG, (String)("\u53d1\u751f\u5f02\u5e38" + e1.getMessage().toString() + ",\u6b63\u5728\u5c1d\u8bd5\u91cd\u65b0\u542f\u52a8\u7b2c" + reConnect));
                    if (reConnect++ >= 10) continue;
                    try {
                        mDSocket.close();
                        mDSocket = new DatagramSocket(localUdpPort);
                        mDSocket.setBroadcast(true);
                    }
                    catch (IOException e2) {
                        Log.e((String)TAG, (String)("\u91cd\u65b0\u542f\u52a8\u53d1\u751f\u5f02\u5e38" + e2.getMessage().toString()));
                    }
                }
            }
        }
    }

    private static class TcpDaemonRunnable
    implements Runnable {
        private boolean done = false;
        private final int MAX_BUFFER_LEN = 1024;

        private TcpDaemonRunnable() {
        }

        public void stop() {
            this.done = true;
        }

        @Override
        public void run() {
            while (!this.done) {
                try {
                    Socket s = mSocket.accept();
                    s.setSoTimeout(5000);
                    InputStream in = s.getInputStream();
                    int len = 1024;
                    byte[] readbuff = new byte[len];
                    StringBuffer sb = new StringBuffer();
                    try {
                        int lon = in.available();
                        Log.d((String)TAG, (String)("\u6570\u636e\u957f\u5ea6" + lon));
                        Thread.sleep(lon / 102400);
                    }
                    catch (InterruptedException lon) {
                        // empty catch block
                    }
                    while ((len = in.read(readbuff, 0, len)) != -1) {
                        if (len < 1024) {
                            byte[] tmpBuf = new byte[len];
                            System.arraycopy(readbuff, 0, tmpBuf, 0, len);
                            sb.append(new String(tmpBuf, S_ENCODING));
                            continue;
                        }
                        sb.append(new String(readbuff, S_ENCODING));
                    }
                    String fromip = s.getInetAddress().getHostAddress();
                    String utf8code = sb.toString();
                    if (jsonCallBack == null) continue;
                    jsonCallBack.call(utf8code);
                }
                catch (IOException e1) {
                    if (this.done) continue;
                    Log.w((String)TAG, (String)("TcpDaemonTask \u5f02\u5e38" + e1.getMessage().toString()));
                    try {
                        mSocket.close();
                    }
                    catch (IOException e0) {
                        Log.w((String)TAG, (String)("mSocket.close \u5f02\u5e38" + e0.getMessage().toString()));
                    }
                    try {
                        mSocket = new ServerSocket(localTcpPort);
                    }
                    catch (IOException e2) {
                        Log.e((String)TAG, (String)("new ServerSocket \u5f02\u5e38" + e2.getMessage().toString()));
                    }
                }
            }
        }
    }
}

