/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.impl;

import com.monitorjbl.xlsx.exceptions.NotSupportedException;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class StreamingCell
implements Cell {
    private int columnIndex;
    private int rowIndex;
    private Object contents;
    private Object rawContents;
    private String numericFormat;
    private Short numericFormatIndex;
    private String type;
    private Row row;

    public StreamingCell(int columnIndex, int rowIndex) {
        this.columnIndex = columnIndex;
        this.rowIndex = rowIndex;
    }

    public Object getContents() {
        return this.contents;
    }

    public void setContents(Object contents) {
        this.contents = contents;
    }

    public Object getRawContents() {
        return this.rawContents;
    }

    public void setRawContents(Object rawContents) {
        this.rawContents = rawContents;
    }

    public String getNumericFormat() {
        return this.numericFormat;
    }

    public void setNumericFormat(String numericFormat) {
        this.numericFormat = numericFormat;
    }

    public Short getNumericFormatIndex() {
        return this.numericFormatIndex;
    }

    public void setNumericFormatIndex(Short numericFormatIndex) {
        this.numericFormatIndex = numericFormatIndex;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Row getRow() {
        return this.row;
    }

    public int getCellType() {
        if (this.contents == null || this.type == null) {
            return 3;
        }
        if ("n".equals(this.type)) {
            return 0;
        }
        if ("s".equals(this.type) || "inlineStr".equals(this.type)) {
            return 1;
        }
        if ("str".equals(this.type)) {
            return 2;
        }
        if ("b".equals(this.type)) {
            return 4;
        }
        if ("e".equals(this.type)) {
            return 5;
        }
        throw new UnsupportedOperationException("Unsupported cell type '" + this.type + "'");
    }

    public String getStringCellValue() {
        return this.contents == null ? "" : (String)this.contents;
    }

    public double getNumericCellValue() {
        return this.rawContents == null ? 0.0 : Double.parseDouble((String)this.rawContents);
    }

    public Date getDateCellValue() {
        return this.rawContents == null ? null : HSSFDateUtil.getJavaDate((double)this.getNumericCellValue());
    }

    public void setCellType(int cellType) {
        throw new NotSupportedException();
    }

    public Sheet getSheet() {
        throw new NotSupportedException();
    }

    public int getCachedFormulaResultType() {
        throw new NotSupportedException();
    }

    public void setCellValue(double value) {
        throw new NotSupportedException();
    }

    public void setCellValue(Date value) {
        throw new NotSupportedException();
    }

    public void setCellValue(Calendar value) {
        throw new NotSupportedException();
    }

    public void setCellValue(RichTextString value) {
        throw new NotSupportedException();
    }

    public void setCellValue(String value) {
        throw new NotSupportedException();
    }

    public void setCellFormula(String formula) throws FormulaParseException {
        throw new NotSupportedException();
    }

    public String getCellFormula() {
        throw new NotSupportedException();
    }

    public RichTextString getRichStringCellValue() {
        throw new NotSupportedException();
    }

    public void setCellValue(boolean value) {
        throw new NotSupportedException();
    }

    public void setCellErrorValue(byte value) {
        throw new NotSupportedException();
    }

    public boolean getBooleanCellValue() {
        return false;
    }

    public byte getErrorCellValue() {
        throw new NotSupportedException();
    }

    public void setCellStyle(CellStyle style) {
        throw new NotSupportedException();
    }

    public CellStyle getCellStyle() {
        throw new NotSupportedException();
    }

    public void setAsActiveCell() {
        throw new NotSupportedException();
    }

    public void setCellComment(Comment comment) {
        throw new NotSupportedException();
    }

    public Comment getCellComment() {
        throw new NotSupportedException();
    }

    public void removeCellComment() {
        throw new NotSupportedException();
    }

    public Hyperlink getHyperlink() {
        throw new NotSupportedException();
    }

    public void setHyperlink(Hyperlink link) {
        throw new NotSupportedException();
    }

    public void removeHyperlink() {
        throw new NotSupportedException();
    }

    public CellRangeAddress getArrayFormulaRange() {
        throw new NotSupportedException();
    }

    public boolean isPartOfArrayFormulaGroup() {
        throw new NotSupportedException();
    }
}

