/*
 * Decompiled with CFR 0.152.
 */
package com.monika.bottomnavigationbar;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DimenRes;
import android.support.annotation.NonNull;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.monika.bottomnavigationbar.BottomBarItem;
import com.monika.bottomnavigationbar.R;
import com.monika.bottomnavigationbar.TabAnimator;

class Tab {
    private final BottomBarItem item;
    private final View root;
    private final TextView title;
    private final Context context;
    private final ImageView icon;
    private final int activeTopMargin;
    private final int inactiveTopMargin;
    @ColorInt
    private final int activeColor;
    @ColorInt
    private final int inactiveColor;
    private final Drawable iconDrawable;

    Tab(@NonNull BottomBarItem item, @NonNull View root, @ColorInt int activeColor, @ColorInt int inactiveColor) {
        this.item = item;
        this.root = root;
        this.context = root.getContext();
        this.title = (TextView)root.findViewById(R.id.tab_title);
        this.icon = (ImageView)root.findViewById(R.id.tab_icon);
        this.activeTopMargin = this.getSizeInPx(R.dimen.bottom_bar_icon_top_margin_active);
        this.inactiveTopMargin = this.getSizeInPx(R.dimen.bottom_bar_icon_top_margin_inactive);
        this.activeColor = activeColor;
        this.inactiveColor = inactiveColor;
        this.iconDrawable = item.getIconDrawable(this.context);
        this.setupIcon();
        this.setupTitle();
    }

    private void setupIcon() {
        DrawableCompat.setTint((Drawable)this.iconDrawable, (int)this.inactiveColor);
        this.icon.setImageDrawable(this.iconDrawable);
    }

    private int getSizeInPx(@DimenRes int res) {
        return this.context.getResources().getDimensionPixelSize(res);
    }

    void select(boolean animate) {
        this.title.setTextColor(this.activeColor);
        DrawableCompat.setTint((Drawable)this.iconDrawable, (int)this.activeColor);
        this.icon.getDrawable().invalidateSelf();
        if (animate) {
            TabAnimator.animateTranslationY(this.root, this.activeTopMargin);
        } else {
            this.root.setTranslationY((float)this.activeTopMargin);
        }
    }

    void deselect(boolean animate) {
        this.title.setTextColor(this.inactiveColor);
        DrawableCompat.setTint((Drawable)this.iconDrawable, (int)this.inactiveColor);
        this.icon.getDrawable().invalidateSelf();
        if (animate) {
            TabAnimator.animateTranslationY(this.root, this.inactiveTopMargin);
        } else {
            this.root.setTranslationY((float)this.inactiveTopMargin);
        }
    }

    private void setupTitle() {
        if (this.item.getTitle() == 0) {
            this.title.setVisibility(8);
        } else {
            this.title.setText(this.item.getTitle());
        }
        this.title.setTextColor(this.inactiveColor);
    }

    void showBadge(@NonNull Drawable badge) {
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.iconDrawable, badge});
        layerDrawable.setLayerInset(1, this.iconDrawable.getIntrinsicWidth(), 0, 0, this.iconDrawable.getIntrinsicHeight());
        this.icon.setImageDrawable((Drawable)layerDrawable);
    }

    void hideBadge() {
        this.icon.setImageDrawable(this.iconDrawable);
    }
}

