/*
 * Decompiled with CFR 0.152.
 */
package com.monika.bottomnavigationbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.monika.bottomnavigationbar.BottomBarItem;
import com.monika.bottomnavigationbar.R;
import com.monika.bottomnavigationbar.SavedState;
import com.monika.bottomnavigationbar.Tab;
import java.util.ArrayList;
import java.util.List;

public class BottomNavigationBar
extends LinearLayout {
    private final List<Tab> tabs = new ArrayList<Tab>(5);
    private final LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
    @ColorInt
    private int inactiveColorId;
    @ColorInt
    private int activeColorId;
    private int selectedPosition;
    private boolean shouldTriggerListenerOnLayout;
    private OnSelectListener onSelectListener = new OnSelectListener(){

        @Override
        public void onSelect(int position) {
        }
    };
    private OnReselectListener onReselectListener = new OnReselectListener(){

        @Override
        public void onReselect(int position) {
        }
    };

    public BottomNavigationBar(Context context) {
        this(context, null);
    }

    public BottomNavigationBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomNavigationBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setUpElevation(context, attrs);
        this.initFromCustomAttributes(context, attrs);
        this.init();
        this.createStubForEditMode();
    }

    private void createStubForEditMode() {
        if (this.isInEditMode()) {
            for (int i = 0; i < 4; ++i) {
                this.addTab(new BottomBarItem(R.drawable.bottom_bar_default_icon));
            }
        }
    }

    private void initFromCustomAttributes(@NonNull Context context, @NonNull AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.BottomNavigationBar);
        int defaultInactiveColor = this.colorToInt(R.color.bottomBarDefaultTextColor);
        int defaultActiveColor = this.colorToInt(R.color.colorPrimary);
        this.inactiveColorId = array.getColor(R.styleable.BottomNavigationBar_inactiveTabColor, defaultInactiveColor);
        this.activeColorId = array.getColor(R.styleable.BottomNavigationBar_activeTabColor, defaultActiveColor);
        array.recycle();
    }

    @ColorInt
    private int colorToInt(@ColorRes int color2) {
        return ContextCompat.getColor((Context)this.getContext(), (int)color2);
    }

    @NonNull
    private Tab getCurrent() {
        return this.tabs.get(this.selectedPosition);
    }

    public void selectTab(int position, boolean animate) {
        if (position != this.selectedPosition) {
            this.getCurrent().deselect(animate);
            this.selectedPosition = position;
            this.getCurrent().select(animate);
        }
    }

    public int getSelectedPosition() {
        return this.selectedPosition;
    }

    public void selectTabAndTriggerListener(int position, boolean animate) {
        if (position != this.selectedPosition) {
            this.onSelectListener.onSelect(position);
        } else {
            this.onReselectListener.onReselect(position);
        }
        this.selectTab(position, animate);
    }

    public void setTriggerListenerOnLayout(boolean shouldTrigger) {
        this.shouldTriggerListenerOnLayout = shouldTrigger;
    }

    private void setUpElevation(@NonNull Context context, @Nullable AttributeSet attrs) {
        if (!this.atLeastLollipop()) {
            return;
        }
        int[] set = new int[]{0x1010440};
        TypedArray a = context.obtainStyledAttributes(attrs, set);
        int defaultElevation = this.getResources().getDimensionPixelSize(R.dimen.bottom_bar_elevation);
        float elevation = a.getDimensionPixelSize(0, defaultElevation);
        ViewCompat.setElevation((View)this, (float)elevation);
        a.recycle();
    }

    public BottomNavigationBar addTab(@NonNull BottomBarItem item) {
        View tabView = this.inflater.inflate(R.layout.bottom_bar_item, (ViewGroup)this, false);
        this.addView(tabView);
        int position = this.tabs.size();
        Tab tab = this.createTab(item, tabView, position);
        this.tabs.add(tab);
        return this;
    }

    public void setOnSelectListener(@NonNull OnSelectListener listener) {
        this.onSelectListener = listener;
    }

    public void setOnReselectListener(@NonNull OnReselectListener listener) {
        this.onReselectListener = listener;
    }

    public void showBadge(int position, @NonNull Drawable badge) {
        this.tabs.get(position).showBadge(badge);
    }

    public void showBadge(int position, @DrawableRes int badgeRes) {
        this.showBadge(position, ContextCompat.getDrawable((Context)this.getContext(), (int)badgeRes));
    }

    public void hideBadge(int position) {
        this.tabs.get(position).hideBadge();
    }

    @NonNull
    private Tab createTab(@NonNull BottomBarItem item, @NonNull View tabView, final int position) {
        Tab tab = new Tab(item, tabView, this.activeColorId, this.inactiveColorId);
        tabView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (position == BottomNavigationBar.this.selectedPosition) {
                    BottomNavigationBar.this.onReselectListener.onReselect(position);
                    return;
                }
                BottomNavigationBar.this.selectTab(position, true);
                BottomNavigationBar.this.onSelectListener.onSelect(position);
            }
        });
        return tab;
    }

    private void init() {
        int minHeight = this.getResources().getDimensionPixelSize(R.dimen.bottom_bar_min_height);
        this.setMinimumHeight(minHeight);
        this.setOrientation(0);
        if (this.getBackground() == null) {
            this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)17170443));
        }
        if (this.atLeastLollipop()) {
            this.setOutlineProvider(ViewOutlineProvider.BOUNDS);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.tabs.size() == 0) {
            return;
        }
        this.getCurrent().select(false);
        if (this.shouldTriggerListenerOnLayout) {
            this.onSelectListener.onSelect(this.selectedPosition);
        }
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        this.selectedPosition = ss.selectedPosition;
        super.onRestoreInstanceState(ss.getSuperState());
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.selectedPosition = this.selectedPosition;
        return ss;
    }

    private boolean atLeastLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static interface OnReselectListener {
        public void onReselect(int var1);
    }

    public static interface OnSelectListener {
        public void onSelect(int var1);
    }
}

