/*
 * Decompiled with CFR 0.152.
 */
package com.monday_consulting.maven.plugins.fsm.util.resolver;

import com.monday_consulting.maven.plugins.fsm.jaxb.ModuleType;
import com.monday_consulting.maven.plugins.fsm.util.Module;
import com.monday_consulting.maven.plugins.fsm.util.resolver.IResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenGetArtifactsResolver
implements IResolver {
    private final Log log;
    private final List<MavenProject> reactorProjects;
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repoSession;
    private final ProjectBuilder projectBuilder;
    private final MavenProject mavenProject;

    public MavenGetArtifactsResolver(Log log, List<MavenProject> reactorProjects, RepositorySystem repoSystem, RepositorySystemSession repoSession, ProjectBuilder projectBuilder, MavenProject mavenProject) {
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        this.log = log;
        this.reactorProjects = reactorProjects;
        this.projectBuilder = projectBuilder;
        this.mavenProject = mavenProject;
    }

    @Override
    public Module resolve(ModuleType moduleType, List<String> scopes) throws MojoFailureException, MojoExecutionException {
        Module module = new Module(this.log, moduleType, scopes);
        MavenProject mavenProject = this.getMavenProjectViaReactor(module);
        if (mavenProject == null) {
            this.log.info((CharSequence)("Trying to find module " + module.getGroupId() + ":" + module.getArtifactId() + " in repository"));
            mavenProject = this.getMavenProjectViaRepository(module, this.projectBuilder);
        }
        if (mavenProject != null) {
            ArrayList<org.apache.maven.artifact.Artifact> artifacts = new ArrayList<org.apache.maven.artifact.Artifact>(mavenProject.getArtifacts());
            module.setProject(mavenProject);
            module.setResolvedModuleArtifacts(artifacts);
        }
        return module;
    }

    private MavenProject getMavenProjectViaReactor(Module module) {
        MavenProject mProject = null;
        boolean moduleInReactor = false;
        for (MavenProject prj : this.reactorProjects) {
            if (!prj.getArtifactId().equals(module.getArtifactId()) || !prj.getGroupId().equals(module.getGroupId())) continue;
            if (moduleInReactor) {
                this.log.error((CharSequence)("module " + module.getGroupId() + ":" + module.getArtifactId() + " found twice in reactor!"));
                continue;
            }
            this.log.info((CharSequence)("module " + module.getGroupId() + ":" + module.getArtifactId() + " found in reactor!"));
            moduleInReactor = true;
            mProject = prj;
        }
        if (!moduleInReactor) {
            this.log.warn((CharSequence)("module " + module.getGroupId() + ":" + module.getArtifactId() + " not found in reactor!"));
        }
        return mProject;
    }

    private MavenProject getMavenProjectViaRepository(Module module, ProjectBuilder projectBuilder) throws MojoFailureException {
        try {
            MavenProject result;
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
            request.setResolveDependencies(true);
            request.setRemoteRepositories(this.mavenProject.getRemoteArtifactRepositories());
            request.setRepositorySession(this.repoSession);
            LocalRepositoryManager localRepositoryManager = this.repoSession.getLocalRepositoryManager();
            File repoBasedir = localRepositoryManager.getRepository().getBasedir();
            DefaultArtifact moduleArtifact = new DefaultArtifact(module.getGroupId(), module.getArtifactId(), module.getClassifier(), module.getType(), module.getVersion());
            String pathForLocalArtifact = localRepositoryManager.getPathForLocalArtifact((Artifact)moduleArtifact);
            File moduleArtifactFile = new File(repoBasedir, pathForLocalArtifact);
            DefaultArtifact pomArtifact = new DefaultArtifact(module.getGroupId(), module.getArtifactId(), module.getClassifier(), "pom", module.getVersion());
            String localArtifactPath = localRepositoryManager.getPathForLocalArtifact((Artifact)pomArtifact);
            File projectFile = new File(repoBasedir, localArtifactPath);
            try {
                this.log.info((CharSequence)("try to build maven project for " + module.getArtifactId() + " from local repository..."));
                result = projectBuilder.build(projectFile, (ProjectBuildingRequest)request).getProject();
                if (!moduleArtifactFile.exists()) {
                    this.resolveArtifact(module, moduleArtifact);
                }
            }
            catch (ProjectBuildingException e) {
                this.log.info((CharSequence)("failed... try to resolve " + module.getArtifactId() + " from remote repository..."));
                org.apache.maven.artifact.DefaultArtifact mavenArtifact = new org.apache.maven.artifact.DefaultArtifact(module.getGroupId(), module.getArtifactId(), module.getVersion(), null, module.getType(), module.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler());
                result = projectBuilder.build((org.apache.maven.artifact.Artifact)mavenArtifact, (ProjectBuildingRequest)request).getProject();
                this.resolveArtifact(module, moduleArtifact);
            }
            if (result == null) {
                throw new MojoFailureException("No dependency for " + module.getArtifactId() + " found in local or remote repository");
            }
            this.log.info((CharSequence)("Dependency resolved: " + module.getArtifactId()));
            result.getArtifact().setFile(moduleArtifactFile);
            result.setParent(this.mavenProject);
            return result;
        }
        catch (ProjectBuildingException e) {
            throw new MojoFailureException("No dependency for " + module.getArtifactId() + "found in local or remote repository", (Throwable)e);
        }
    }

    private void resolveArtifact(Module module, DefaultArtifact moduleArtifact) throws MojoFailureException {
        this.log.info((CharSequence)("try to resolve artifact for " + module.getArtifactId() + " from remote repository..."));
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)moduleArtifact);
        artifactRequest.setRepositories(this.mavenProject.getRemoteProjectRepositories());
        try {
            this.repoSystem.resolveArtifact(this.repoSession, artifactRequest);
        }
        catch (ArtifactResolutionException e1) {
            throw new MojoFailureException("could not resolve artifact " + module.getArtifactId() + ":" + module.getType() + " for maven project", (Throwable)e1);
        }
    }
}

