package com.moizhassan.modularsdk.core

import com.moizhassan.modularsdk.core.retrofit.APIHandler
import com.moizhassan.modularsdk.core.utils.Constants
import android.content.Context
import android.os.Build
import android.provider.Settings
import com.moizhassan.modularsdk.core.event_models.InteractObject
import com.moizhassan.modularsdk.core.utils.EventType
import io.paperdb.Paper
import android.os.Bundle

import android.content.pm.PackageManager

import android.content.pm.ApplicationInfo
import android.util.Log
import java.lang.Exception


class ModuleSetup {
    private val apiHandler = APIHandler()
    private val Log_Tag: String = "BenshiEventTrack"
    private var sdkToken: String = ""
    private var userId: String? = null

    fun init(context: Context, appSdkToken: String) {
        Paper.init(context)

        try {
            val ai: ApplicationInfo = context.packageManager.getApplicationInfo(
                context.packageName,
                PackageManager.GET_META_DATA
            )
            val bundle = ai.metaData
            val myApiKey = bundle.getString("com.moizhassan.modularsdk.apikey")
            Log.d("BenshiEventTracker", myApiKey!!)
        } catch (e: Exception) {
            Log.d(
                "BenshiEventTracker",
                "Dear developer. Don't forget to configure <meta-data android:name=\"com.moizhassan.modularsdk.apikey\" android:value=\"testValue\"/> in your AndroidManifest.xml file."
            )
        }

        verifyAccessToken(appSdkToken)
        sdkToken = "Bearer $appSdkToken"
        Paper.book(Constants.PaperDbSdkKey).write(Constants.apiTokenKey, sdkToken)
        apiHandler.apiInitHandler(context)
        Constants.deviceId = Settings.Secure.getString(
            context.contentResolver,
            Settings.Secure.ANDROID_ID
        )
        Constants.deviceOS = "android (${Build.VERSION.SDK_INT})"
        Constants.SDKVersion = context.packageManager
            .getPackageInfo(context.packageName, 0).versionName

//            Paper.book(Constants.PaperDbSdkKey).write(Constants.userIdKey, "")
        userId = Paper.book(Constants.PaperDbSdkKey).read(Constants.userIdKey, "")

    }
    //      Main Track event function to validate and parse any event

    fun track(
        context: Context, eventType: Any,
        eventName: String, trackProperties: Any?, updateImmediately: Boolean = true
    ) {
        verifyAccessToken(sdkToken)
        when (eventType) {
            EventType.interact -> {
                if (trackProperties is InteractObject) {
                    apiHandler.ingestTrackAPI(
                        context, userId,
                        eventType, eventName, trackProperties, sdkToken, updateImmediately
                    )
                } else {
                    throw IllegalArgumentException("Invalid properties object provided")
                }
            }
            else -> {
                apiHandler.ingestTrackAPI(
                    context, userId,
                    eventType, eventName, trackProperties, sdkToken, updateImmediately
                )
            }
        }
    }

    private fun verifyAccessToken(appToken: String) {
        if (appToken.isNullOrEmpty()) {
            throw IllegalAccessException("Please call BenshiLog.init with your SDK Access Token")
        } else {
            apiHandler.verifySDKTokenAPI(appToken)
        }
    }

}