package com.moizhassan.modularsdk.core.builders

import com.moizhassan.modularsdk.core.ModuleLog
import com.moizhassan.modularsdk.core.utils.EventType
import com.moizhassan.modularsdk.core.event_models.InteractObject
import com.moizhassan.modularsdk.core.utils.InteractType
import android.content.Context

class LogInteractEvent {

    data class Builder(
        private var context: Context? = null,
        private var eventName: String? = null,
        private var actionType: InteractType? = null,
        private var elementName: String? = null,
        private var meta: Any? = null,
        private var updateImmediately: Boolean = true
    ) {

        fun init(context: Context) = apply { this.context = context }
        fun setEventName(eventName: String) = apply { this.eventName = eventName }
        fun setActionType(actionType: InteractType) = apply { this.actionType = actionType }
        fun setElementName(elementName: String) = apply { this.elementName = elementName }
        fun setMeta(meta: Any) = apply { this.meta = meta }
        fun updateImmediately(updateImmediately: Boolean) =
            apply { this.updateImmediately = updateImmediately }

        fun build() = apply {
            when {
                context == null -> {
                    throw NullPointerException("init is required to provide context.")
                }
                eventName.isNullOrEmpty() -> {
                    throw NullPointerException("eventName is required.")
                }
                actionType == null -> {
                    throw NullPointerException("actionType is required.")
                }
                elementName.isNullOrEmpty() -> {
                    throw NullPointerException("elementName is required.")
                }
                else -> {
                    val interactObject = InteractObject(actionType!!, elementName!!, meta)
                    ModuleLog.track(
                        context!!, EventType.interact, eventName!!,
                        interactObject, updateImmediately
                    )
                }
            }
        }
    }
}