/*
 * Decompiled with CFR 0.152.
 */
package com.moizhassan.modularsdk.core.retrofit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.os.Looper;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.moizhassan.modularsdk.core.retrofit.APIClient;
import com.moizhassan.modularsdk.core.retrofit.APIHandler;
import com.moizhassan.modularsdk.core.retrofit.APIInterface;
import com.moizhassan.modularsdk.core.retrofit.MainTrackEventBody;
import com.moizhassan.modularsdk.core.utils.Constants;
import io.paperdb.Paper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010*\u0001\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J+\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0000\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003JB\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0013J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J\u0018\u0010#\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0017H\u0002J \u0010%\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0017H\u0002J\u000e\u0010&\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006'"}, d2={"Lcom/moizhassan/modularsdk/core/retrofit/APIHandler;", "", "()V", "Log_Tag", "", "mFusedLocationClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "mLocationCallback", "com/moizhassan/modularsdk/core/retrofit/APIHandler$mLocationCallback$1", "Lcom/moizhassan/modularsdk/core/retrofit/APIHandler$mLocationCallback$1;", "userLocationLatitude", "", "Ljava/lang/Double;", "userLocationLongitude", "apiInitHandler", "", "context", "Landroid/content/Context;", "bulkEventTrack", "", "sdkToken", "eventArray", "Ljava/util/ArrayList;", "Lcom/moizhassan/modularsdk/core/retrofit/MainTrackEventBody;", "bulkEventTrack$core_release", "checkPermissions", "getLastLocation", "ingestTrackAPI", "user_id", "eventType", "eventName", "trackProperties", "updateImmediately", "isLocationEnabled", "requestNewLocationData", "storeEventTrack", "eventObject", "updateEventTrack", "verifySDKTokenAPI", "core_release"})
public final class APIHandler {
    private FusedLocationProviderClient mFusedLocationClient;
    @Nullable
    private Double userLocationLatitude;
    @Nullable
    private Double userLocationLongitude;
    @NotNull
    private final String Log_Tag;
    @NotNull
    private final mLocationCallback.1 mLocationCallback = new LocationCallback(this){
        final /* synthetic */ APIHandler this$0;
        {
            this.this$0 = $receiver;
        }

        public void onLocationResult(@NotNull LocationResult locationResult) {
            Intrinsics.checkNotNullParameter((Object)locationResult, (String)"locationResult");
            try {
                Location location = locationResult.getLastLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"locationResult.lastLocation");
                Location mLastLocation = location;
                APIHandler.access$setUserLocationLatitude$p(this.this$0, mLastLocation.getLatitude());
                APIHandler.access$setUserLocationLongitude$p(this.this$0, mLastLocation.getLongitude());
            }
            catch (Exception ex) {
                String string = APIHandler.access$getLog_Tag$p(this.this$0);
                String string2 = ex.getLocalizedMessage();
                Intrinsics.checkNotNull((Object)string2);
                Log.d((String)string, (String)string2);
            }
        }
    };

    public APIHandler() {
        this.Log_Tag = "BenshiEventTrack";
    }

    public final void apiInitHandler(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FusedLocationProviderClient fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)fusedLocationProviderClient, (String)"getFusedLocationProviderClient(context)");
        this.mFusedLocationClient = fusedLocationProviderClient;
        this.getLastLocation(context);
    }

    public final void ingestTrackAPI(@NotNull Context context, @Nullable String user_id, @NotNull Object eventType, @NotNull String eventName, @Nullable Object trackProperties, @NotNull String sdkToken, boolean updateImmediately) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)sdkToken, (String)"sdkToken");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZZZZZ", Locale.ENGLISH);
        String timeZone = sdf.format(Calendar.getInstance().getTime());
        String uID = "";
        CharSequence charSequence = user_id;
        uID = charSequence == null || charSequence.length() == 0 ? Constants.Companion.getDeviceId() : user_id;
        String string = Constants.Companion.getDeviceId();
        String string2 = Constants.Companion.getDeviceOS();
        String string3 = Constants.Companion.getSDKVersion();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"timeZone");
        MainTrackEventBody eventObject = new MainTrackEventBody(uID, string, string2, string3, true, timeZone, 10, 10, eventType, eventName, trackProperties);
        if (updateImmediately) {
            this.updateEventTrack(context, sdkToken, eventObject);
        } else {
            this.storeEventTrack(context, eventObject);
        }
    }

    private final void storeEventTrack(Context context, MainTrackEventBody eventObject) {
        Paper.init((Context)context);
        Object object = Paper.book((String)"PaperDbSdkKey").read("localSatsKey", new ArrayList());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"book(Constants.PaperDbSd\u2026alSatsKey, arrayListOf())");
        ArrayList prevEvent = (ArrayList)object;
        prevEvent.add(eventObject);
        Paper.book((String)"PaperDbSdkKey").write("localSatsKey", (Object)prevEvent);
    }

    private final void updateEventTrack(Context context, String sdkToken, MainTrackEventBody eventObject) {
        Object object = APIClient.Companion.getClient().create(APIInterface.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"APIClient.getClient().cr\u2026APIInterface::class.java)");
        APIInterface apiInterface = (APIInterface)object;
        Call<Void> call = apiInterface.trackEvent(sdkToken, eventObject);
        call.enqueue((Callback)new Callback<Void>(this, context, eventObject){
            final /* synthetic */ APIHandler this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ MainTrackEventBody $eventObject;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$eventObject = $eventObject;
            }

            public void onResponse(@NotNull Call<Void> call, @NotNull Response<Void> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    Log.d((String)APIHandler.access$getLog_Tag$p(this.this$0), (String)"Event Recorded.");
                } else {
                    Log.d((String)APIHandler.access$getLog_Tag$p(this.this$0), (String)"Event Tracking Failed.");
                }
            }

            public void onFailure(@NotNull Call<Void> call, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                call.cancel();
                APIHandler.access$storeEventTrack(this.this$0, this.$context, this.$eventObject);
            }
        });
        Log.d((String)this.Log_Tag, (String)new Gson().toJson((Object)eventObject));
    }

    public final boolean bulkEventTrack$core_release(@NotNull Context context, @NotNull String sdkToken, @NotNull ArrayList<MainTrackEventBody> eventArray) {
        Object object;
        Object valuedb;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkToken, (String)"sdkToken");
        Intrinsics.checkNotNullParameter(eventArray, (String)"eventArray");
        Ref.BooleanRef isWorkCompleted = new Ref.BooleanRef();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setLenient();
        Gson gson = gsonBuilder.create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"gsonBuilder.create()");
        Gson gson2 = gson;
        Object prevEvent = "";
        for (MainTrackEventBody mainTrackEventBody : eventArray) {
            Object object2;
            valuedb = gson2.toJson((Object)mainTrackEventBody);
            object = (CharSequence)prevEvent;
            if (object == null || object.length() == 0) {
                object = valuedb;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                valuedb\n            }");
                object2 = object;
            } else {
                object2 = (String)prevEvent + '\n' + valuedb;
            }
            prevEvent = object2;
        }
        MediaType mediaType = MediaType.parse((String)"application/x-ndjson");
        String string = prevEvent;
        object = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).getBytes(charset)");
        RequestBody data = RequestBody.create((MediaType)mediaType, (byte[])object);
        valuedb = APIClient.Companion.getClient().create(APIInterface.class);
        Intrinsics.checkNotNullExpressionValue((Object)valuedb, (String)"APIClient.getClient().cr\u2026APIInterface::class.java)");
        APIInterface aPIInterface = (APIInterface)valuedb;
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
        Call<Void> call = aPIInterface.trackBulkEvent(sdkToken, data);
        call.enqueue((Callback)new Callback<Void>(this, isWorkCompleted, context){
            final /* synthetic */ APIHandler this$0;
            final /* synthetic */ Ref.BooleanRef $isWorkCompleted;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$isWorkCompleted = $isWorkCompleted;
                this.$context = $context;
            }

            public void onResponse(@NotNull Call<Void> call, @NotNull Response<Void> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    Log.d((String)APIHandler.access$getLog_Tag$p(this.this$0), (String)"Event Recorded.");
                    this.$isWorkCompleted.element = true;
                } else {
                    boolean isDebuggable;
                    Log.d((String)APIHandler.access$getLog_Tag$p(this.this$0), (String)"Event Tracking Failed.");
                    this.$isWorkCompleted.element = false;
                    boolean bl = isDebuggable = (this.$context.getApplicationInfo().flags & 2) != 0;
                    if (isDebuggable) {
                        if (response.code() == 401) {
                            throw new RuntimeException("Invalid Benshi SDK Token");
                        }
                        throw new RuntimeException(response.code() + " : " + response.raw().message());
                    }
                }
            }

            public void onFailure(@NotNull Call<Void> call, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                Log.d((String)"BenshiEventTrack", (String)String.valueOf(throwable.getMessage()));
                call.cancel();
                this.$isWorkCompleted.element = false;
            }
        });
        return isWorkCompleted.element;
    }

    public final void verifySDKTokenAPI(@NotNull String sdkToken) {
        Intrinsics.checkNotNullParameter((Object)sdkToken, (String)"sdkToken");
        Log.d((String)this.Log_Tag, (String)sdkToken);
    }

    private final boolean isLocationEnabled(Context context) {
        Object object = context.getSystemService("location");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.location.LocationManager");
        }
        LocationManager locationManager = (LocationManager)object;
        return locationManager.isProviderEnabled("gps") || locationManager.isProviderEnabled("network");
    }

    private final boolean checkPermissions(Context context) {
        return ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    @SuppressLint(value={"MissingPermission"})
    private final void getLastLocation(Context context) {
        if (this.checkPermissions(context)) {
            if (this.isLocationEnabled(context)) {
                FusedLocationProviderClient fusedLocationProviderClient = this.mFusedLocationClient;
                if (fusedLocationProviderClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mFusedLocationClient");
                    fusedLocationProviderClient = null;
                }
                fusedLocationProviderClient.getLastLocation().addOnSuccessListener(arg_0 -> APIHandler.getLastLocation$lambda-0(this, context, arg_0));
            } else {
                Log.d((String)this.Log_Tag, (String)"Location is turned off by user");
            }
        } else {
            Log.d((String)this.Log_Tag, (String)"Location Permission required to track user coordinates");
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private final void requestNewLocationData(Context context) {
        LocationRequest mLocationRequest = new LocationRequest();
        mLocationRequest.setPriority(100);
        mLocationRequest.setInterval(0L);
        mLocationRequest.setFastestInterval(0L);
        mLocationRequest.setNumUpdates(1);
        FusedLocationProviderClient fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)fusedLocationProviderClient, (String)"getFusedLocationProviderClient(context)");
        this.mFusedLocationClient = fusedLocationProviderClient;
        FusedLocationProviderClient fusedLocationProviderClient2 = this.mFusedLocationClient;
        if (fusedLocationProviderClient2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFusedLocationClient");
            fusedLocationProviderClient2 = null;
        }
        fusedLocationProviderClient2.requestLocationUpdates(mLocationRequest, (LocationCallback)this.mLocationCallback, Looper.myLooper());
    }

    private static final void getLastLocation$lambda-0(APIHandler this$0, Context $context, Location userLocation) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Location location = userLocation;
        if (location == null) {
            this$0.requestNewLocationData($context);
        } else {
            this$0.userLocationLatitude = location.getLatitude();
            this$0.userLocationLongitude = location.getLongitude();
        }
    }

    public static final /* synthetic */ String access$getLog_Tag$p(APIHandler $this) {
        return $this.Log_Tag;
    }

    public static final /* synthetic */ void access$storeEventTrack(APIHandler $this, Context context, MainTrackEventBody eventObject) {
        $this.storeEventTrack(context, eventObject);
    }

    public static final /* synthetic */ void access$setUserLocationLatitude$p(APIHandler $this, Double d) {
        $this.userLocationLatitude = d;
    }

    public static final /* synthetic */ void access$setUserLocationLongitude$p(APIHandler $this, Double d) {
        $this.userLocationLongitude = d;
    }
}

