package com.moizhassan.modularsdk.core.retrofit

import com.moizhassan.modularsdk.core.utils.Constants
import android.Manifest
import android.annotation.SuppressLint
import android.content.Context
import android.content.pm.ApplicationInfo
import android.content.pm.PackageManager
import android.location.Location
import android.location.LocationManager
import android.os.Looper
import android.util.Log
import androidx.core.app.ActivityCompat
import com.google.android.gms.location.*
import com.google.gson.Gson
import com.google.gson.GsonBuilder
import io.paperdb.Paper
import okhttp3.MediaType
import okhttp3.RequestBody
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.lang.RuntimeException
import java.text.SimpleDateFormat
import java.util.*

class APIHandler {

    private lateinit var mFusedLocationClient: FusedLocationProviderClient

    private var userLocationLatitude: Double? = null
    private var userLocationLongitude: Double? = null
    private val Log_Tag: String = "BenshiEventTrack"

    fun apiInitHandler(context: Context) {
        mFusedLocationClient = LocationServices.getFusedLocationProviderClient(context)
        getLastLocation(context)
    }

    fun ingestTrackAPI(
        context: Context,
        user_id: String?,
        eventType: Any,
        eventName: String,
        trackProperties: Any?,
        sdkToken: String,
        updateImmediately: Boolean
    ) {


//        val ipv4Address = NetworkUtil.getIPAddress(true)
//        val ipv6Address = NetworkUtil.getIPAddress(true)
        val sdf = SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZZZZZ", Locale.ENGLISH)
        val timeZone = sdf.format(Calendar.getInstance().time)

        var uID = ""
        if (user_id.isNullOrEmpty()) {
            uID = Constants.deviceId
        } else {
            uID = user_id
        }

        val eventObject = MainTrackEventBody(
            uID, Constants.deviceId, Constants.deviceOS,
            Constants.SDKVersion, //ipv4Address,
            true, timeZone,
//            userLocationLatitude, userLocationLongitude,
            10, 10,
            eventType, eventName, trackProperties
        )


        if (updateImmediately) {
            updateEventTrack(context, sdkToken, eventObject)
        } else {
            storeEventTrack(context, eventObject)
        }
    }


    private fun storeEventTrack(
        context: Context,
        eventObject: MainTrackEventBody
    ) {
        Paper.init(context)
        val prevEvent: ArrayList<MainTrackEventBody> =
            Paper.book(Constants.PaperDbSdkKey).read(Constants.localSatsKey, arrayListOf())
        prevEvent.add(eventObject)

//        prevEvent = if(prevEvent.isNullOrEmpty()){ valueOb }else{
//            "$prevEvent\n$valueOb"
//        }
        Paper.book(Constants.PaperDbSdkKey).write(Constants.localSatsKey, prevEvent)
    }

    private fun updateEventTrack(
        context: Context, sdkToken: String,
        eventObject: MainTrackEventBody
    ) {
        val apiInterface: APIInterface = APIClient.getClient().create(APIInterface::class.java)
        val call: Call<Void> = apiInterface.trackEvent(sdkToken, eventObject)
        call.enqueue(object : Callback<Void> {
            override fun onResponse(
                call: Call<Void>,
                response: Response<Void>
            ) {
                if (response.isSuccessful) {
                    Log.d(Log_Tag, "Event Recorded.")

                } else {
                    Log.d(Log_Tag, "Event Tracking Failed.")
//                    val isDebuggable = 0 != context.applicationInfo.flags and ApplicationInfo.FLAG_DEBUGGABLE
//                    if(isDebuggable){
//                        if(response.code() == 401){
//                            throw RuntimeException("Invalid Benshi SDK Token")
//                        }else{
//                            throw RuntimeException(response.code().toString() + " : " +
//                                    response.raw().message())
//                        }
//                    }
                }
            }

            override fun onFailure(call: Call<Void>, throwable: Throwable) {
                call.cancel()
                storeEventTrack(context, eventObject)
            }
        })


        Log.d(Log_Tag, Gson().toJson(eventObject))
    }

    internal fun bulkEventTrack(
        context: Context, sdkToken: String,
        eventArray: ArrayList<MainTrackEventBody>
    ): Boolean {

        var isWorkCompleted = false

        val gsonBuilder = GsonBuilder()
        gsonBuilder.setLenient()
        val gson: Gson = gsonBuilder.create()

        var prevEvent = ""
        for (item in eventArray) {
            val valuedb = gson.toJson(item)
            prevEvent = if (prevEvent.isNullOrEmpty()) {
                valuedb
            } else {
                "$prevEvent\n$valuedb"
            }
        }

        val data = RequestBody.create(
            MediaType.parse("application/x-ndjson"), prevEvent.toByteArray()
        )
        val apiInterface: APIInterface = APIClient.getClient().create(APIInterface::class.java)
        val call: Call<Void> = apiInterface.trackBulkEvent(sdkToken, data)
        call.enqueue(object : Callback<Void> {
            override fun onResponse(
                call: Call<Void>,
                response: Response<Void>
            ) {
                if (response.isSuccessful) {
                    Log.d(Log_Tag, "Event Recorded.")
                    isWorkCompleted = true
                } else {
                    Log.d(Log_Tag, "Event Tracking Failed.")
                    isWorkCompleted = false

                    val isDebuggable = 0 != context.applicationInfo.flags and ApplicationInfo.FLAG_DEBUGGABLE
                    if(isDebuggable){
                        if(response.code() == 401){
                            throw RuntimeException("Invalid Benshi SDK Token")
                        }else{
                            throw RuntimeException(response.code().toString() + " : " +
                                    response.raw().message())
                        }
                    }

                }
            }

            override fun onFailure(call: Call<Void>, throwable: Throwable) {
                Log.d("BenshiEventTrack", throwable.message.toString())
                call.cancel()
                isWorkCompleted = false
//                throw throwable
            }
        })

        return isWorkCompleted
    }


    fun verifySDKTokenAPI(sdkToken: String) {
        /*
                val apiInterface: APIInterface = APIClient.getClient().create(APIInterface::class.java)
                val call: Call<String> = apiInterface.verifySDKToken(sdkToken)
                call.enqueue(object : Callback<String> {
                    override fun onResponse(
                        call: Call<String>,
                        response: Response<String>
                    ) {
                        if(response.isSuccessful){
                            Log.d(Log_Tag, "Event Recorded.")

                        }else{
                            Log.d(Log_Tag, "Event Tracking Failed.")
                        }
                    }

                    override fun onFailure(call: Call<String>, throwable: Throwable) {
                        call.cancel()
                        throw throwable
                    }
                })

         */

        Log.d(Log_Tag, sdkToken)


    }


//    Location fetching section

    private fun isLocationEnabled(context: Context): Boolean {
        var locationManager: LocationManager =
            context.getSystemService(Context.LOCATION_SERVICE) as LocationManager
        return locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER) || locationManager.isProviderEnabled(
            LocationManager.NETWORK_PROVIDER
        )
    }

    private fun checkPermissions(context: Context): Boolean {
        if (ActivityCompat.checkSelfPermission(
                context,
                Manifest.permission.ACCESS_COARSE_LOCATION
            ) == PackageManager.PERMISSION_GRANTED &&
            ActivityCompat.checkSelfPermission(
                context,
                Manifest.permission.ACCESS_FINE_LOCATION
            ) == PackageManager.PERMISSION_GRANTED
        ) {
            return true
        }
        return false
    }


    @SuppressLint("MissingPermission")
    private fun getLastLocation(context: Context) {
        if (checkPermissions(context)) {
            if (isLocationEnabled(context)) {

                mFusedLocationClient.lastLocation.addOnSuccessListener { userLocation ->
                    val location: Location? = userLocation
                    if (location == null) {
                        requestNewLocationData(context)
                    } else {
//                        val geocoder = Geocoder(context, Locale.getDefault())
//                        val addresses: List<Address> = geocoder.getFromLocation(location.latitude, location.longitude, 1)
                        userLocationLatitude = location.latitude
                        userLocationLongitude = location.longitude
                    }
                }
            } else {
                Log.d(Log_Tag, "Location is turned off by user")
            }
        } else {
            Log.d(Log_Tag, "Location Permission required to track user coordinates")
        }
    }

    @SuppressLint("MissingPermission")
    private fun requestNewLocationData(context: Context) {
        val mLocationRequest = LocationRequest()
        mLocationRequest.priority = LocationRequest.PRIORITY_HIGH_ACCURACY
        mLocationRequest.interval = 0
        mLocationRequest.fastestInterval = 0
        mLocationRequest.numUpdates = 1

        mFusedLocationClient = LocationServices.getFusedLocationProviderClient(context)
        mFusedLocationClient.requestLocationUpdates(
            mLocationRequest, mLocationCallback,
            Looper.myLooper()
        )
    }

    private val mLocationCallback = object : LocationCallback() {
        override fun onLocationResult(locationResult: LocationResult) {
            try {
                val mLastLocation: Location = locationResult.lastLocation
                userLocationLatitude = mLastLocation.latitude
                userLocationLongitude = mLastLocation.longitude
//                val geocoder = Geocoder(context!!, Locale.getDefault())
//                val addresses: List<Address> = geocoder.getFromLocation(mLastLocation.latitude, mLastLocation.longitude, 1)
            } catch (ex: Exception) {
                Log.d(Log_Tag, ex.localizedMessage!!)
            }
        }
    }


}