package com.moizhassan.modularsdk.core.retrofit


import okhttp3.RequestBody
import retrofit2.Call
import retrofit2.http.*

interface APIInterface {

    @Headers("Content-Type: application/x-ndjson")
    @POST("data/ingest")
    fun trackEvent(
        @Header("Authorization") authHeader: String,
        @Body trackEventRequestBodyObject: MainTrackEventBody
    ): Call<Void>

    @Headers("Content-Type: application/x-ndjson")
    @POST("data/ingest")
    fun trackBulkEvent(
        @Header("Authorization") authHeader: String,
        @Body trackEventRequestBodyObject: RequestBody
    ): Call<Void>

}