/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.util;

import com.moilioncircle.redis.replicator.util.Strings;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ByteBuilder {
    private int total = 0;
    private final ByteBuffer buffer;
    private final List<ByteBuffer> list = new ArrayList<ByteBuffer>();

    private ByteBuilder(int cap) {
        this.buffer = ByteBuffer.allocate(cap);
    }

    public static ByteBuilder allocate(int cap) {
        return new ByteBuilder(cap);
    }

    public void put(byte b) {
        ++this.total;
        if (this.buffer.hasRemaining()) {
            this.buffer.put(b);
        } else {
            byte[] temp = new byte[this.buffer.capacity()];
            System.arraycopy(this.buffer.array(), 0, temp, 0, this.buffer.capacity());
            this.list.add(ByteBuffer.wrap(temp));
            this.buffer.clear();
            this.buffer.put(b);
        }
    }

    public void put(byte[] bytes) {
        this.put(bytes, 0, bytes.length);
    }

    public void put(byte[] bytes, int offset, int length) {
        for (int i = offset; i < length; ++i) {
            this.put(bytes[i]);
        }
    }

    public void put(ByteBuffer buf) {
        this.put(buf.array(), buf.position(), buf.limit());
    }

    public int length() {
        return this.total;
    }

    public byte[] array() {
        int len = this.total;
        int offset = 0;
        byte[] ary = new byte[len];
        if (len < this.buffer.capacity()) {
            System.arraycopy(this.buffer.array(), 0, ary, offset, len);
            return ary;
        }
        for (ByteBuffer buf : this.list) {
            int length = buf.remaining();
            System.arraycopy(buf.array(), 0, ary, offset, length);
            offset += length;
            len -= length;
        }
        if (len > 0) {
            System.arraycopy(this.buffer.array(), 0, ary, offset, len);
        }
        return ary;
    }

    public List<ByteBuffer> buffers() {
        ArrayList<ByteBuffer> r = new ArrayList<ByteBuffer>(this.list.size() + 1);
        for (ByteBuffer buf : this.list) {
            r.add(buf.duplicate());
        }
        r.add((ByteBuffer)this.buffer.duplicate().flip());
        return r;
    }

    public void clear() {
        this.total = 0;
        this.list.clear();
        this.buffer.clear();
    }

    public String toString() {
        return Strings.toString(this.array());
    }
}

