/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ByteArrayMap<V>
implements Map<byte[], V>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<Key, V> map;

    public ByteArrayMap(Map<? extends byte[], ? extends V> m) {
        this(true, m);
    }

    public ByteArrayMap(boolean ordered, Map<? extends byte[], ? extends V> m) {
        this(ordered, m == null ? 0 : m.size(), 0.75f);
        this.putAll((Map<byte[], ? extends V>)m);
    }

    public ByteArrayMap() {
        this(true);
    }

    public ByteArrayMap(boolean ordered) {
        this(ordered, 16);
    }

    public ByteArrayMap(boolean ordered, int initialCapacity) {
        this(ordered, initialCapacity, 0.75f);
    }

    public ByteArrayMap(boolean ordered, int initialCapacity, float loadFactor) {
        this.map = ordered ? new LinkedHashMap<Key, V>(initialCapacity, loadFactor) : new HashMap<Key, V>(initialCapacity, loadFactor);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key != null && !(key instanceof byte[])) {
            return false;
        }
        return this.map.containsKey(new Key((byte[])key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (key != null && !(key instanceof byte[])) {
            return null;
        }
        return this.map.get(new Key((byte[])key));
    }

    @Override
    public V put(byte[] key, V value) {
        return this.map.put(new Key(key), value);
    }

    @Override
    public void putAll(Map<? extends byte[], ? extends V> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<byte[], V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (key != null && !(key instanceof byte[])) {
            return null;
        }
        return this.map.remove(new Key((byte[])key));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<byte[]> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<byte[], V>> entrySet() {
        return new EntrySet();
    }

    public static final class Node<V>
    implements Map.Entry<byte[], V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private V value;
        private final byte[] bytes;

        private Node(byte[] bytes, V value) {
            this.bytes = bytes;
            this.value = value;
        }

        @Override
        public byte[] getKey() {
            return this.bytes;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            if (this.value != null ? !this.value.equals(node.value) : node.value != null) {
                return false;
            }
            return Arrays.equals(this.bytes, node.bytes);
        }

        @Override
        public int hashCode() {
            int result = this.value != null ? this.value.hashCode() : 0;
            result = 31 * result + Arrays.hashCode(this.bytes);
            return result;
        }
    }

    private final class EntryIterator
    implements Iterator<Map.Entry<byte[], V>> {
        private final Iterator<Map.Entry<Key, V>> iterator;

        private EntryIterator() {
            this.iterator = ByteArrayMap.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<byte[], V> next() {
            Map.Entry v = this.iterator.next();
            return new Node(v.getKey().bytes, v.getValue());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class KeyIterator
    implements Iterator<byte[]> {
        private final Iterator<Key> iterator;

        private KeyIterator() {
            this.iterator = ByteArrayMap.this.map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public byte[] next() {
            return this.iterator.next().bytes;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class KeySet
    extends AbstractSet<byte[]> {
        private KeySet() {
        }

        @Override
        public final int size() {
            return ByteArrayMap.this.size();
        }

        @Override
        public final void clear() {
            ByteArrayMap.this.clear();
        }

        @Override
        public final Iterator<byte[]> iterator() {
            return new KeyIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return ByteArrayMap.this.containsKey(o);
        }

        @Override
        public final boolean remove(Object key) {
            return ByteArrayMap.this.remove(key) != null;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<byte[], V>> {
        private EntrySet() {
        }

        @Override
        public final int size() {
            return ByteArrayMap.this.size();
        }

        @Override
        public final void clear() {
            ByteArrayMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<byte[], V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object obj = e.getKey();
            if (obj != null && !(obj instanceof byte[])) {
                return false;
            }
            byte[] key = (byte[])obj;
            if (!ByteArrayMap.this.containsKey(key)) {
                return false;
            }
            Object v = ByteArrayMap.this.get(key);
            return v != null ? v.equals(e.getValue()) : e.getValue() == v;
        }

        @Override
        public final boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object obj = e.getKey();
            Object value = e.getValue();
            if (obj != null && !(obj instanceof byte[])) {
                return false;
            }
            byte[] key = (byte[])obj;
            if (!ByteArrayMap.this.containsKey(key)) {
                return false;
            }
            Object v = ByteArrayMap.this.get(key);
            if (value == null && value == v || value != null && value.equals(v)) {
                return ByteArrayMap.this.remove(key) != null;
            }
            return false;
        }
    }

    private static final class Key
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] bytes;

        private Key(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Arrays.equals(this.bytes, key.bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }
    }
}

