/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.util;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;

public class Arrays {
    public static String deepToString(Object[] a) {
        if (a == null) {
            return "null";
        }
        int bufLen = 20 * a.length;
        if (a.length != 0 && bufLen <= 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder buf = new StringBuilder(bufLen);
        Arrays.deepToString(a, buf, new HashSet<Object[]>());
        return buf.toString();
    }

    private static void deepToString(Object[] a, StringBuilder buf, Set<Object[]> dejaVu) {
        if (a == null) {
            buf.append("null");
            return;
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            buf.append("[]");
            return;
        }
        dejaVu.add(a);
        buf.append('[');
        int i = 0;
        while (true) {
            Object element;
            if ((element = a[i]) == null) {
                buf.append("null");
            } else {
                Class<?> eClass = element.getClass();
                if (eClass.isArray()) {
                    if (eClass == byte[].class) {
                        buf.append(Arrays.toString((byte[])element));
                    } else if (eClass == char[].class) {
                        buf.append(Arrays.toString((char[])element));
                    } else if (eClass == short[].class) {
                        buf.append(java.util.Arrays.toString((short[])element));
                    } else if (eClass == int[].class) {
                        buf.append(java.util.Arrays.toString((int[])element));
                    } else if (eClass == long[].class) {
                        buf.append(java.util.Arrays.toString((long[])element));
                    } else if (eClass == float[].class) {
                        buf.append(java.util.Arrays.toString((float[])element));
                    } else if (eClass == double[].class) {
                        buf.append(java.util.Arrays.toString((double[])element));
                    } else if (eClass == boolean[].class) {
                        buf.append(java.util.Arrays.toString((boolean[])element));
                    } else if (dejaVu.contains(element)) {
                        buf.append("[...]");
                    } else {
                        Arrays.deepToString((Object[])element, buf, dejaVu);
                    }
                } else {
                    buf.append(element.toString());
                }
            }
            if (i == iMax) break;
            buf.append(", ");
            ++i;
        }
        buf.append(']');
        dejaVu.remove(a);
    }

    public static String toString(char[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        return new String(a);
    }

    private static String toString(byte[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        return new String(a, StandardCharsets.UTF_8);
    }
}

