/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.impl.AggregateType;
import com.moilioncircle.redis.replicator.cmd.impl.ZInterStoreCommand;
import com.moilioncircle.redis.replicator.cmd.parser.CommandParsers;
import java.math.BigDecimal;

public class ZInterStoreParser
implements CommandParser<ZInterStoreCommand> {
    @Override
    public ZInterStoreCommand parse(Object[] command) {
        int idx = 1;
        AggregateType aggregateType = null;
        String destination = CommandParsers.objToString(command[idx]);
        byte[] rawDestination = CommandParsers.objToBytes(command[idx]);
        int n = ++idx;
        ++idx;
        int numkeys = new BigDecimal(CommandParsers.objToString(command[n])).intValueExact();
        String[] keys = new String[numkeys];
        byte[][] rawKeys = new byte[numkeys][];
        for (int i = 0; i < numkeys; ++i) {
            keys[i] = CommandParsers.objToString(command[idx]);
            rawKeys[i] = CommandParsers.objToBytes(command[idx]);
            ++idx;
        }
        double[] weights = null;
        while (idx < command.length) {
            String param = CommandParsers.objToString(command[idx]);
            if ("WEIGHTS".equalsIgnoreCase(param)) {
                ++idx;
                weights = new double[numkeys];
                for (int i = 0; i < numkeys; ++i) {
                    weights[i] = Double.parseDouble(CommandParsers.objToString(command[idx++]));
                }
            }
            if (!"AGGREGATE".equalsIgnoreCase(param)) continue;
            int n2 = ++idx;
            ++idx;
            String next = CommandParsers.objToString(command[n2]);
            if ("SUM".equalsIgnoreCase(next)) {
                aggregateType = AggregateType.SUM;
                continue;
            }
            if ("MIN".equalsIgnoreCase(next)) {
                aggregateType = AggregateType.MIN;
                continue;
            }
            if (!"MAX".equalsIgnoreCase(next)) continue;
            aggregateType = AggregateType.MAX;
        }
        return new ZInterStoreCommand(destination, numkeys, keys, weights, aggregateType, rawDestination, rawKeys);
    }
}

