/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.richnotification;

import android.content.Context;
import com.moengage.core.Logger;
import com.moengage.pushbase.model.NotificationMetaData;
import com.moengage.pushbase.model.NotificationPayload;
import com.moengage.pushbase.richnotification.RichNotificationHandler;

public class RichNotificationManager {
    private static final String TAG = "PushBase_4.2.03_RichNotificationManager";
    private RichNotificationHandler handler;
    private static RichNotificationManager instance;

    private RichNotificationManager() {
        this.loadHandler();
    }

    private void loadHandler() {
        try {
            Class<?> aClass = Class.forName("com.moengage.richnotification.RichNotificationHandlerImpl");
            this.handler = (RichNotificationHandler)aClass.newInstance();
        }
        catch (Exception e) {
            Logger.v((String)"PushBase_4.2.03_RichNotificationManager loadHandler() : Rich notification module not found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RichNotificationManager getInstance() {
        if (instance != null) return instance;
        Class<RichNotificationManager> clazz = RichNotificationManager.class;
        synchronized (RichNotificationManager.class) {
            if (instance != null) return instance;
            instance = new RichNotificationManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isTemplateSupported(NotificationPayload notificationPayload) {
        if (this.handler == null) {
            return false;
        }
        return this.handler.isTemplateSupported(notificationPayload);
    }

    public boolean hasRichNotificationModule() {
        return this.handler != null;
    }

    public boolean buildTemplate(Context context, NotificationMetaData metaData) {
        if (this.handler == null) {
            return false;
        }
        return this.handler.buildTemplate(context, metaData);
    }
}

