/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.repository;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.pushbase.model.NotificationPayload;
import com.moengage.pushbase.push.MoEngageNotificationUtils;

public class PushDAO {
    private static final String TAG = "PushDAO";
    private static PushDAO instance;

    private PushDAO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PushDAO getInstance() {
        if (instance != null) return instance;
        Class<PushDAO> clazz = PushDAO.class;
        synchronized (PushDAO.class) {
            if (instance != null) return instance;
            instance = new PushDAO();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void saveCampaignId(Context context, String campaignId) {
        try {
            ContentValues values = new ContentValues();
            values.put("campaign_id", campaignId);
            values.put("ttl", Long.valueOf(MoEUtils.currentMillis() + RemoteConfig.getConfig().pushAmpCampaignExpiryTime));
            context.getContentResolver().insert(MoEDataContract.CampaignListEntity.getContentUri((Context)context), values);
        }
        catch (Exception e) {
            Logger.e((String)"PushDAO saveCampaignId() ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesCampaignExists(Context context, String campaignId) {
        Cursor cursor = null;
        try {
            if (MoEUtils.isEmptyString((String)campaignId)) {
                boolean bl = false;
                return bl;
            }
            cursor = context.getContentResolver().query(MoEDataContract.CampaignListEntity.getContentUri((Context)context), new String[]{"campaign_id"}, "campaign_id=?", new String[]{campaignId}, null);
            if (cursor != null && cursor.moveToFirst()) {
                boolean bl = true;
                this.closeCursor(cursor);
                return bl;
            }
            this.closeCursor(cursor);
        }
        catch (Exception e) {
            Logger.e((String)"PushDAO doesCampaignExists() ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return false;
    }

    public void saveCampaign(Context context, NotificationPayload campaignPayload) {
        try {
            String msgDetails = MoEngageNotificationUtils.convertBundleToJsonString(campaignPayload.payload);
            ContentValues values = new ContentValues();
            values.put("msg", msgDetails);
            long gTime = campaignPayload.payload.getLong("MOE_MSG_RECEIVED_TIME");
            values.put("gtime", Long.valueOf(gTime));
            values.put("msgclicked", Integer.valueOf(0));
            values.put("msgttl", Long.valueOf(campaignPayload.inboxExpiry));
            values.put("msg_tag", campaignPayload.campaignTag);
            values.put("campaign_id", campaignPayload.campaignId);
            Uri newRecord = context.getContentResolver().insert(MoEDataContract.MessageEntity.getContentUri((Context)context), values);
            if (newRecord != null) {
                Logger.v((String)("PushDAO saveCampaign() : Add a new record with entry: " + newRecord));
            } else {
                Logger.v((String)"PushDAO saveCampaign() : Failed to add notification to inbox.");
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushDAO saveCampaign() : ", (Throwable)e);
        }
    }

    public int updateNotificationClick(Context context, Bundle pushPayload) {
        int count = -1;
        try {
            ContentValues values = new ContentValues();
            values.put("msgclicked", Boolean.valueOf(true));
            String campaignId = pushPayload.getString("gcm_campaign_id");
            if (this.doesCampaignExistInInbox(context, campaignId)) {
                count = context.getContentResolver().update(MoEDataContract.MessageEntity.getContentUri((Context)context), values, "campaign_id = ? ", new String[]{campaignId});
            } else {
                long receivedTime = pushPayload.getLong("MOE_MSG_RECEIVED_TIME", -1L);
                if (receivedTime == -1L) {
                    Logger.v((String)"PushDAO updateNotificationClick() : Cannot update click, received time not present.");
                    return count;
                }
                count = context.getContentResolver().update(MoEDataContract.MessageEntity.getContentUri((Context)context), values, "gtime = ? ", new String[]{String.valueOf(receivedTime)});
            }
            if (count > 0) {
                context.getContentResolver().notifyChange(MoEDataContract.MessageEntity.getContentUri((Context)context), null);
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushDAO updateNotificationClick() : ", (Throwable)e);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesCampaignExistInInbox(Context context, String campaignId) {
        Cursor cursor = null;
        try {
            if (MoEUtils.isEmptyString((String)campaignId)) {
                boolean bl = false;
                return bl;
            }
            cursor = context.getContentResolver().query(MoEDataContract.MessageEntity.getContentUri((Context)context), new String[]{"campaign_id"}, "campaign_id = ? ", new String[]{campaignId}, null);
            if (cursor != null && cursor.moveToFirst()) {
                boolean bl = true;
                this.closeCursor(cursor);
                return bl;
            }
            this.closeCursor(cursor);
        }
        catch (Exception e) {
            Logger.e((String)"PushDAO doesCampaignExistInInbox() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return false;
    }

    private void closeCursor(Cursor cursor) {
        if (cursor != null) {
            cursor.close();
        }
    }
}

