/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.repository;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.SdkConfig;
import com.moengage.pushbase.model.ActionButton;
import com.moengage.pushbase.model.NotificationPayload;
import com.moengage.pushbase.model.NotificationText;
import com.moengage.pushbase.model.action.Action;
import com.moengage.pushbase.model.action.CallAction;
import com.moengage.pushbase.model.action.CopyAction;
import com.moengage.pushbase.model.action.CustomAction;
import com.moengage.pushbase.model.action.NavigationAction;
import com.moengage.pushbase.model.action.RemindLaterAction;
import com.moengage.pushbase.model.action.ShareAction;
import com.moengage.pushbase.model.action.SnoozeAction;
import com.moengage.pushbase.model.action.TrackAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PayloadParser {
    private static final String TAG = "PushBase_4.2.03_PayloadParser";
    private static final Map<String, String> MAPPER;
    private static final String NOTIFICATION_ACTION_BUTTONS = "gcm_actions";
    private static final String NOTIFICATION_CAMPAIGN_ID = "gcm_campaign_id";
    private static final String NOTIFICATION_TONE = "gcm_tone";
    private static final String AUTO_DISMISS = "autoDismiss";
    private static final String IS_PERSISTENT = "isPersistent";
    private static final String PUSH_TO_INBOX = "pushToInbox";
    private static final String IGNORE_INBOX = "ignoreInbox";
    private static final String MESSAGE_TAG = "msgTag";
    private static final String SHOW_MULTIPLE_NOTIFICATIONS = "showMultipleNotification";
    private static final String NOTIFICATION_LARGE_ICON = "largeIcon";
    private static final String DO_NOT_CANCEL = "dismissOnClick";
    private static final String ANDROID = "android";
    private static final String KEY_ACTION_TAG = "action_tag";
    private static final String KEY_ACTION_TITLE = "action_title";
    private static final String KEY_ACTION_ICON = "action_icon";
    private static final String KEY_ACTION_ID = "action_id";
    private static final String KEY_ACTION_VALUE = "value";
    private static final String KEY_ACTION_MESSAGE = "msg";
    private static final String KEY_ACTION_CONTENT = "content";
    private static final String KEY_ACTION_URI = "uri";
    private static final String KEY_ACTION_SCREEN = "screen";
    private static final String KEY_ACTION_EXTRAS = "extras";
    private static final String KEY_ACTION_VALUE_TODAY = "value_today";
    private static final String KEY_ACTION_VALUE_TOMORROW = "value_tomorrow";
    private static final String KEY_ACTION_VALUE_OF = "valueOf";
    private static final String KEY_ACTION_TRACK = "track";
    private static final String KEY_ACTION_SET = "set";
    private static final String KEY_ACTION_CUSTOM_ACTION = "custom_payload";

    public NotificationPayload parsePayload(Bundle payload) {
        NotificationPayload notificationPayload = new NotificationPayload(payload);
        boolean hasTemplate = this.hasTemplate(payload);
        notificationPayload.channelId = payload.getString("moe_channel_id", "moe_default_channel");
        notificationPayload.notificationType = payload.getString("gcm_notificationType");
        notificationPayload.text = this.getText(payload, hasTemplate);
        notificationPayload.campaignId = payload.getString(NOTIFICATION_CAMPAIGN_ID);
        notificationPayload.imageUrl = payload.getString("gcm_image_url");
        notificationPayload.inboxExpiry = Long.parseLong(payload.getString("inbox_expiry", String.valueOf(MoEUtils.currentSeconds() + 7776000L))) * 1000L;
        notificationPayload.actionButtonList = this.actionButtonsFromJson(payload);
        notificationPayload.enableDebugLogs = Boolean.parseBoolean(payload.getString("moe_enable_logs", "false"));
        notificationPayload.sound = payload.getString(NOTIFICATION_TONE, SdkConfig.getConfig().pushConfig.tone);
        this.parseKVFeatures(notificationPayload);
        return notificationPayload;
    }

    private NotificationText getText(Bundle payload, boolean hasTemplate) {
        try {
            if (hasTemplate) {
                NotificationText richText = this.getRichText(payload);
                if (!MoEUtils.isEmptyString((String)richText.title) && !MoEUtils.isEmptyString((String)richText.message)) {
                    return richText;
                }
            }
            return this.getDefaultText(payload);
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PayloadParser getText() : ", (Throwable)e);
            return this.getDefaultText(payload);
        }
    }

    private NotificationText getRichText(Bundle payload) throws JSONException {
        String moeFeatures = payload.getString("moeFeatures");
        JSONObject featuresJson = new JSONObject(moeFeatures);
        JSONObject richPush = featuresJson.getJSONObject("richPush");
        return new NotificationText(richPush.optString("title", ""), richPush.optString("body", ""), richPush.optString("summary", ""));
    }

    private NotificationText getDefaultText(Bundle payload) {
        return new NotificationText(payload.getString("gcm_title"), payload.getString("gcm_alert"), payload.getString("gcm_subtext", ""));
    }

    private boolean hasTemplate(Bundle payloadBundle) {
        try {
            if (!payloadBundle.containsKey("moeFeatures")) {
                return false;
            }
            String moeFeatures = payloadBundle.getString("moeFeatures");
            if (MoEUtils.isEmptyString((String)moeFeatures)) {
                return false;
            }
            JSONObject featuresJson = new JSONObject(moeFeatures);
            return featuresJson.has("richPush");
        }
        catch (JSONException e) {
            Logger.e((String)"PushBase_4.2.03_PayloadParser hasTemplate() : ", (Throwable)e);
            return false;
        }
    }

    private void parseKVFeatures(NotificationPayload notificationPayload) {
        try {
            if (!notificationPayload.payload.containsKey("moeFeatures")) {
                return;
            }
            String moeFeatures = notificationPayload.payload.getString("moeFeatures");
            JSONObject featuresJson = new JSONObject(moeFeatures);
            notificationPayload.campaignTag = featuresJson.optString(MESSAGE_TAG, "general");
            notificationPayload.shouldIgnoreInbox = featuresJson.optBoolean(IGNORE_INBOX, false);
            notificationPayload.pushToInbox = featuresJson.optBoolean(PUSH_TO_INBOX, false);
            notificationPayload.isRichPush = featuresJson.has("richPush");
            JSONObject androidJson = featuresJson.optJSONObject(ANDROID);
            if (androidJson == null) {
                return;
            }
            notificationPayload.isPersistent = androidJson.optBoolean(IS_PERSISTENT, false);
            notificationPayload.shouldDismissOnClick = androidJson.optBoolean(DO_NOT_CANCEL, true);
            notificationPayload.autoDismissTime = androidJson.optLong(AUTO_DISMISS, -1L);
            notificationPayload.shouldShowMultipleNotification = androidJson.has(SHOW_MULTIPLE_NOTIFICATIONS) ? androidJson.getBoolean(SHOW_MULTIPLE_NOTIFICATIONS) : SdkConfig.getConfig().pushConfig.shouldShowMultiplePushInDrawer;
            notificationPayload.largeIconUrl = androidJson.optString(NOTIFICATION_LARGE_ICON, "");
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PayloadParser parseAndAddMoEngageFeatures() : ", (Throwable)e);
        }
    }

    @Nullable
    private List<ActionButton> actionButtonsFromJson(Bundle payload) {
        try {
            if (!payload.containsKey(NOTIFICATION_ACTION_BUTTONS)) {
                return null;
            }
            String actionButtonString = payload.getString(NOTIFICATION_ACTION_BUTTONS);
            JSONArray buttonArray = new JSONArray(actionButtonString);
            int buttonCount = Math.min(buttonArray.length(), 3);
            ArrayList<ActionButton> actionButtonList = new ArrayList<ActionButton>(buttonCount);
            for (int index = 0; index < buttonCount; ++index) {
                ActionButton actionButton = this.buttonFromJson(buttonArray.getJSONObject(index));
                if (actionButton == null) continue;
                actionButtonList.add(actionButton);
            }
            return actionButtonList;
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PayloadParser actionButtonsFromJson() : ", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private ActionButton buttonFromJson(JSONObject jsonObject) {
        try {
            ActionButton actionButton = new ActionButton(jsonObject.getString(KEY_ACTION_TITLE), jsonObject.optString(KEY_ACTION_ICON, ""), jsonObject.getString(KEY_ACTION_ID), this.actionFromJson(jsonObject));
            if (MoEUtils.isEmptyString((String)actionButton.title)) {
                return null;
            }
            return actionButton;
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PayloadParser buttonFromJson() : ", (Throwable)e);
            return null;
        }
    }

    private Action actionFromJson(JSONObject actionJson) {
        try {
            String type = actionJson.getString(KEY_ACTION_TAG);
            if (!MAPPER.containsKey(type)) {
                return null;
            }
            String actionType = MAPPER.get(type);
            if (MoEUtils.isEmptyString((String)actionType)) {
                return null;
            }
            switch (actionType) {
                case "navigate": {
                    return this.navigationActionFromJson(actionJson);
                }
                case "track": {
                    return this.trackActionFromJson(actionJson);
                }
                case "share": {
                    return this.shareActionFromJson(actionJson);
                }
                case "call": {
                    return this.callActionFromJson(actionJson);
                }
                case "copy": {
                    return this.copyActionFromJson(actionJson);
                }
                case "remindLater": {
                    return this.remindLaterActionFromJson(actionJson);
                }
                case "snooze": {
                    return this.snoozeActionFromJson(actionJson);
                }
                case "custom": {
                    return this.customActionFromJson(actionJson);
                }
            }
            Logger.e((String)"PushBase_4.2.03_PayloadParser actionFromJson() : Not a supported action.");
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PayloadParser actionFromJson() : ", (Throwable)e);
        }
        return null;
    }

    private SnoozeAction snoozeActionFromJson(JSONObject actionJson) throws JSONException {
        return new SnoozeAction(MAPPER.get(actionJson.getString(KEY_ACTION_TAG)), Integer.parseInt(actionJson.getString(KEY_ACTION_VALUE).trim()));
    }

    private CallAction callActionFromJson(JSONObject actionJson) throws JSONException {
        return new CallAction(MAPPER.get(actionJson.getString(KEY_ACTION_TAG)), actionJson.getString(KEY_ACTION_VALUE));
    }

    private CopyAction copyActionFromJson(JSONObject actionJson) throws JSONException {
        return new CopyAction(MAPPER.get(actionJson.getString(KEY_ACTION_TAG)), actionJson.getString(KEY_ACTION_VALUE));
    }

    private ShareAction shareActionFromJson(JSONObject actionJson) throws JSONException {
        return new ShareAction(MAPPER.get(actionJson.getString(KEY_ACTION_TAG)), actionJson.getString(KEY_ACTION_CONTENT));
    }

    private NavigationAction navigationActionFromJson(JSONObject actionJson) throws JSONException {
        String navigationType = "";
        navigationType = this.getNavigationType(actionJson);
        if (navigationType == null) {
            return null;
        }
        if (MoEUtils.isEmptyString((String)navigationType)) {
            return null;
        }
        String url = "";
        switch (navigationType) {
            case "screenName": {
                url = actionJson.getString(KEY_ACTION_SCREEN);
                break;
            }
            case "richLanding": {
                url = actionJson.getJSONObject(KEY_ACTION_EXTRAS).getString("gcm_webUrl");
                break;
            }
            case "deepLink": {
                url = actionJson.getString(KEY_ACTION_URI);
                break;
            }
            default: {
                Logger.e((String)"PushBase_4.2.03_PayloadParser navigationActionFromJson() : Not a valid navigation type");
            }
        }
        if (MoEUtils.isEmptyString((String)url)) {
            return null;
        }
        return new NavigationAction(MAPPER.get(actionJson.getString(KEY_ACTION_TAG)), navigationType, url, actionJson.has(KEY_ACTION_EXTRAS) ? MoEUtils.jsonToBundle((JSONObject)actionJson.getJSONObject(KEY_ACTION_EXTRAS)) : null);
    }

    @Nullable
    private String getNavigationType(JSONObject actionJson) throws JSONException {
        String navigationType;
        if (actionJson.has(KEY_ACTION_URI)) {
            navigationType = "deepLink";
        } else if (actionJson.has(KEY_ACTION_SCREEN)) {
            JSONObject extras;
            navigationType = !actionJson.has(KEY_ACTION_EXTRAS) ? "screenName" : ((extras = actionJson.getJSONObject(KEY_ACTION_EXTRAS)).length() == 1 && extras.has("gcm_webUrl") ? "richLanding" : "screenName");
        } else {
            return null;
        }
        return navigationType;
    }

    private RemindLaterAction remindLaterActionFromJson(JSONObject actionJson) throws JSONException {
        return new RemindLaterAction(MAPPER.get(actionJson.getString(KEY_ACTION_TAG)), actionJson.optInt(KEY_ACTION_VALUE_TODAY, -1), actionJson.optInt(KEY_ACTION_VALUE_TOMORROW, -1));
    }

    private TrackAction trackActionFromJson(JSONObject actionJson) throws JSONException {
        String actionTag = actionJson.getString(KEY_ACTION_TAG);
        String actionType = MAPPER.get(actionTag);
        if (MoEUtils.isEmptyString((String)actionType)) {
            return null;
        }
        String trackType = "";
        if ("m_track".equals(actionTag)) {
            trackType = "event";
        } else if ("m_set".equals(actionTag)) {
            trackType = "userAttribute";
        }
        if (MoEUtils.isEmptyString((String)trackType)) {
            return null;
        }
        switch (trackType) {
            case "event": {
                return new TrackAction(actionType, trackType, actionJson.getString(KEY_ACTION_VALUE_OF), actionJson.getString(KEY_ACTION_TRACK));
            }
            case "userAttribute": {
                return new TrackAction(actionType, trackType, actionJson.getString(KEY_ACTION_VALUE), actionJson.getString(KEY_ACTION_SET));
            }
        }
        return null;
    }

    private CustomAction customActionFromJson(JSONObject actionJson) throws JSONException {
        return new CustomAction(MAPPER.get(actionJson.getString(KEY_ACTION_TAG)), actionJson.getString(KEY_ACTION_CUSTOM_ACTION));
    }

    static {
        LinkedHashMap<String, String> mapper = new LinkedHashMap<String, String>();
        mapper.put("m_nav", "navigate");
        mapper.put("m_track", KEY_ACTION_TRACK);
        mapper.put("m_share", "share");
        mapper.put("m_call", "call");
        mapper.put("m_copy", "copy");
        mapper.put("m_set", KEY_ACTION_TRACK);
        mapper.put("m_remind_exact", "snooze");
        mapper.put("m_remind_inexact", "remindLater");
        mapper.put("m_custom", "custom");
        MAPPER = Collections.unmodifiableMap(mapper);
    }
}

