/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.push.task;

import android.content.Context;
import android.os.Bundle;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.pushbase.MoEPushHelper;
import com.moengage.pushbase.push.MoEngageNotificationUtils;
import com.moengage.pushbase.repository.PushDAO;
import java.util.Map;

public class LogNotificationImpressionTask
extends SDKTask {
    private static final String TAG = "PushBase_4.2.03_LogNotificationImpressionTask";
    private Map<String, String> payload;

    public LogNotificationImpressionTask(Context context, Map<String, String> payload) {
        super(context);
        this.payload = payload;
    }

    public TaskResult execute() {
        try {
            Logger.v((String)"PushBase_4.2.03_LogNotificationImpressionTask execute() : Started Execution");
            if (this.payload == null) {
                return this.taskResult;
            }
            Bundle payloadBundle = MoEUtils.convertMapToBundle(this.payload);
            if (payloadBundle == null) {
                return this.taskResult;
            }
            payloadBundle.putLong("MOE_MSG_RECEIVED_TIME", MoEUtils.currentMillis());
            String campaignId = payloadBundle.getString("gcm_campaign_id", "");
            if (MoEUtils.isEmptyString((String)campaignId)) {
                return this.taskResult;
            }
            if (PushDAO.getInstance().doesCampaignExists(this.context, campaignId)) {
                Logger.v((String)"PushBase_4.2.03_LogNotificationImpressionTask execute() : Impression has already been logged by this campaign. Will not log impression again.");
                return this.taskResult;
            }
            MoEPushHelper.getInstance().getMessageListener().logCampaignImpression(this.context, payloadBundle);
            PushDAO.getInstance().saveCampaignId(this.context, campaignId);
            MoEngageNotificationUtils.addNotificationToInboxIfRequired(this.context, payloadBundle);
            this.taskResult.setIsSuccess(true);
            Logger.v((String)"PushBase_4.2.03_LogNotificationImpressionTask execute() : Completed execution.");
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_LogNotificationImpressionTask execute() : ", (Throwable)e);
        }
        return this.taskResult;
    }

    public String getTaskTag() {
        return "LOG_NOTIFICATION_IMPRESSION";
    }

    public boolean isSynchronous() {
        return false;
    }
}

