/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.push.task;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.internal.analytics.AnalyticsHelper;
import com.moengage.pushbase.PushSourceProcessor;
import com.moengage.pushbase.push.MoEngageNotificationUtils;

public class LogNotificationClickTask
extends SDKTask {
    private static final String TAG = "PushBase_4.2.03_LogNotificationClickTask";
    private Intent intent;

    public LogNotificationClickTask(Context context, Intent intent) {
        super(context);
        this.intent = intent;
    }

    public TaskResult execute() {
        try {
            Logger.v((String)"PushBase_4.2.03_LogNotificationClickTask execute() : Started Execution.");
            if (this.intent == null) {
                return this.taskResult;
            }
            Bundle pushPayload = this.intent.getExtras();
            if (pushPayload == null) {
                return this.taskResult;
            }
            String campaignId = pushPayload.getString("gcm_campaign_id", "");
            if (MoEUtils.isEmptyString((String)campaignId)) {
                return this.taskResult;
            }
            PushSourceProcessor processor = new PushSourceProcessor(pushPayload);
            AnalyticsHelper.getInstance((Context)this.context).onNotificationClicked(this.context, processor.getTrafficSourceForCampaign());
            MoEngageNotificationUtils.logNotificationClick(this.context, this.intent);
            this.taskResult.setIsSuccess(true);
            Logger.v((String)"PushBase_4.2.03_LogNotificationClickTask execute() : Completed Execution.");
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_LogNotificationClickTask execute() : Exception ", (Throwable)e);
        }
        return this.taskResult;
    }

    public String getTaskTag() {
        return "LOG_NOTIFICATION_CLICK";
    }

    public boolean isSynchronous() {
        return false;
    }
}

