/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.push;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.core.app.NotificationCompat;
import androidx.core.app.TaskStackBuilder;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.activities.MoEActivity;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.internal.location.GeoManager;
import com.moengage.pushbase.MoEPushHelper;
import com.moengage.pushbase.activities.PushTracker;
import com.moengage.pushbase.model.NotificationMetaData;
import com.moengage.pushbase.model.NotificationPayload;
import com.moengage.pushbase.model.action.NavigationAction;
import com.moengage.pushbase.push.MoEngageNotificationUtils;
import com.moengage.pushbase.push.NotificationBuilder;
import com.moengage.pushbase.push.task.LogNotificationClickTask;
import com.moengage.pushbase.repository.PayloadParser;
import com.moengage.pushbase.repository.PushDAO;
import com.moengage.pushbase.richnotification.RichNotificationManager;
import java.util.Map;
import org.json.JSONObject;

public class PushMessageListener {
    private final Object lock = new Object();
    private static final String TAG = "PushBase_4.2.03_PushMessageListener";
    private boolean isOnCreateNotificationCalled = false;
    private NotificationPayload notificationPayload;
    private NotificationBuilder notificationBuilder;
    private boolean isNotificationRequiredCalled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onMessageReceived(Context context, Bundle payload) {
        Object object = this.lock;
        synchronized (object) {
            try {
                Logger.v((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() : Push Payload received will try to show notification.");
                if (payload == null || context == null) {
                    return;
                }
                if (ConfigurationProvider.getInstance((Context)context).isPushNotificationOptedOut()) {
                    Logger.w((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() : push notification opted out cannot show push");
                    return;
                }
                MoEUtils.dumpIntentExtras((String)TAG, (Bundle)payload);
                if (!MoEPushHelper.getInstance().isFromMoEngagePlatform(payload)) {
                    Logger.w((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() : Non-MoEngage push received, passing callback.");
                    this.onNonMoEngageMessageReceived(context, payload);
                    return;
                }
                this.notificationPayload = new PayloadParser().parsePayload(payload);
                if (this.notificationPayload == null) {
                    Logger.v((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() : Payload parsing failed. Cannot show notification.");
                    return;
                }
                this.serverSyncIfRequired(context, payload);
                this.enableLogsIfRequired(context, this.notificationPayload);
                Logger.v((String)("PushBase_4.2.03_PushMessageListener onMessageReceived() : Payload: " + this.notificationPayload));
                if (this.isSilentNotification(this.notificationPayload)) {
                    Logger.v((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() : Silent push, returning.");
                    return;
                }
                if (!this.isValidPayload(this.notificationPayload)) {
                    Logger.v((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() : Not a valid push payload. ignoring payload");
                    return;
                }
                ConfigurationProvider provider = ConfigurationProvider.getInstance((Context)context);
                if (PushDAO.getInstance().doesCampaignExists(context, this.notificationPayload.campaignId) && !MoEngageNotificationUtils.isReNotification(payload)) {
                    Logger.v((String)("PushBase_4.2.03_PushMessageListener onMessageReceived() : Received notification is already shown, will be ignored. Campaign id - " + this.notificationPayload.campaignId));
                    return;
                }
                if (!this.isSilentNotification(this.notificationPayload) && !MoEngageNotificationUtils.isReNotification(payload)) {
                    this.onNotificationReceived(context, payload);
                }
                if (!this.isNotificationRequired(context, payload) && !MoEngageNotificationUtils.isReNotification(payload)) {
                    Logger.v((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() : Notification not required. Discarding message.");
                    if (!this.isSilentNotification(this.notificationPayload)) {
                        Logger.v((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() : Notification not required");
                        this.onNotificationNotRequired(context, payload);
                    }
                    return;
                }
                if (!this.hasMetaDataForShowingPush(SdkConfig.getConfig())) {
                    Logger.w((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() : Not enough meta data for showing push notification. Check if the SDK is initialised correctly.");
                    return;
                }
                PushDAO.getInstance().saveCampaignId(context, this.notificationPayload.campaignId);
                payload.putLong("MOE_MSG_RECEIVED_TIME", MoEUtils.currentMillis());
                if (this.notificationPayload.pushToInbox && !MoEngageNotificationUtils.isReNotification(payload)) {
                    Logger.v((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() : Campaign need not be shown in notification drawer. Will be saved in inbox.");
                    this.logCampaignImpression(context, payload);
                    MoEngageNotificationUtils.addNotificationToInboxIfRequired(context, payload);
                    return;
                }
                Logger.i((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() Will try to show notification");
                Intent finalIntent = this.getRedirectIntent(context);
                finalIntent.putExtras(payload);
                int notificationId = payload.getInt("MOE_NOTIFICATION_ID", -1);
                if (notificationId == -1) {
                    notificationId = this.getNotificationId(provider, this.notificationPayload.shouldShowMultipleNotification);
                }
                finalIntent.putExtra("MOE_NOTIFICATION_ID", notificationId);
                this.notificationBuilder = new NotificationBuilder(context, this.notificationPayload, notificationId, finalIntent);
                NotificationCompat.Builder notificationCompatBuilder = MoEngageNotificationUtils.isReNotification(payload) ? this.onCreateNotificationInternal(context, payload, provider) : this.onCreateNotification(context, payload, provider);
                this.notificationBuilder.addAutoDismissIfAny();
                this.notificationBuilder.addClickAndClearCallbacks(notificationCompatBuilder);
                Notification notification = notificationCompatBuilder.build();
                this.customizeNotification(notification, context, payload);
                if (!this.isNotificationRequiredCalled) {
                    throw new IllegalStateException("super.isNotificationRequired(context, extras) not called.");
                }
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                if (!this.notificationPayload.isRichPush || !MoEngageNotificationUtils.isReNotification(payload)) {
                    notificationManager.notify(notificationId, notification);
                }
                if (!(this.isSilentNotification(this.notificationPayload) || MoEUtils.isEmptyString((String)this.notificationPayload.campaignId) || MoEngageNotificationUtils.isReNotification(payload))) {
                    MoEngageNotificationUtils.addNotificationToInboxIfRequired(context, payload);
                    this.logCampaignImpression(context, payload);
                    this.onPostNotificationReceived(context, payload);
                }
                this.isNotificationRequiredCalled = false;
                if (!this.isOnCreateNotificationCalled) {
                    Logger.v((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() : onCreateNotification is not called. Client has overridden and customised the display will not add rich content.");
                    return;
                }
                boolean isUpdateRequired = false;
                if (this.notificationPayload.isRichPush && RichNotificationManager.getInstance().hasRichNotificationModule() && RichNotificationManager.getInstance().isTemplateSupported(this.notificationPayload)) {
                    Logger.v((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() : Will try to build rich notification.");
                    isUpdateRequired = RichNotificationManager.getInstance().buildTemplate(context, new NotificationMetaData(this.notificationPayload, notificationCompatBuilder, finalIntent, notificationId));
                    if (isUpdateRequired && !MoEngageNotificationUtils.isReNotification(this.notificationPayload.payload)) {
                        Properties properties = new Properties();
                        properties.addAttribute("gcm_campaign_id", (Object)this.notificationPayload.campaignId);
                        MoEngageNotificationUtils.addAttributesToProperties(this.notificationPayload.payload, properties);
                        properties.setNonInteractive();
                        MoEHelper.getInstance((Context)context).trackEvent(MoEConstants.NOTIFICATION_SHOWN, properties);
                    }
                } else if (!MoEUtils.isEmptyString((String)this.notificationPayload.imageUrl)) {
                    notificationCompatBuilder = this.notificationBuilder.buildImageNotification(notificationCompatBuilder);
                    isUpdateRequired = true;
                } else {
                    this.notificationPayload = null;
                    return;
                }
                if (!isUpdateRequired) {
                    Logger.v((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() : Re-posting not required.");
                    return;
                }
                if (this.notificationPayload.isPersistent) {
                    notificationCompatBuilder.setOngoing(true);
                }
                notificationCompatBuilder.setChannelId("moe_rich_content");
                notification = notificationCompatBuilder.build();
                if (notificationManager != null) {
                    notificationManager.notify(notificationId, notification);
                }
            }
            catch (Exception e) {
                Logger.e((String)"PushBase_4.2.03_PushMessageListener onMessageReceived() ", (Throwable)e);
            }
        }
    }

    private void enableLogsIfRequired(Context context, NotificationPayload notificationPayload) {
        ConfigurationProvider.getInstance((Context)context).setDebugLogStatus(notificationPayload.enableDebugLogs);
        if (notificationPayload.enableDebugLogs) {
            SdkConfig.getConfig().logConfig.level = 5;
            SdkConfig.getConfig().logConfig.isEnabledForSignedBuild = true;
        }
    }

    protected void onPostNotificationReceived(Context context, Bundle payload) {
        Logger.v((String)"PushBase_4.2.03_PushMessageListener onPostNotificationReceived() : Callback after notification is shown.");
    }

    public void onNonMoEngageMessageReceived(Context context, Bundle payload) {
        Logger.v((String)"PushBase_4.2.03_PushMessageListener onNonMoEngageMessageReceived() : Callback for non-moengage push received.");
    }

    public void onNotificationNotRequired(Context context, Bundle payload) {
        Logger.v((String)"PushBase_4.2.03_PushMessageListener onNotificationNotRequired() : Callback for discarded notification.");
    }

    public void onNotificationCleared(Context context, Bundle payload) {
        Logger.v((String)"PushBase_4.2.03_PushMessageListener onNotificationCleared() : Callback for notification cleared.");
    }

    public void onNotificationReceived(Context context, Bundle payload) {
        Logger.v((String)"PushBase_4.2.03_PushMessageListener onNotificationReceived() : Callback for notification received.");
    }

    public void handleCustomAction(Context context, String payload) {
        Logger.v((String)("PushBase_4.2.03_PushMessageListener handleCustomAction() : Custom Action on notification click. Payload: " + payload));
    }

    public boolean isNotificationRequired(Context context, Bundle payload) {
        this.isNotificationRequiredCalled = true;
        Logger.v((String)"PushBase_4.2.03_PushMessageListener isNotificationRequired() : ");
        return !this.isSilentNotification(this.notificationPayload);
    }

    public NotificationCompat.Builder onCreateNotification(Context context, Bundle payload, ConfigurationProvider provider) {
        return this.onCreateNotificationInternal(context, payload, provider);
    }

    private NotificationCompat.Builder onCreateNotificationInternal(Context context, Bundle payload, ConfigurationProvider provider) {
        this.isOnCreateNotificationCalled = true;
        return this.notificationBuilder.buildTextNotification();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Intent getRedirectIntent(Context context) {
        Intent pushTrackerIntent = new Intent(context, PushTracker.class);
        pushTrackerIntent.setAction("" + System.currentTimeMillis());
        pushTrackerIntent.setFlags(0x10000000);
        return pushTrackerIntent;
    }

    public final void logCampaignImpression(Context context, Bundle payload) {
        MoEngageNotificationUtils.logNotificationImpression(context, payload);
    }

    public final int getNotificationId(ConfigurationProvider configProvider, boolean update) {
        if (!update) {
            return configProvider.getNotificationId();
        }
        int id = configProvider.getNotificationId();
        configProvider.updateNotificationId(++id);
        return id;
    }

    public void customizeNotification(Notification notification, Context context, Bundle payload) {
    }

    public void onHandleRedirection(Activity activity, Bundle payload) {
        Logger.v((String)"PushBase_4.2.03_PushMessageListener: onHandleRedirection() Will try to redirect user.");
        Intent launcherIntent = MoEHelperUtils.getLauncherActivityIntent((Context)activity);
        try {
            boolean isDefaultAction = payload.getBoolean("moe_isDefaultAction", true);
            if (!isDefaultAction) {
                this.handleActionButtonNavigation(activity, payload);
                return;
            }
            Logger.v((String)"PushBase_4.2.03_PushMessageListener onHandleRedirection() : Processing default notification action click.");
            String notificationType = payload.getString("gcm_notificationType");
            if (MoEUtils.isEmptyString((String)notificationType)) {
                activity.startActivity(launcherIntent);
                return;
            }
            if ("gcm_webNotification".equals(notificationType)) {
                Logger.v((String)"PushBase_4.2.03_PushMessageListener onHandleRedirection() : Will try to open url.");
                Uri finalLink = this.getDeepLink(payload);
                payload.remove("gcm_webNotification");
                payload.remove("gcm_notificationType");
                if (finalLink == null) {
                    return;
                }
                Logger.v((String)("PushMessagingListener:onHandleRedirection : Final URI : " + finalLink.toString()));
                Intent redirectIntent = new Intent("android.intent.action.VIEW", finalLink);
                redirectIntent.putExtras(payload);
                redirectIntent.addFlags(this.getIntentFlags(payload));
                activity.startActivity(redirectIntent);
                return;
            }
            String activityName = payload.getString("gcm_activityName");
            Intent redirectIntent = !MoEUtils.isEmptyString((String)activityName) ? new Intent((Context)activity, Class.forName(activityName)) : launcherIntent;
            payload.putBoolean("FROM_BACKGROUND", !MoEHelper.isAppInForeground());
            redirectIntent.putExtras(payload);
            redirectIntent.addFlags(this.getIntentFlags(payload));
            if (!SdkConfig.getConfig().pushConfig.isBackStackBuilderOptedOut) {
                Logger.v((String)"PushBase_4.2.03_PushMessageListener onHandleRedirection() : synthesizing back-stack");
                TaskStackBuilder builder = TaskStackBuilder.create((Context)activity);
                builder.addNextIntentWithParentStack(redirectIntent).startActivities();
            } else {
                activity.startActivity(redirectIntent);
            }
            return;
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PushMessageListener onHandleRedirection() ", (Throwable)e);
            activity.startActivity(launcherIntent);
            return;
        }
    }

    private Uri getDeepLink(Bundle pushPayload) {
        if (pushPayload.containsKey("moe_webUrl")) {
            return Uri.parse((String)pushPayload.getString("moe_webUrl"));
        }
        Uri link = Uri.parse((String)pushPayload.getString("gcm_webUrl"));
        Uri.Builder builder = link.buildUpon();
        MoEngageNotificationUtils.addPayloadToUri(pushPayload, builder);
        return builder.build();
    }

    private void handleActionButtonNavigation(Activity activity, Bundle payload) {
        try {
            Context context = activity.getApplicationContext();
            NavigationAction action = (NavigationAction)payload.getParcelable("moe_navAction");
            if (action == null || MoEUtils.isEmptyString((String)action.navigationType) || MoEUtils.isEmptyString((String)action.navigationUrl)) {
                Logger.v((String)"PushBase_4.2.03_PushMessageListener handleActionButtonNavigation() : Not a valid action.");
                return;
            }
            Logger.v((String)("PushBase_4.2.03_PushMessageListener handleActionButtonNavigation() : Action: " + action));
            Intent intent = null;
            switch (action.navigationType) {
                case "screenName": {
                    intent = new Intent(context, Class.forName(action.navigationUrl));
                    break;
                }
                case "deepLink": {
                    intent = new Intent("android.intent.action.VIEW", Uri.parse((String)action.navigationUrl));
                    break;
                }
                case "richLanding": {
                    intent = new Intent((Context)activity, MoEActivity.class);
                    intent.putExtra("gcm_webUrl", action.navigationUrl);
                    break;
                }
                default: {
                    Logger.v((String)"PushBase_4.2.03_PushMessageListener handleActionButtonNavigation() : Not a valid navigation type.");
                }
            }
            if (intent == null) {
                return;
            }
            if (action.keyValuePair != null && !action.keyValuePair.isEmpty()) {
                intent.putExtras(action.keyValuePair);
            }
            if (!SdkConfig.getConfig().pushConfig.isBackStackBuilderOptedOut) {
                Logger.v((String)"PushBase_4.2.03_PushMessageListener handleActionButtonNavigation() : synthesizing back-stack.");
                TaskStackBuilder builder = TaskStackBuilder.create((Context)context);
                builder.addNextIntentWithParentStack(intent).startActivities();
            } else {
                activity.startActivity(intent);
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PushMessageListener handleActionButtonNavigation() : ", (Throwable)e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void logNotificationClicked(Context context, Intent intent) {
        Logger.v((String)"PushBase_4.2.03_PushMessageListener logNotificationClicked() : Will track notification click.");
        TaskManager.getInstance().addTaskToQueueBeginning((ITask)new LogNotificationClickTask(context, intent));
    }

    public final void dismissNotificationAfterClick(Context context, Bundle payload) {
        Logger.v((String)"PushBase_4.2.03_PushMessageListener dismissNotificationAfterClick() : Will attempt to dismiss notification.");
        int notificationId = payload.getInt("MOE_NOTIFICATION_ID", -1);
        NotificationPayload notificationPayload = new PayloadParser().parsePayload(payload);
        Logger.v((String)("PushBase_4.2.03_PushMessageListener dismissNotificationAfterClick() : Should dismiss notification: " + notificationPayload.shouldDismissOnClick + " Notification id: " + notificationId));
        if (notificationPayload.isPersistent) {
            return;
        }
        if (notificationId != -1 && notificationPayload.shouldDismissOnClick) {
            NotificationManager manager = (NotificationManager)context.getSystemService("notification");
            manager.cancel(notificationId);
        }
    }

    public int getIntentFlags(Bundle payload) {
        return 0x30000000;
    }

    public final void onMessageReceived(Context context, Map<String, String> payloadMap) {
        Bundle bundle = MoEUtils.convertMapToBundle(payloadMap);
        if (bundle != null) {
            this.onMessageReceived(context, bundle);
        }
    }

    private boolean shouldMakeGeoFenceCall(Bundle bundle) {
        return bundle.getString("update_geo_fences", "false").equals("true");
    }

    private boolean isSilentNotification(NotificationPayload payload) {
        return "gcm_silentNotification".equals(payload.notificationType);
    }

    private void serverSyncIfRequired(Context context, Bundle pushPayload) {
        try {
            Logger.v((String)"PushBase_4.2.03_PushMessageListener serverSyncIfRequired() : Sync APIs if required.");
            if (this.shouldMakeGeoFenceCall(pushPayload)) {
                GeoManager.getInstance().updateFenceAndLocation(context);
            }
            if (!pushPayload.containsKey("moe_sync")) {
                return;
            }
            String syncRequestString = pushPayload.getString("moe_sync");
            JSONObject syncJson = new JSONObject(syncRequestString);
            if (syncJson.length() == 0 || !syncJson.has("type")) {
                return;
            }
            String syncType = syncJson.getString("type");
            Logger.v((String)("PushBase_4.2.03_PushMessageListener serverSyncIfRequired() : Request type: " + syncType));
            switch (syncType) {
                case "config": {
                    MoEDispatcher.getInstance((Context)context).syncConfigIfRequired();
                    break;
                }
                case "data": {
                    MoEDispatcher.getInstance((Context)context).sendInteractionData();
                }
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_PushMessageListener serverSyncIfRequired() : ", (Throwable)e);
        }
    }

    private boolean isValidPayload(NotificationPayload payload) {
        return !MoEUtils.isEmptyString((String)payload.campaignId) && !MoEUtils.isEmptyString((String)payload.text.title) && !MoEUtils.isEmptyString((String)payload.text.message);
    }

    private boolean hasMetaDataForShowingPush(SdkConfig config) {
        if (21 > Build.VERSION.SDK_INT && config.pushConfig.largeIcon == -1) {
            return false;
        }
        return config.pushConfig.smallIcon != -1;
    }
}

