/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.push;

import android.R;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.core.app.NotificationCompat;
import androidx.core.text.HtmlCompat;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.SdkConfig;
import com.moengage.pushbase.MoEPushReceiver;
import com.moengage.pushbase.model.ActionButton;
import com.moengage.pushbase.model.NotificationPayload;
import com.moengage.pushbase.model.action.Action;
import com.moengage.pushbase.push.MoEPushWorker;
import com.moengage.pushbase.push.MoEngageNotificationUtils;

public class NotificationBuilder {
    private static final String TAG = "PushBase_4.2.03_NotificationBuilder";
    private NotificationPayload notificationPayload;
    private Context context;
    private int notificationId;
    private Intent actionIntent;

    NotificationBuilder(Context context, NotificationPayload notificationPayload, int notificationId, Intent actionIntent) {
        this.context = context;
        this.notificationPayload = notificationPayload;
        this.notificationId = notificationId;
        this.actionIntent = actionIntent;
    }

    NotificationCompat.Builder buildTextNotification() {
        Uri tone;
        this.setUpNotificationChannel();
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, this.notificationPayload.channelId);
        builder.setContentTitle((CharSequence)HtmlCompat.fromHtml((String)this.notificationPayload.text.title, (int)63)).setContentText((CharSequence)HtmlCompat.fromHtml((String)this.notificationPayload.text.message, (int)63));
        if (!MoEUtils.isEmptyString((String)this.notificationPayload.text.summary)) {
            builder.setSubText((CharSequence)HtmlCompat.fromHtml((String)this.notificationPayload.text.summary, (int)63));
        }
        this.setNotificationSmallIcon(builder);
        this.setNotificationLargeIcon(builder);
        if (SdkConfig.getConfig().pushConfig.notificationColor != -1) {
            builder.setColor(this.context.getResources().getColor(SdkConfig.getConfig().pushConfig.notificationColor));
        }
        NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle().setBigContentTitle((CharSequence)HtmlCompat.fromHtml((String)this.notificationPayload.text.title, (int)63)).bigText((CharSequence)HtmlCompat.fromHtml((String)this.notificationPayload.text.message, (int)63));
        if (!MoEUtils.isEmptyString((String)this.notificationPayload.text.summary)) {
            bigTextStyle.setSummaryText((CharSequence)HtmlCompat.fromHtml((String)this.notificationPayload.text.summary, (int)63));
        }
        builder.setStyle((NotificationCompat.Style)bigTextStyle);
        if (!MoEUtils.isEmptyString((String)this.notificationPayload.sound) && (tone = Uri.parse((String)("android.resource://" + this.context.getPackageName() + "/raw/" + this.notificationPayload.sound))) != null) {
            builder.setSound(tone);
        }
        this.addActionButtonToNotification(builder);
        return builder;
    }

    public NotificationCompat.Builder buildImageNotification(NotificationCompat.Builder builder) {
        Bitmap bitmap = MoEngageNotificationUtils.scaleLandscapeBitmap(this.context, MoEHelperUtils.downloadImageBitmap((String)this.notificationPayload.imageUrl));
        if (bitmap == null) {
            return builder;
        }
        NotificationCompat.BigPictureStyle pictureStyle = new NotificationCompat.BigPictureStyle().bigPicture(bitmap);
        pictureStyle.setBigContentTitle((CharSequence)HtmlCompat.fromHtml((String)this.notificationPayload.text.title, (int)63));
        if (Build.VERSION.SDK_INT >= 24) {
            pictureStyle.setSummaryText((CharSequence)HtmlCompat.fromHtml((String)this.notificationPayload.text.message, (int)63));
        } else if (!MoEUtils.isEmptyString((String)this.notificationPayload.text.summary)) {
            pictureStyle.setSummaryText((CharSequence)HtmlCompat.fromHtml((String)this.notificationPayload.text.summary, (int)63));
        } else {
            pictureStyle.setSummaryText((CharSequence)HtmlCompat.fromHtml((String)this.notificationPayload.text.message, (int)63));
        }
        builder.setStyle((NotificationCompat.Style)pictureStyle).setChannelId("moe_rich_content");
        return builder;
    }

    private void setNotificationSmallIcon(NotificationCompat.Builder builder) {
        int resourceId = -1;
        resourceId = Build.VERSION.SDK_INT < 21 ? SdkConfig.getConfig().pushConfig.largeIcon : SdkConfig.getConfig().pushConfig.smallIcon;
        if (resourceId != -1) {
            builder.setSmallIcon(resourceId);
        }
    }

    private void setNotificationLargeIcon(NotificationCompat.Builder builder) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (SdkConfig.getConfig().pushConfig.isLargeIconOptedOut) {
            return;
        }
        Bitmap bitmap = null;
        bitmap = !MoEUtils.isEmptyString((String)this.notificationPayload.largeIconUrl) ? MoEHelperUtils.downloadImageBitmap((String)this.notificationPayload.largeIconUrl) : BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)SdkConfig.getConfig().pushConfig.largeIcon, null);
        if (bitmap != null) {
            builder.setLargeIcon(bitmap);
        }
    }

    private void setUpNotificationChannel() {
        if (MoEngageNotificationUtils.isReNotification(this.notificationPayload.payload)) {
            this.notificationPayload.channelId = "moe_rich_content";
            return;
        }
        if (MoEngageNotificationUtils.isNotificationChannelExists(this.context, this.notificationPayload.channelId)) {
            return;
        }
        this.notificationPayload.channelId = "moe_default_channel";
    }

    private void addActionButtonToNotification(NotificationCompat.Builder builder) {
        if (this.notificationPayload.actionButtonList == null || this.notificationPayload.actionButtonList.size() == 0) {
            return;
        }
        for (int index = 0; index < this.notificationPayload.actionButtonList.size(); ++index) {
            ActionButton actionButton = this.notificationPayload.actionButtonList.get(index);
            if (actionButton.action == null) continue;
            Intent clickIntent = "remindLater".equals(actionButton.action.actionType) ? MoEngageNotificationUtils.getIntentForSnooze(this.context, this.notificationPayload.payload, this.notificationId) : MoEngageNotificationUtils.getRedirectIntent(this.context, this.notificationPayload.payload, this.notificationId);
            clickIntent.putExtra("moe_action_id", actionButton.actionId);
            Parcelable[] actions = new Action[]{actionButton.action};
            clickIntent.putExtra("moe_action", actions);
            PendingIntent intent = PendingIntent.getActivity((Context)this.context, (int)(this.notificationId + (1000 + index)), (Intent)clickIntent, (int)0x8000000);
            NotificationCompat.Action notificationAction = new NotificationCompat.Action(this.getImageResourceId(actionButton.icon), (CharSequence)actionButton.title, intent);
            builder.addAction(notificationAction);
        }
    }

    private int getImageResourceId(String iconName) {
        if (MoEUtils.isEmptyString((String)iconName)) {
            return 0;
        }
        try {
            int imageResource = this.context.getResources().getIdentifier(iconName, "drawable", this.context.getPackageName());
            if (imageResource > 0) {
                return imageResource;
            }
            imageResource = R.drawable.class.getField(iconName).getInt(null);
            if (imageResource > 0) {
                return imageResource;
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_NotificationBuilder getImageResourceId() : ", (Throwable)e);
        }
        return 0;
    }

    void addClickAndClearCallbacks(NotificationCompat.Builder builder) {
        Intent finalIntent = new Intent(this.context, MoEPushWorker.class);
        finalIntent.putExtras(this.notificationPayload.payload);
        finalIntent.setAction("ACTION_NOTIFICATION_CLEARED");
        PendingIntent intent = PendingIntent.getService((Context)this.context, (int)(this.notificationId | 0x1F5), (Intent)finalIntent, (int)0x8000000);
        builder.setDeleteIntent(intent);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this.context, (int)this.notificationId, (Intent)this.actionIntent, (int)0x8000000);
        builder.setContentIntent(contentIntent);
    }

    void addAutoDismissIfAny() {
        if (this.notificationPayload.autoDismissTime == -1L) {
            return;
        }
        Logger.v((String)("PushBase_4.2.03_NotificationBuilder addAutoDismissIfAny() : Dismiss time: " + this.notificationPayload.autoDismissTime));
        Intent finalIntent = new Intent(this.context, MoEPushReceiver.class);
        finalIntent.putExtra("MOE_ACTION_NOTIFICATION_AUTO_DISMISS", this.notificationId);
        finalIntent.setAction("MOE_ACTION_NOTIFICATION_AUTO_DISMISS");
        PendingIntent intent = PendingIntent.getBroadcast((Context)this.context, (int)this.notificationId, (Intent)finalIntent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
        alarmManager.set(0, this.notificationPayload.autoDismissTime * 1000L, intent);
    }
}

