/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.push;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.RestrictTo;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.MoEFileManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import com.moengage.core.executor.Task;
import com.moengage.core.executor.TaskManager;
import com.moengage.pushbase.MoEPushHelper;
import com.moengage.pushbase.activities.PushClickDialogTracker;
import com.moengage.pushbase.activities.PushTracker;
import com.moengage.pushbase.model.NotificationPayload;
import com.moengage.pushbase.model.TemplateTrackingMeta;
import com.moengage.pushbase.repository.PayloadParser;
import com.moengage.pushbase.repository.PushDAO;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public final class MoEngageNotificationUtils {
    private static final String TAG = "PushBase_4.2.03_MoEngageNotificationUtils";

    private MoEngageNotificationUtils() {
    }

    @Deprecated
    public static boolean isFromMoEngagePlatform(Bundle extras) {
        return MoEPushHelper.getInstance().isFromMoEngagePlatform(extras);
    }

    public static String convertBundleToJsonString(Bundle newBundle) {
        Set keys = newBundle.keySet();
        JSONObject jsonObject = new JSONObject();
        for (String key : keys) {
            try {
                jsonObject.put(key, newBundle.get(key));
            }
            catch (Exception e) {
                Logger.e((String)"PushBase_4.2.03_MoEngageNotificationUtils convertBundleToJsonString() : ", (Throwable)e);
            }
        }
        return jsonObject.toString();
    }

    public static void addPayloadToUri(Bundle extras, Uri.Builder uriBuilder) {
        try {
            if (null == extras || extras.isEmpty()) {
                return;
            }
            Set keySet = extras.keySet();
            for (String key : keySet) {
                Object value = extras.get(key);
                if (value == null) continue;
                uriBuilder.appendQueryParameter(key, String.valueOf(value));
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_MoEngageNotificationUtils getMoEngageExtrasAsUriParam :", (Throwable)e);
        }
    }

    public static boolean isReNotification(Bundle extras) {
        return extras.getBoolean("moe_re_notify", false);
    }

    @Deprecated
    public static boolean isFromMoEngagePlatform(Map<String, String> extras) {
        return MoEPushHelper.getInstance().isFromMoEngagePlatform(extras);
    }

    public static void logNotificationImpression(Context context, Bundle extras) {
        try {
            if (!MoEPushHelper.getInstance().isFromMoEngagePlatform(extras)) {
                return;
            }
            String campaignId = extras.getString("gcm_campaign_id", "");
            if (MoEUtils.isEmptyString((String)campaignId)) {
                Logger.v((String)"PushBase_4.2.03_MoEngageNotificationUtils logNotificationImpression() : Either campaign id is not present or empty string.");
                return;
            }
            Properties properties = new Properties();
            properties.setNonInteractive();
            if (campaignId.contains("DTSDK")) {
                campaignId = campaignId.substring(0, campaignId.indexOf("DTSDK"));
                extras.putString("gcm_campaign_id", campaignId);
            }
            properties.addAttribute("gcm_campaign_id", (Object)extras.getString("gcm_campaign_id"));
            MoEngageNotificationUtils.addAttributesToProperties(extras, properties);
            MoEHelper.getInstance((Context)context).trackEvent("NOTIFICATION_RECEIVED_MOE", properties);
        }
        catch (Exception e) {
            Logger.e((String)"PushMessageListener:trackNotification", (Throwable)e);
        }
    }

    public static void logNotificationClick(Context context, Intent intent) {
        try {
            Logger.v((String)"PushBase_4.2.03_MoEngageNotificationUtils logNotificationClick() : Will log notification click.");
            if (null == intent) {
                return;
            }
            Bundle extras = intent.getExtras();
            if (extras == null) {
                return;
            }
            if (!MoEPushHelper.getInstance().isFromMoEngagePlatform(extras)) {
                return;
            }
            String campaignId = extras.getString("gcm_campaign_id", "");
            if (MoEUtils.isEmptyString((String)campaignId)) {
                Logger.e((String)"PushBase_4.2.03_MoEngageNotificationUtils logNotificationClick() : Either campaign id is not present or empty string.");
                return;
            }
            Properties attributes = new Properties();
            if (campaignId.contains("DTSDK")) {
                campaignId = campaignId.substring(0, campaignId.indexOf("DTSDK"));
                extras.putString("gcm_campaign_id", campaignId);
            }
            attributes.addAttribute("gcm_campaign_id", (Object)campaignId);
            if (extras.containsKey("moe_action_id")) {
                attributes.addAttribute("gcm_action_id", (Object)extras.getString("moe_action_id"));
            }
            MoEngageNotificationUtils.addAttributesToProperties(extras, attributes);
            intent.removeExtra("moe_template_meta");
            intent.removeExtra("shownOffline");
            intent.removeExtra("moe_push_source");
            intent.removeExtra("from_appOpen");
            intent.removeExtra("moe_cid_attr");
            MoEHelper.getInstance((Context)context).trackEvent("NOTIFICATION_CLICKED_MOE", attributes);
            MoEngageNotificationUtils.updateClickToInbox(context, extras);
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_MoEngageNotificationUtils logNotificationClicked", (Throwable)e);
        }
    }

    public static void addAttributesToProperties(Bundle payload, Properties properties) {
        try {
            TemplateTrackingMeta meta;
            if (payload == null) {
                return;
            }
            if (payload.containsKey("shownOffline")) {
                properties.addAttribute("shownOffline", (Object)true);
            }
            if (payload.containsKey("moe_push_source")) {
                properties.addAttribute("source", (Object)payload.getString("moe_push_source"));
            }
            if (payload.containsKey("from_appOpen")) {
                properties.addAttribute("from_appOpen", (Object)Boolean.parseBoolean(payload.getString("from_appOpen")));
            }
            if (payload.containsKey("moe_template_meta") && (meta = (TemplateTrackingMeta)payload.getParcelable("moe_template_meta")) != null) {
                if (!MoEUtils.isEmptyString((String)meta.templateName)) {
                    properties.addAttribute("template_name", (Object)meta.templateName);
                }
                if (meta.cardId != -1) {
                    properties.addAttribute("card_id", (Object)meta.cardId);
                }
                if (meta.widgetId != -1) {
                    properties.addAttribute("widget_id", (Object)meta.widgetId);
                }
            }
            if (!payload.containsKey("moe_cid_attr")) {
                return;
            }
            JSONObject campaignAttributes = new JSONObject(payload.getString("moe_cid_attr"));
            if (campaignAttributes.length() == 0) {
                return;
            }
            Iterator keys = campaignAttributes.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = campaignAttributes.getString(key);
                properties.addAttribute(key, (Object)value);
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_MoEngageNotificationUtils addAttributesToBuilder() : ", (Throwable)e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void updateClickToInbox(Context context, Bundle pushPayload) {
        PushDAO.getInstance().updateNotificationClick(context, pushPayload);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void addNotificationToInboxIfRequired(Context context, Bundle extras) {
        try {
            Logger.v((String)"PushBase_4.2.03_MoEngageNotificationUtils addNotificationToInboxIfRequired() : Will try to add notification to inbox.");
            NotificationPayload payload = new PayloadParser().parsePayload(extras);
            if (payload.shouldIgnoreInbox) {
                Logger.v((String)"PushBase_4.2.03_MoEngageNotificationUtils addNotificationToInboxIfRequired() : Will not add notification to the inbox. Skip key added.");
                return;
            }
            PushDAO.getInstance().saveCampaign(context, payload);
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_MoEngageNotificationUtils addNotificationToInboxIfRequired() : Exception ", (Throwable)e);
        }
    }

    public static Intent getRedirectIntent(Context context, Bundle payloadBundle, int notificationId) {
        Intent pushTrackerIntent = new Intent(context, PushTracker.class);
        pushTrackerIntent.setAction("" + System.currentTimeMillis());
        pushTrackerIntent.setFlags(0x10000000);
        pushTrackerIntent.putExtras(payloadBundle).putExtra("MOE_NOTIFICATION_ID", notificationId);
        return pushTrackerIntent;
    }

    public static Intent getIntentForSnooze(Context context, Bundle payloadBundle, int notificationId) {
        Intent snoozeTrackerIntent = new Intent(context, PushClickDialogTracker.class);
        snoozeTrackerIntent.setFlags(0x10008000);
        snoozeTrackerIntent.putExtras(payloadBundle).putExtra("MOE_NOTIFICATION_ID", notificationId);
        return snoozeTrackerIntent;
    }

    public static void deleteImagesIfRequired(final Context context, final Bundle payload) {
        try {
            Task task = new Task(){

                public void execute() {
                    try {
                        PayloadParser payloadParser = new PayloadParser();
                        NotificationPayload notificationPayload = payloadParser.parsePayload(payload);
                        if (notificationPayload == null || MoEUtils.isEmptyString((String)notificationPayload.campaignId)) {
                            return;
                        }
                        if (notificationPayload.isPersistent) {
                            return;
                        }
                        MoEFileManager fileManager = new MoEFileManager(context);
                        if (fileManager.doesDirectoryExists(notificationPayload.campaignId)) {
                            fileManager.deleteFolder(notificationPayload.campaignId);
                        }
                    }
                    catch (Exception e) {
                        Logger.e((String)"PushBase_4.2.03_MoEngageNotificationUtils execute() : ", (Throwable)e);
                    }
                }
            };
            TaskManager.getInstance().execute(task);
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_MoEngageNotificationUtils deleteImagesIfRequired() : ", (Throwable)e);
        }
    }

    public static int transformToPx(Context context, int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static void createMoEngageChannels(Context context) {
        MoEngageNotificationUtils.createChannelIfRequired(context, "moe_default_channel", "General", true, false);
        MoEngageNotificationUtils.createChannelIfRequired(context, "moe_rich_content", "Rich Notification", false, true);
    }

    public static void createChannelIfRequired(Context context, String channelId, String channelName, boolean isVibrationEnabled, boolean shouldDisableSound) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        if (MoEngageNotificationUtils.isNotificationChannelExists(context, channelId)) {
            return;
        }
        NotificationManager manager = (NotificationManager)context.getSystemService("notification");
        NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)channelName, 3);
        channel.enableVibration(isVibrationEnabled);
        if (shouldDisableSound) {
            channel.setSound(null, null);
        }
        manager.createNotificationChannel(channel);
    }

    public static boolean isNotificationChannelExists(Context context, String channelId) {
        if (Build.VERSION.SDK_INT < 26) {
            return true;
        }
        NotificationManager manager = (NotificationManager)context.getSystemService("notification");
        return manager.getNotificationChannel(channelId) != null;
    }

    public static Bitmap scaleLandscapeBitmap(Context context, Bitmap imageBitmap) {
        if (imageBitmap == null) {
            return null;
        }
        if (imageBitmap.getWidth() > imageBitmap.getHeight()) {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            int height = imageBitmap.getHeight() * displayMetrics.widthPixels / imageBitmap.getWidth();
            try {
                imageBitmap = Bitmap.createScaledBitmap((Bitmap)imageBitmap, (int)displayMetrics.widthPixels, (int)height, (boolean)true);
            }
            catch (Exception e) {
                Logger.e((String)"PushBase_4.2.03_MoEngageNotificationUtils scaleBitmapToDeviceSpecs", (Throwable)e);
            }
        }
        return imageBitmap;
    }
}

