/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.push;

import android.app.IntentService;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Keep;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import com.moengage.pushbase.MoEPushHelper;
import com.moengage.pushbase.model.action.Action;
import com.moengage.pushbase.model.action.DismissAction;
import com.moengage.pushbase.push.MoEngageNotificationUtils;

@Keep
public class MoEPushWorker
extends IntentService {
    public static final String NOTIFICATION_CLEARED = "ACTION_NOTIFICATION_CLEARED";
    public static final String NOTIFICATION_CLOSE_CLICKED = "ACTION_NOTIFICATION_CLOSE_CLICK";
    private static final String TAG = "PushBase_4.2.03_MoEPushWorker";

    public MoEPushWorker() {
        super("RegistrationIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        try {
            if (intent == null) {
                return;
            }
            Logger.v((String)"PushBase_4.2.03_MoEPushWorker onHandleIntent() : Will process intent.");
            MoEUtils.dumpIntentExtras((String)TAG, (Bundle)intent.getExtras());
            String intentAction = intent.getAction();
            if (MoEUtils.isEmptyString((String)intentAction)) {
                return;
            }
            Logger.v((String)("PushBase_4.2.03_MoEPushWorker onHandleIntent() : Intent Action: " + intentAction));
            switch (intentAction) {
                case "ACTION_NOTIFICATION_CLEARED": {
                    this.handleNotificationCleared(intent);
                    break;
                }
                case "ACTION_NOTIFICATION_CLOSE_CLICK": {
                    this.dismissNotification(intent);
                }
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_MoEPushWorker onHandleIntent() : ", (Throwable)e);
        }
    }

    private void dismissNotification(Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras == null) {
            return;
        }
        MoEngageNotificationUtils.deleteImagesIfRequired(this.getApplicationContext(), extras);
        if (!extras.containsKey("moe_action")) {
            return;
        }
        Parcelable[] parcelables = extras.getParcelableArray("moe_action");
        if (parcelables == null || parcelables.length == 0) {
            return;
        }
        Parcelable parcelable = parcelables[0];
        if (parcelable == null) {
            return;
        }
        Action action = (Action)parcelable;
        if (!(action instanceof DismissAction)) {
            return;
        }
        DismissAction dismissAction = (DismissAction)action;
        if (dismissAction.notificationId == -1) {
            return;
        }
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        manager.cancel(dismissAction.notificationId);
        if (!extras.containsKey("gcm_campaign_id") && MoEUtils.isEmptyString((String)extras.getString("gcm_campaign_id"))) {
            Logger.e((String)"PushBase_4.2.03_MoEPushWorker dismissNotification() : Campaign Id not present.");
            return;
        }
        Properties properties = new Properties();
        properties.addAttribute("gcm_campaign_id", (Object)extras.getString("gcm_campaign_id"));
        MoEngageNotificationUtils.addAttributesToProperties(extras, properties);
        MoEHelper.getInstance((Context)this.getApplicationContext()).trackEvent(MoEConstants.NOTIFICATION_DISMISSED, properties);
    }

    private void handleNotificationCleared(Intent intent) {
        Logger.v((String)"PushBase_4.2.03_MoEPushWorker handleNotificationCleared() : ");
        Bundle extras = intent.getExtras();
        if (extras == null) {
            return;
        }
        MoEngageNotificationUtils.deleteImagesIfRequired(this.getApplicationContext(), extras);
        MoEPushHelper.getInstance().getMessageListener().onNotificationCleared(this.getApplicationContext(), extras);
    }
}

