/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushbase.push;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.fragment.app.FragmentActivity;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ActionManagerBase;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import com.moengage.pushbase.MoEPushHelper;
import com.moengage.pushbase.MoEPushReceiver;
import com.moengage.pushbase.activities.PushClickDialogTracker;
import com.moengage.pushbase.fragments.LaterDialogFragment;
import com.moengage.pushbase.model.action.Action;
import com.moengage.pushbase.model.action.CallAction;
import com.moengage.pushbase.model.action.CopyAction;
import com.moengage.pushbase.model.action.CustomAction;
import com.moengage.pushbase.model.action.DismissAction;
import com.moengage.pushbase.model.action.NavigationAction;
import com.moengage.pushbase.model.action.RemindLaterAction;
import com.moengage.pushbase.model.action.ShareAction;
import com.moengage.pushbase.model.action.SnoozeAction;
import com.moengage.pushbase.model.action.TrackAction;
import java.util.Calendar;

public class ActionManager
extends ActionManagerBase {
    private static final String TAG = "PushBase_4.2.03_ActionManager";

    public void onActionPerformed(Activity activity, Action action) {
        try {
            if (action == null || activity == null || MoEUtils.isEmptyString((String)action.actionType)) {
                return;
            }
            Logger.v((String)("PushBase_4.2.03_ActionManager onActionPerformed() : Action: " + action));
            switch (action.actionType) {
                case "navigate": {
                    this.navigationAction(activity, action);
                    break;
                }
                case "call": {
                    this.callAction(activity, action);
                    break;
                }
                case "share": {
                    this.shareAction(activity, action);
                    break;
                }
                case "track": {
                    this.trackAction(activity.getApplicationContext(), action);
                    break;
                }
                case "copy": {
                    this.copyAction(activity.getApplicationContext(), action);
                    break;
                }
                case "custom": {
                    this.customAction(activity.getApplicationContext(), action);
                    break;
                }
                case "snooze": {
                    this.snoozeAction(activity, action);
                    break;
                }
                case "remindLater": {
                    this.remindLaterAction(activity, action);
                    break;
                }
                case "dismiss": {
                    this.dismissAction(activity.getApplicationContext(), action);
                    break;
                }
                default: {
                    Logger.e((String)"PushBase_4.2.03_ActionManager onActionPerformed() : Did not find a suitable action.");
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.e((String)"PushBase_4.2.03_ActionManager onActionPerformed() : ", (Throwable)e);
        }
    }

    private void customAction(Context context, Action action) {
        if (!(action instanceof CustomAction)) {
            Logger.e((String)"PushBase_4.2.03_ActionManager customAction() : Not a valid custom action");
            return;
        }
        CustomAction customAction = (CustomAction)action;
        Logger.v((String)("PushBase_4.2.03_ActionManager customAction() : Action: " + customAction));
        MoEPushHelper.getInstance().getMessageListener().handleCustomAction(context, customAction.payload);
    }

    private void copyAction(Context context, Action action) {
        if (!(action instanceof CopyAction)) {
            Logger.v((String)"PushBase_4.2.03_ActionManager copyAction() : Not a valid copy action");
            return;
        }
        CopyAction copyAction = (CopyAction)action;
        Logger.v((String)("PushBase_4.2.03_ActionManager copyAction() : Action: " + copyAction));
        MoEHelperUtils.copyTextToClipboardAndShowToast((Context)context, (String)copyAction.textToCopy, (String)"");
    }

    private void shareAction(Activity context, Action action) {
        if (!(action instanceof ShareAction)) {
            Logger.v((String)"PushBase_4.2.03_ActionManager shareAction() : Not a valid share action");
            return;
        }
        ShareAction shareAction = (ShareAction)action;
        Logger.v((String)("PushBase_4.2.03_ActionManager shareAction() : Action: " + shareAction));
        this.triggerShareIntent((Context)context, shareAction.content);
    }

    private void callAction(Activity context, Action action) {
        if (!(action instanceof CallAction)) {
            Logger.v((String)"PushBase_4.2.03_ActionManager callAction() : Not a valid call action");
            return;
        }
        CallAction callAction = (CallAction)action;
        Logger.v((String)("PushBase_4.2.03_ActionManager callAction() : Action: " + callAction));
        if (MoEUtils.isEmptyString((String)callAction.number)) {
            return;
        }
        if (!this.isPhoneNumberValid(callAction.number)) {
            Logger.v((String)"PushBase_4.2.03_ActionManager callAction() : Not a valid phone number");
            return;
        }
        this.triggerCallIntent((Context)context, callAction.number);
    }

    private void snoozeAction(Activity activity, Action action) {
        if (!(action instanceof SnoozeAction)) {
            Logger.v((String)"PushBase_4.2.03_ActionManager snoozeAction() : Not a valid snooze action");
            return;
        }
        Intent intent = activity.getIntent();
        if (intent == null) {
            return;
        }
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return;
        }
        bundle.putBoolean("moe_re_notify", true);
        SnoozeAction snoozeAction = (SnoozeAction)action;
        Logger.v((String)("PushBase_4.2.03_ActionManager snoozeAction() : Action: " + snoozeAction));
        Context context = activity.getApplicationContext();
        if (snoozeAction.hoursAfterClick < 0 || snoozeAction.hoursAfterClick > 25) {
            return;
        }
        Intent laterIntent = new Intent(context, MoEPushReceiver.class);
        laterIntent.putExtras(MoEUtils.deepCopy((Bundle)bundle));
        laterIntent.setAction("MOE_ACTION_SHOW_NOTIFICATION");
        PendingIntent alarmPendingIntent = PendingIntent.getBroadcast((Context)activity.getApplicationContext(), (int)((int)System.currentTimeMillis()), (Intent)laterIntent, (int)0x8000000);
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, snoozeAction.hoursAfterClick);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.set(0, calendar.getTimeInMillis(), alarmPendingIntent);
        }
    }

    private void trackAction(Context context, Action action) {
        if (!(action instanceof TrackAction)) {
            Logger.v((String)"PushBase_4.2.03_ActionManager trackAction() : Not a valid track action");
            return;
        }
        TrackAction trackAction = (TrackAction)action;
        Logger.v((String)("PushBase_4.2.03_ActionManager trackAction() : Action: " + trackAction));
        if (MoEUtils.isEmptyString((String)trackAction.trackType) || MoEUtils.isEmptyString((String)trackAction.name)) {
            return;
        }
        switch (trackAction.trackType) {
            case "event": {
                Properties properties = new Properties();
                if (!MoEUtils.isEmptyString((String)trackAction.value)) {
                    properties.addAttribute("valueOf", (Object)trackAction.value);
                }
                MoEHelper.getInstance((Context)context).trackEvent(trackAction.name, properties);
                break;
            }
            case "userAttribute": {
                if (MoEUtils.isEmptyString((String)trackAction.value)) {
                    return;
                }
                MoEHelper.getInstance((Context)context).setUserAttribute(trackAction.name, trackAction.value);
                break;
            }
            default: {
                Logger.v((String)"PushBase_4.2.03_ActionManager trackAction() : Not a track type.");
            }
        }
    }

    private void navigationAction(Activity activity, Action action) {
        if (!(action instanceof NavigationAction)) {
            Logger.v((String)"PushBase_4.2.03_ActionManager navigationAction() : Not a valid navigation action");
            return;
        }
        NavigationAction navigationAction = (NavigationAction)action;
        Logger.v((String)("PushBase_4.2.03_ActionManager navigationAction() : Navigation action:" + navigationAction));
        Bundle payload = new Bundle();
        payload.putParcelable("moe_navAction", (Parcelable)navigationAction);
        payload.putBoolean("moe_isDefaultAction", false);
        MoEPushHelper.getInstance().getMessageListener().onHandleRedirection(activity, payload);
    }

    private void dismissAction(Context context, Action action) {
        if (!(action instanceof DismissAction)) {
            Logger.v((String)"PushBase_4.2.03_ActionManager dismissAction() : Not a valid dismiss action");
            return;
        }
        DismissAction dismissAction = (DismissAction)action;
        if (dismissAction.notificationId < -1) {
            return;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notificationManager != null) {
            notificationManager.cancel(dismissAction.notificationId);
        }
    }

    private void remindLaterAction(Activity activity, Action action) {
        if (!(action instanceof RemindLaterAction)) {
            Logger.v((String)"PushBase_4.2.03_ActionManager remindLaterAction() : Not a valid remind later action");
            return;
        }
        RemindLaterAction remindLaterAction = (RemindLaterAction)action;
        Logger.v((String)("PushBase_4.2.03_ActionManager remindLaterAction() : Remind later action: " + remindLaterAction));
        Intent intent = activity.getIntent();
        if (intent == null) {
            return;
        }
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("remindLater", (Parcelable)remindLaterAction);
        LaterDialogFragment dialogFragment = new LaterDialogFragment();
        dialogFragment.setItemSelected((PushClickDialogTracker)activity);
        dialogFragment.setArguments(bundle);
        dialogFragment.show(((FragmentActivity)activity).getSupportFragmentManager(), "laterDialog");
    }
}

